/*****************************************************************************
 FLIDEMO.C

 Demo program that plays VGL20.FLI, a flick file.  The flick is played
 directly to video memory the first time.  When you press a key, it is played
 again, but to a virtual screen this time.  This'll show you the differences
 between the two methods.

 Mark
 morley@camosun.bc.ca
*****************************************************************************/

#include "vgl.h"

char far VS[64000];

main()
{
   /* Enter mode 13h */
   vglInit();

   /* Play the flick directly to video memory */
   vglPlayFLI( "vgl20.fli", VIDMEM, 0 );

   /* Clear the screen */
   vglClear( 0 );

   /* Wait a moment */
   sleep( 1 );

   /* Setup our virtual screen */
   vglBuffer( VS );

   /* Play the flick into our virtual screen */
   vglPlayFLI( "vgl20.fli", VS, 0 );

   /* Return to text mode */
   vglTerm();

   return;
}
