/*
 *
 * cpu.h
 *
 *  cpu detecting
 *
 *  (c) Sampsa Lehtonen 1998, kyt vapaasti
 *
 */

#ifndef __CPU_H__
#define __CPU_H__

#pragma library ("cpu.lib");

#define CPU_CHIPS 7

typedef struct {

  char family, model, revision;
  char *description;

} CPU_CHIPSTRUCT;

typedef struct {

  char vendorID[16]; //only 12 first used
  char *vendorName;
  CPU_CHIPSTRUCT *chip;

  int chips;

} CPU_VENDORSTRUCT;

extern CPU_VENDORSTRUCT cpu_vendorList[CPU_CHIPS];

extern void cpu_getChipInfo(char *vendorName, char *chipName, int *speed);

extern int cpu_lastFamily;
extern int cpu_lastModel;
extern int cpu_lastRev;

//************************************
//************* pragmat

long cpu_featureFlag(void);
#pragma aux cpu_featureFlag = \
".586"\
"mov eax, 1"\
"CPUID"\
"mov eax, edx"\
modify [eax ebx ecx edx] value [eax];

void cpu_getVendorID(char *dest); //ATTENTION! Feed more than 16-byte-long string!
#pragma aux cpu_getVendorID = \
".586"\
"mov eax, 0"\
"CPUID"\
"mov [edi], ebx"\
"mov [edi+4], edx"\
"mov [edi+8], ecx"\
"mov [edi+12], 0"\
parm [edi] modify [eax ebx ecx edx];

void cpu_getChipID(char *dest); //ATTENTION! Feed more than 16-byte-long string!
#pragma aux cpu_getChipID = \
".586"\
"mov eax, 0x80000002"\
"CPUID"\
"mov [edi], eax"\
"mov [edi+4], ebx"\
"mov [edi+8], ecx"\
"mov [edi+12], edx"\
"mov eax, 0x80000003"\
"add edi, 16"\
"CPUID"\
"mov [edi], eax"\
"mov [edi+4], ebx"\
"mov [edi+8], ecx"\
"mov [edi+12], edx"\
"mov eax, 0x80000004"\
"add edi, 16"\
"CPUID"\
"mov [edi], eax"\
"mov [edi+4], ebx"\
"mov [edi+8], ecx"\
"mov [edi+12], edx"\
"mov [edi+16], byte ptr 0"\
parm [edi] modify [eax ebx ecx edx];

long cpu_processorType(void);
#pragma aux  cpu_processorType = \
"pushfd"\
"pop     eax"\
"mov     ebx,eax"\
"xor     eax,40000H"\
"push    eax"\ 
"popfd"\
"pushfd"\      
"pop     eax"\ 
"cmp eax, ebx"\
"jnz not386"\
"mov   eax,3"\      
"jmp outtahere"\
"not386:"\
"mov     ebx,eax    "\
"xor     eax,200000H"\
"push    eax"\        
"popfd      "\        
"pushfd     "\        
"pop     eax"\
"cmp eax, ebx"\
"jnz not486"\
"  mov   eax,4      "\
"jmp outtahere"\
"not486:"\
"mov     eax,1"\      
"cpuid"\              
"and     eax,0f00H"\
"shr     eax,8"\      
"outtahere:"\
modify [eax ebx ecx edx] value [eax];

#define CPU_FPU           0x00000001
#define CPU_MM_EXTENSION  0x00800000

#endif
