// KEYSCAN_C ////////////////////////////////////////////////////////////////

// Installs a new keyboard handler

// INCLUDES /////////////////////////////////////////////////////////////////

#include <bios.h>
#include "keyscan.h"

// EXTERNALS ////////////////////////////////////////////////////////////////

extern void interrupt newkbdhandler(...);
extern void interrupt (*oldkbdhandler)(...);
extern byte *keypressed;

// FUNCTIONS ////////////////////////////////////////////////////////////////

void interrupt newkbdhandler(...)
{
  char scan=inportb(0x60);
  pokeb(0,0x417,peekb(0,0x417)&223); // turn off numlock
  oldkbdhandler();
	int mod = bioskey(_NKEYBRD_SHIFTSTATUS);

  keypressed[scan&0x7f]=!(scan&0x80);
  keypressed[LALT]=(mod & LALT);
  keypressed[RALT]=(mod & RALT);
  keypressed[LCTRL]=(mod & LCTRL);
  keypressed[RCTRL]=(mod & RCTRL);
  keypressed[CAPSON]=(mod & CAPSON);
  keypressed[NUMON]=(mod & NUMON);
  keypressed[SCROLLON]=(mod & SCROLLON);
  keypressed[INSON]=(mod & INSON);
  poke(0x40,0x1c,peek(0x40,0x1a)); // clear kbd-buffer
}

// METHODS //////////////////////////////////////////////////////////////////

// CONSTRUCTOR

keyscan_C::keyscan_C()
{
  keypressed=new byte[128];
  for(int cl=0;cl<128;cl++)
    keypressed[cl]=0;
  oldkbdhandler=getvect(0x09);
  asm cli
  setvect(0x09,newkbdhandler);
  pokeb(0,0x417,peekb(0,0x417)&223); // turn off numlock
  pokeb(0,0x0500,1);
  asm sti
}

// DESTRUCTOR

keyscan_C::~keyscan_C()
{
  if (keypressed)
    delete keypressed;
  setvect(0x09,oldkbdhandler);
}


