// SCROLL.CPP

#include <stdlib.h>
#include <math.h>
#include <dos.h>
#include "stdio.h"
#include "timer.h"
#include "vx.h"

#define PI 3.14159265

extern timer_C timer;
extern vx_C vx;
extern byte *keypressed;

static byte *sdataseg1,*dataseg2,*bmp_ptr,*sdata_ptr;

#define BMPX		480
#define BMPY            32
#define CENTERX		160
#define CENTERY         120
#define OUTRAD          120
#define RADWIDTH	58
#define INRAD           (OUTRAD-RADWIDTH+1)
#define SDATA		59074
#define BMPDATA		(2*BMPX*BMPY)

#define FILELEN         59074

#define COLOR1		1
#define COLOR2		2

// DRAWSCROLL

// offset sdat=offset bmpdat=0 !

void drawscroll(word *sdat, word *bmpdat,word twist,word vrampos)
{
  word nextsp=0;
  long bmp_long=(long)bmpdat;
  long s_long=(long)sdat;

	asm mov ax,vrampos
	asm mov es,ax
	asm pusha

	for (byte qplan=0; qplan<4; qplan++)
	{
		asm mov cl,qplan
		asm mov ax,0x0100+MAP_MASK
		asm shl ah,cl
		asm mov dx,SC_INDEX
		asm out dx,ax

		asm push ds
		asm push bp

		asm lds ax,s_long
		asm mov ax,ds					// ax = dataseg (STACK)
		asm lds bx,bmp_long
		asm mov bx,ds
		asm add bx,twist			// bx = bmp-seg
		asm mov ds,bx
		asm mov cx,sp					// static: cx = sp
		asm mov dx,ss					// static: dx = ss

		asm mov bx,nextsp
		asm mov ss,ax
		asm mov ax,SDATA-50
		asm mov sp,ax					// sp = safe
		asm push bp						// bp = first on new stack

		asm mov bp,bx					// ok! here we go.
													// Scratch registers: ax, bx, si, di

		asm mov bx,79
		asm mov al,[bp]				// al = # of stripes
		asm inc bp
		asm jmp short next_strip
alone:
		asm mov si,[bp]
		asm inc bp
		asm inc bp
		asm movsb
		asm dec al
		asm jz done
next_strip:
		asm mov di,[bp]				// di = screenpos
		asm inc bp
		asm inc bp
		asm mov ah,[bp]				// ah = length of strip
		asm inc bp
// UNROLL!
		asm shr ah,1
		asm jnc parity
		asm jz alone
		asm mov si,[bp]				// si =x-ref
		asm inc bp
		asm inc bp
		asm movsb
		asm add di,bx
next_pixel:
parity:
		asm mov si,[bp]				// si =x-ref
		asm inc bp
		asm inc bp
		asm movsb
		asm add di,bx
		asm mov si,[bp]				// si =x-ref
		asm inc bp
		asm inc bp
		asm movsb
		asm add di,bx
		asm dec ah
		asm jnz next_pixel
		asm dec al
		asm jnz next_strip
done:
		asm mov ax,bp
		asm pop bp
		asm mov ss,dx
		asm mov sp,cx
		asm mov nextsp,ax
		asm pop bp
		asm pop ds
	}
	asm popa
}

// RUNSCROLL

void runscroll(void)
{
  FILE *file=fopen("LIGHTC.001","rb");
  fread(sdata_ptr,1,FILELEN,file);
  fclose(file);
  asm mov dx,GC_INDEX+1
  asm mov al,0xff
  asm out dx,al
	long stop,start,el;
  start=timer.readtimer();
  int twist=0;
  word vrampos=0xa000;
	long gone,herenow,timestamp[3],now=timer.readtimer();
  timestamp[0]=timestamp[1]=timestamp[2]=now;
  int timeroll=0;
  vx.setoffset(0);
  byte *line=new byte[320];
  FILE *back=fopen("lightc.003","rb");
  for(int y=0; y<240; y++)
  {
    int seg=0xa000+y*5;
    fread(line,1,320,back);
    for (byte plan=0; plan<4; plan++)
    {
      asm mov cl,plan
      asm mov ax,0x0100+MAP_MASK
      asm shl ah,cl
      asm mov dx,SC_INDEX
      asm out dx,ax
      for (int teller=0; teller<80; teller++)
			{
	pokeb(seg,teller,line[teller*4+plan]);
	pokeb(2400+seg,teller,line[teller*4+plan]);
	pokeb(1200+seg,teller,line[teller*4+plan]);
      }
    }
  }
  delete line;
  fclose(back);
  int done=0,donereq=0;
  int speed=1;
  do
  {
		drawscroll((word *)sdata_ptr,(word *)bmp_ptr,twist*2,vrampos);
		vx.setoffset((vrampos-0xa000)*16);
    vrampos+=1200;
		do
    {
      herenow=timer.readtimer();
      gone=timer.elapsed(timestamp[timeroll],herenow);
    } while (gone<43);
    timestamp[timeroll++]=herenow;
    if (timeroll==3)
      timeroll=0;

    if (vrampos==44560)
      vrampos=0xa000;
    twist=(twist+BMPX+speed);
    twist%=BMPX;
#define SEGSPLIT 12
#define SLICE	(BMPY*(BMPX/SEGSPLIT))
		asm cld
		if (keypressed[1])
			donereq=1;
		if ((donereq && !(twist%(BMPX/SEGSPLIT))) || done)
		{
      if (done<BMPX/SEGSPLIT)
      {
	long cl_ptr=(long)bmp_ptr;
	cl_ptr+=SLICE-BMPY-done*BMPY;
	asm les di,cl_ptr
	for (int teller=0; teller<2*SEGSPLIT; teller++)
	{
	  asm mov cx,BMPY/2
	  asm xor ax,ax
	  asm rep stosw
	  asm add di,SLICE-BMPY
	}
			}
      done++;
    }
	} while (done<BMPX/SEGSPLIT);
  stop=timer.readtimer();
  el=timer.elapsed(start,stop);
}

// SCROLLDATA

void scrolldata(void)
{
#if !SDATAOK
  FILE *file=fopen("LIGHTC.001","wb");
  vx.setoffset(0);
  for (int x=-OUTRAD; x<=OUTRAD; x++)
  {
    int maxwidth=sqrt((long)OUTRAD*OUTRAD-(long)x*x);
    for (int y=-maxwidth; y<=maxwidth; y++)
    {
      float radi=sqrt((long)x*x+(long)y*y);
      if (radi>=INRAD)
	vx.putpixel(x+CENTERX,y+CENTERY,1);
    }
  }
  FILE *mask=fopen("LIGHTC.003","rb");
  for (int y2=0; y2<240; y2++)
  for (int x2=0; x2<320; x2++)
	{
    byte temp;
    fread(&temp,1,1,mask);
    if (temp)
      vx.putpixel(x2,y2,0);
  }
  fclose(mask);
	word linjer,pixels=0;
  word *pos;
  pos=new word[2500];
	for (int plan=0; plan<4; plan++)
  {
    linjer=0;
    for (int x=plan; x<320; x+=4)
    {
      int run=0;
      for (int y=0; y<240; y++)
      {
	if (vx.getpixel(x,y)==COLOR1)
	{
	  if (!run)
	    pos[linjer++]=x/4+80*y;
	  pixels++;
	  run++;
	  vx.putpixel(x,y,COLOR2);
	}
	else
	{
	  run=0;
	}
      }
    }
		fwrite(&linjer,1,1,file);
    for (int teller=0; teller<linjer; teller++)
    {
			int p=pos[teller];
      fwrite(&p,1,2,file);
      int xx=(p%80)*4+plan;
      int yy=p/80;
      int scan=0;
      while (vx.getpixel(xx,yy+scan)==COLOR2)
	scan++;
			fwrite(&scan,1,1,file);
      for (int teller=0; teller<scan; teller++)
      {
	int ref=0;
	float dx=xx-CENTERX;
	float dy=yy-CENTERY;
	float len=sqrt(dx*dx+dy*dy)-INRAD;
	float prolen=BMPY*(len/RADWIDTH);
	ref=prolen;
	float vin;
	if (!dx)
	  dx=1e-5;
	if (!dy)
	  dy=1e-5;
	if (dx>=0)
	{
	  if (dy>=0)
	    vin=atan(dy/dx);
	  else
	    vin=2*PI-atan(-dy/dx);
	}
	else
	{
	  if (dy>=0)
	    vin=PI/2+atan(-dx/dy);
	  else
	    vin=PI+atan(dy/dx);
	}
	int slide=(vin*BMPX/(2*PI));
	ref+=BMPY*slide;
	fwrite(&ref,1,2,file);
	yy++;
      }
    }
  }
	delete pos;
  fclose(file);
#endif
}

// SCROLL

void scroll(void)
{
  sdataseg1=new byte[SDATA+32];
  dataseg2=new byte[BMPDATA+32];
  sdata_ptr=(byte *)((long)sdataseg1+65532l);
  for (word teller=0; teller<SDATA; teller++)
    sdata_ptr[teller]=0;
  bmp_ptr=(byte *)((long)dataseg2+65532l);
  FILE *bmpinn=fopen("LIGHTC.002","rb");
  fread(bmp_ptr,1,BMPDATA,bmpinn);
  for (int c=0; c<BMPX*BMPY; c++)
    bmp_ptr[BMPX*BMPY+c]=bmp_ptr[c];
  fclose(bmpinn);
#ifndef FERDIG
  scrolldata();
#endif
  runscroll();
  delete sdataseg1;
  delete dataseg2;
}

