/*
	MTFONT.CPP
	----------
	(c) PLOTSO 1997

*/
#include <string.h>
#include <stdio.h>
#include "mt.h"

int tx=0,ty=0;

void freefont(mtfont *fnt)
{
	if(fnt)
	{
		delete [] fnt->jono;
		for(int a=0;a<fnt->monta;a++) fnt->datat[a].free();
	}
}
mtfont *loadfont(char *fntfile)
{
	int a,b,c;
	mtfont *tmp=new mtfont;
	FILE *in=fopen(fntfile,"rb");
	if(!in) { MTerror=File;return 0; }

	fread(tmp->sign,7,1,in);
	if(strncmp(tmp->sign,"MTfont\032",7)) { MTerror=File;return 0; }

	tmp->monta=getw(in);

	tmp->jono=new char [tmp->monta];
	for(a=0;a<tmp->monta;a++) tmp->jono[a]=getc(in);

	int lev[256],kor[256];
	for(a=0;a<tmp->monta;a++) {lev[a]=getw(in); }
	for(a=0;a<tmp->monta;a++) { kor[a]=getw(in); }
	tmp->space=getw(in);
	tmp->enter=getw(in);

	for(a=0;a<tmp->monta;a++)
	{
		createbitmap(&tmp->datat[a],lev[a],kor[a]);
		if(!tmp->datat[a].data) { MTerror=Mem; return 0; }
	}
	for(a=0;a<tmp->monta;a++)
	{
		for(b=0;b<lev[a]*kor[a];b++)
			tmp->datat[a].data[b]=getc(in);
	}
	fclose(in);
	return tmp;
}
void mtwrite(int x,int y,char *str,mtfont *fnt,int minus,bitmap *dest)
{
	tx=x;ty=y;
	int a,b;
	for(a=0;a<strlen(str);a++)
	{
		if(str[a]==' ') { tx+=fnt->space; continue; }
		if(str[a]=='\n') { ty+=fnt->enter;tx=x; continue; }
		if(str[a]=='\r') { tx=0; continue; }

		for(b=0;b<fnt->monta;b++) if(fnt->jono[b]==str[a]) break;
		if(b==fnt->monta) continue;

		fnt->datat[b].putsprite(tx,ty-fnt->datat[b].kor,dest);
		tx+=fnt->datat[b].lev-minus;
	}
}
void mtputchar(int x,int y,char ch,mtfont *fnt,int minus,bitmap *dest)
{
	tx=x;ty=y;
	if(ch==' ') { tx+=fnt->space; return; }
	if(ch=='\n') { ty+=fnt->enter;tx=x; return; }
	if(ch=='\r') { tx=0; return; }

	int b;
	for(b=0;b<fnt->monta;b++) if(fnt->jono[b]==ch) break;
	if(b==fnt->monta) return;

	fnt->datat[b].putsprite(tx,ty-fnt->datat[b].kor,dest);
	tx+=fnt->datat[b].lev-minus;
}
void mtwritecol(int x,int y,char *str,mtfont *fnt,char col,int minus,bitmap *dest)
{
	tx=x;ty=y;
	int a,b;
	for(a=0;a<strlen(str);a++)
	{
		if(str[a]==' ') { tx+=fnt->space; continue; }
		if(str[a]=='\n') { ty+=fnt->enter;tx=x; continue; }
		if(str[a]=='\r') { tx=0; continue; }

		for(b=0;b<fnt->monta;b++) if(fnt->jono[b]==str[a]) break;
		if(b==fnt->monta) continue;

		fnt->datat[b].putspritecol(tx,ty-fnt->datat[b].kor,col,dest);
		tx+=fnt->datat[b].lev-minus;
	}
}
void mtputcharcol(int x,int y,char ch,mtfont *fnt,char col,int minus,bitmap *dest)
{
	tx=x;ty=y;
	if(ch==' ') { tx+=fnt->space; return; }
	if(ch=='\n') { ty+=fnt->enter;tx=x; return; }
	if(ch=='\r') { tx=0; return; }

	int b;
	for(b=0;b<fnt->monta;b++) if(fnt->jono[b]==ch) break;
	if(b==fnt->monta) return;

	fnt->datat[b].putspritecol(tx,ty-fnt->datat[b].kor,col,dest);
	tx+=fnt->datat[b].lev-minus;
}
