#include <dpmi.h>
#include <go32.h>
#include <sys/movedata.h>
#include <stdio.h>
#include <conio.h>

#include "pcx2.h"

/* DJGPP laajentaa esim. tavun kokoiset rakenteen kentt 4-tavuisiksi
   nopeuden takia ilman tt mrett, jos tm puuttuu
   palautettavista rakenteista on tieto tysin pin seini. Voit
   kokeilla. */
#define PACKED __attribute__ ((packed))

#define LINEAR(c) (((c&0xFFFF0000)>>12)+(c&0xFFFF))

#define MODEFLAG_BANKED   0x0000
#define MODEFLAG_LINEAR   0x4000
#define MODEFLAG_CLEAR    0x0000
#define MODEFLAG_PRESERVE 0x8000

typedef unsigned long int dword; /* Kaksoissana 4 tavua */
typedef unsigned short int word; /* Sana 2 tavua */
typedef signed long int s_dword; /* Etumerkillinen kaksoissana 4 tavua */
typedef signed short int s_word; /* Etumerkillinen sana 2 tavua */
typedef unsigned char byte;      /* Tavu */
typedef unsigned bit;            /* Bitti */

typedef struct {
  byte sign[4]            PACKED;
  word version            PACKED;
  dword OEMstring         PACKED;

  bit fixedDAC : 1        PACKED;
  bit VGAcompatible : 1   PACKED;
  bit RAMDACtype : 1      PACKED;
  bit reserved1 : 29      PACKED;

  dword videomodeptr      PACKED;
  word totalmemory        PACKED;

  word OEMsoftwarerev     PACKED;
  dword OEMvendornameptr  PACKED;
  dword OEMproductnameptr PACKED;
  dword OEMproductrevptr  PACKED;
  byte reserved2[222]     PACKED;
  byte OEMdata[256]       PACKED;
} VesaInformation;

typedef struct {
  bit modesupported : 1         PACKED;
  bit reserved : 1              PACKED;
  bit TTYsupported : 1          PACKED;
  bit colormode : 1             PACKED;
  bit graphicsmode : 1          PACKED;
  bit notVGAcompatible : 1      PACKED;
  bit notVGAwindowmemory : 1    PACKED;
  bit linearmodeavailable : 1   PACKED;
  bit reserved1 : 8             PACKED;

  bit Arelocatablewindows : 1   PACKED;
  bit Areadablewindow : 1       PACKED;
  bit Awritablewindow : 1       PACKED;
  bit reserved2 : 5             PACKED;

  bit Brelocatablewindows : 1   PACKED;
  bit Breadablewindow : 1       PACKED;
  bit Bwritablewindow : 1       PACKED;
  bit reserved3 : 5             PACKED;

  word windowgranularity        PACKED;
  word windowsize               PACKED;
  word windowAsegment           PACKED;
  word windowBsegment           PACKED;
  dword windowfunctionptr       PACKED;
  word bytesperscanline         PACKED;

  word horizontalresolution     PACKED;
  word verticalresolution       PACKED;
  byte characterwidth           PACKED;
  byte characterheight          PACKED;
  byte planes                   PACKED;
  byte bitsperpixel             PACKED;
  byte banks                    PACKED;
  byte memorymodel              PACKED;
  byte banksize                 PACKED;
  byte imagepages               PACKED;
  byte reserved4                PACKED;

  byte redbits                  PACKED;
  byte redshift                 PACKED;
  byte greenbits                PACKED;
  byte greenshift               PACKED;
  byte bluebits                 PACKED;
  byte blueshift                PACKED;
  byte reservedbits             PACKED;
  byte reservedshift            PACKED;

  bit programmablecolorramp : 1 PACKED;
  bit reservedbitsusable : 1    PACKED;
  bit reserved5 : 6             PACKED;

  dword physicalbasepointer     PACKED;
  dword offscreenmemoryoffset   PACKED;
  word offscreenmemorysize      PACKED;
  byte reserved6[206]           PACKED;
} VesaModeInformation PACKED;

dword dosbuffer;
dword dosselector;

VesaInformation *vesainfo;

dword vesalfb_linear;
s_dword vesalfb_segment;
word *vesascreen;

int VesaInt(byte function, __dpmi_regs *regs) {
  regs->h.ah=0x4F;
  regs->h.al=function;
  __dpmi_int(0x10, regs);

  if(regs->h.al != 0x4F) {
    puts("Funktio ei tuettu");
    return -1;
  }

  switch(regs->h.ah) {
    case 0x00:
         break;
    case 0x01:
         puts("Funktiokutsu eponnistui!");
         return 1;
    case 0x02:
         puts("Softa tukee funktiota, mutta rauta ei!");
         return 2;
    case 0x03:
         puts("Funktiokutsu virheellinen nykyisess videotilassa!");
         return 3;
    default:
         puts("Tuntematon virhe!");
         return 4;
  }

  return 0;
}


int VesaInit() {
  __dpmi_regs regs;

  dosbuffer=(dword)__dpmi_allocate_dos_memory(64, (int *)&dosselector);

  if(dosbuffer==-1) {
    puts("Ei tarpeeksi perusmuistia VESA-infoblokille!");
    return 1;
  }

  dosbuffer*=16; /* muutetaan lineaariseksi osoitteeksi (seg*16) */

  vesainfo=(VesaInformation *)malloc(sizeof(VesaInformation));
  memcpy(vesainfo->sign, "VBE2", 4);

  dosmemput(vesainfo, sizeof(VesaInformation), dosbuffer);

  regs.x.es=dosbuffer/16;
  regs.x.di=0;
  if(VesaInt(0x00, &regs)) {
    puts("Virhe VESA-keskeytyksess!");
    return 1;
  }

  dosmemget(dosbuffer, sizeof(VesaInformation), vesainfo);

  if(strnicmp(vesainfo->sign, "VESA", 4)!=0 || vesainfo->version<0x0200) {
    puts("not found!");
    return 1;
  }

  puts("found!");
  return 0;
}

/* Funktio ottaa fyysisen osoitteen muistiavaruudessa (physaddr) sek
   koon tavuissa (size) ja palauttaa linear-muuttujassa varatun alueen
   lineaarisen offsetin (linear), sek selektorin jota kytetn kun
   halutaan ksitell muistialuetta (segment, tt kytettess offset
   aina 0). Funktio palauttaa 0 jos onnistui, 1 jos ei */
int VesaMapPhysical(dword *linear, s_dword *segment,
                    dword physaddr, dword size) {
  __dpmi_meminfo meminfo;

  meminfo.address = physaddr;
  meminfo.size = size;

  if(__dpmi_physical_address_mapping(&meminfo) != 0)
    return 1;

  linear[0]=meminfo.address;
  __dpmi_lock_linear_region(&meminfo);
  segment[0]=__dpmi_allocate_ldt_descriptors(1);

  if(segment[0]<0) {
    segment[0]=0;
    __dpmi_free_physical_address_mapping(&meminfo);
    return 1;
  }

  __dpmi_set_segment_base_address(segment[0], linear[0]);
  __dpmi_set_segment_limit(segment[0], size-1);

  return 0;
}

void VesaDeinit() {
  __dpmi_free_dos_memory(dosselector);
}

/* Tm taasen vapauttaa muistin ksittelyyn varatut kahvat, kutsutaan
   kun palataan VESA-tilasta. */
void VesaUnmapPhysical(dword *linear, s_dword *segment) {
  __dpmi_meminfo meminfo;

  if(segment[0]) {
    __dpmi_free_ldt_descriptor(segment[0]);
    segment[0]=0;
  }

  if(linear[0]) {
    meminfo.address=linear[0];
    __dpmi_free_physical_address_mapping(&meminfo);
    linear[0]=0;
  }
}

/* Palauttaa 1 jos moodi ei ole olemassa */
int VesaGetModeInfo(word mode, VesaModeInformation *info) {
  __dpmi_regs regs;

  regs.x.cx=mode;
  regs.x.es=dosbuffer>>4;
  regs.x.di=0;
  if(VesaInt(0x01, &regs))
    return 1;

  dosmemget(dosbuffer, sizeof(VesaModeInformation), info);

  return 0;
}

/* Jlleen ei-nolla arvo tarkoittaa virhett */
int VesaSetMode(int mode, VesaModeInformation *modeinfo) {
  __dpmi_regs regs;

  regs.x.bx = mode | MODEFLAG_LINEAR | MODEFLAG_CLEAR;
  if(VesaInt(0x02, &regs))
    return 1;

  return VesaMapPhysical(&vesalfb_linear, &vesalfb_segment,
                         modeinfo->physicalbasepointer,
                         modeinfo->bytesperscanline*
                         modeinfo->verticalresolution);
}

/* Palauttaa 0 jos onnistui */
word * VesaSet640x480_16() {
  VesaModeInformation modeinfo;

  s_word mode=0;
  dword addr=LINEAR(vesainfo->videomodeptr);

  while(mode!=-1) {
    dosmemget(addr, 2, &mode);
    addr+=2;
    if(mode!=-1) {
      /* Jos virhe tulee jatketaan seuraavaan */
      if(VesaGetModeInfo(mode, &modeinfo))
        continue;
      
      if(modeinfo.linearmodeavailable &&
         modeinfo.horizontalresolution==640 &&
         modeinfo.verticalresolution==480 &&
         modeinfo.bitsperpixel==16) {
        if(VesaSetMode(mode, &modeinfo))
          return NULL;

        vesascreen = (word *)malloc(640*480*sizeof(word));
        return vesascreen;
      }
    }
  }
  return NULL;
}

void VesaReset() {
  textmode(0x03);
  VesaUnmapPhysical(&vesalfb_linear, &vesalfb_segment);
  free(vesascreen);
}

void VesaRefresh() {
  _movedatal(_my_ds(), (unsigned)vesascreen, vesalfb_segment, 0, 640*480*sizeof(word)/4);
}

int main() {
  word * buffer, * pic;
  
  pic=LoadPCX16("vesaexp.pcx");

  if(VesaInit())
    return 1;
  if((buffer=VesaSet640x480_16())==NULL)
    return 1;

  memcpy(vesascreen, pic, 640*480*sizeof(word));
  VesaRefresh();
  getch();
  
  VesaReset();
  VesaDeinit();

  free(pic);

  return 0;
}
