#include "quantiz2.h"

unsigned short Histogram[CS2];
COLOR ColorList[CS2];

unsigned char **Palette;
unsigned long **ColorSum;
unsigned long *ColorCount;
unsigned long Variance;

void InitQuantization2(int WantedColors) {
    int loop;

    Palette=(unsigned char **)Jmalloc(sizeof(unsigned char *)*WantedColors);
    ColorCount=(unsigned long *)Jmalloc(sizeof(unsigned long)*WantedColors);
    ColorSum=(unsigned long **)Jmalloc(sizeof(unsigned long *)*WantedColors);
    for(loop=0; loop<WantedColors; loop++) {
        Palette[loop]=(unsigned char *)Jmalloc(sizeof(unsigned char)*3);
        ColorSum[loop]=(unsigned long *)Jmalloc(sizeof(unsigned long)*3);
    }

    for(loop=0; loop<CS2; loop++)
        Histogram[loop]=0;
}

void DeinitQuantization2(int WantedColors) {
    int loop;

    for(loop=0; loop<WantedColors; loop++) {
        free(Palette[loop]);
        free(ColorSum[loop]);
    }
    free(Palette);
    free(ColorCount);
    free(ColorSum);
}

void AddImage2(unsigned char *Buffer, unsigned char *Palette, int bytes) {
    int loop;

    for(loop=0; loop<bytes; loop++)
      Histogram[ RGB2(Palette[Buffer[loop]*3+0],
                      Palette[Buffer[loop]*3+1],
                      Palette[Buffer[loop]*3+2]) ]++;
}

unsigned char *Quantisize2(int WantedColors, unsigned char *Cube) {
    int loop, ColorsUsed=0, color, r, g, b;
    unsigned char *Optimal=(unsigned char *)Jmalloc(768);

    for(loop=0; loop<CS2; loop++) {
        if(Histogram[loop]) {
            ColorList[ColorsUsed].r=R2(loop);
            ColorList[ColorsUsed].g=G2(loop);
            ColorList[ColorsUsed].b=B2(loop);
            ColorList[ColorsUsed].count=Histogram[loop];
            ColorsUsed++;
        }
    }

    printf("Used colors %d\n", ColorsUsed);

    if(ColorsUsed>WantedColors) {
        for(loop=0; loop<256; loop++) {
            Palette[loop][0]=ColorList[loop].r;
            Palette[loop][1]=ColorList[loop].g;
            Palette[loop][2]=ColorList[loop].b;
        }

        do {
            for(loop=0; loop<ColorsUsed; loop++) {
                r=ColorList[loop].r;
                g=ColorList[loop].g;
                b=ColorList[loop].b;

                color=Nearest(r, g, b, WantedColors);

                ColorSum[color][0]+=r*ColorList[loop].count;
                ColorSum[color][1]+=g*ColorList[loop].count;
                ColorSum[color][2]+=b*ColorList[loop].count;
                ColorCount[color]+=ColorList[loop].count;
            }

            Variance=0;

            for(loop=0; loop<WantedColors; loop++) {
                if(ColorCount[loop]>0) {
                    r=ColorSum[loop][0]/ColorCount[loop];
                    g=ColorSum[loop][1]/ColorCount[loop];
                    b=ColorSum[loop][2]/ColorCount[loop];
                } else {
                    color=rand()%ColorsUsed;
                    r=ColorList[color].r;
                    g=ColorList[color].g;
                    b=ColorList[color].b;
                }

                Variance+=abs(r-Palette[loop][0]);
                Variance+=abs(g-Palette[loop][1]);
                Variance+=abs(b-Palette[loop][2]);

                Palette[loop][0]=r;
                Palette[loop][1]=g;
                Palette[loop][2]=b;
            }

            memset(ColorCount, 0, sizeof(unsigned long)*WantedColors);
            for(loop=0; loop<WantedColors; loop++)
                memset(ColorSum[loop], 0, sizeof(unsigned long)*3);
        } while(Variance>MAXVARIANCE);
    } else {
        for(loop=0; loop<ColorsUsed; loop++) {
            Palette[loop][0]=ColorList[loop].r;
            Palette[loop][1]=ColorList[loop].g;
            Palette[loop][2]=ColorList[loop].b;
        }
        for(; loop<WantedColors; loop++) {
            Palette[loop][0]=0;
            Palette[loop][1]=0;
            Palette[loop][2]=0;
        }
    }

    for(loop=0; loop<32*32*32; loop++)
        Cube[loop]=Nearest(R2(loop), G2(loop), B2(loop), WantedColors);

    for(loop=0; loop<WantedColors; loop++) {
        Optimal[loop*3+0]=Palette[loop][0]*2;
        Optimal[loop*3+1]=Palette[loop][1]*2;
        Optimal[loop*3+2]=Palette[loop][2]*2;
    }

    return Optimal;
}

inline unsigned long Dist(int r1, int g1, int b1, int r2, int g2, int b2) {
    int r=r1-r2, g=g1-g2, b=b1-b2;

    return r*r + g*g + b*b;
}

unsigned char Nearest(int r, int g, int b, int Wanted) {
    int loop, shortest=100000, sl, dist;

    sl=0;
    for(loop=0; loop<Wanted; loop++) {
        dist=Dist(r, g, b,
                  Palette[loop][0], Palette[loop][1], Palette[loop][2]);
        if(dist<shortest) {
            shortest=dist;
            sl=loop;
        }
    }

    return sl;
}

void *Jmalloc(size_t size) {
    void *tmp=calloc(size, 1);

    if(tmp==NULL) {
        puts("Not enough memory!");
        exit(1);
    }

    return tmp;
}

/* Display on nopeasti kokoonkyhtty funktio kahden 256*256 kuvan
   nyttmiseksi VGA:n ruudulla kytten kvantisoitua palettia */
void Display(unsigned char *Image1, unsigned char *Image2, 
             unsigned char *Palette1, unsigned char *Palette2,
             unsigned char *PaletteArray) {
    int loop1, loop2, color, r, g, b;

    for(loop1=0; loop1<200; loop1++) {
        for(loop2=0; loop2<160; loop2++) {
            color=Image1[loop1*256+loop2];
            r=Palette1[color*3+0]/2;
            g=Palette1[color*3+1]/2;
            b=Palette1[color*3+2]/2;
            color=PaletteArray[RGB2(r,g,b)];

            putpixel(loop2, loop1, color);
        }
        for(loop2=0; loop2<160; loop2++) {
            color=Image2[loop1*256+loop2];
            r=Palette2[color*3+0]/2;
            g=Palette2[color*3+1]/2;
            b=Palette2[color*3+2]/2;
            color=PaletteArray[RGB2(r,g,b)];

            putpixel(loop2+160, loop1, color);
        }
    }
}

/* LoadPCX lataa normaalisti 256-vrisen PCX-kuvan paletteineen */
void LoadPCX(char *Filename, unsigned char *Buffer, unsigned char *Palette) {
    FILE *handle=fopen(Filename, "rb");
    unsigned long tavu,tavu2, c, maxx, maxy;

    if(handle==NULL) {
        puts("Can't open PCX file!");
        exit(1);
    }

    fseek(handle,8,SEEK_SET);
    maxx=fgetc(handle) + (fgetc(handle) << 8) +1;
    maxy=fgetc(handle) + (fgetc(handle) << 8) +1;

    fseek(handle,128,SEEK_SET);
    for(c=0; c<maxy*maxx;) {
        tavu=fgetc(handle);
        if(tavu>192) {
            tavu2=fgetc(handle);
            for(;tavu>192;tavu--)
	            Buffer[c++]=tavu2;
        } else Buffer[c++]=tavu;
    }
    fseek(handle, -768, SEEK_END);

    for(c=0; c<768; c++) {
        Palette[c]=fgetc(handle)/4;
    }

    fclose(handle);
}

/* Asettaa halutun paletin */
void SetPalette(unsigned char *Palette) {
    int c;

    outportb(0x3C8, 0);
    for(c=0; c<256*3; c++)
        outportb(0x3C9, Palette[c]);
}

int main() {
    unsigned char Palette1[768], Palette2[768], 
      Image1[256*256], Image2[256*256];
    unsigned char *PaletteArray=(unsigned char *)malloc(CS2);
    unsigned char *OptimalPalette;

    if(PaletteArray==NULL)
        return 1;

    memset(PaletteArray, 0, RS2*GS2*BS2);
    InitQuantization2(256);

    LoadPCX("QESIM1.PCX", Image1, Palette1);
    LoadPCX("QESIM2.PCX", Image2, Palette2);
    AddImage2(Image1, Palette1, 256*256);
    AddImage2(Image2, Palette2, 256*256);

    OptimalPalette=Quantisize2(256, PaletteArray);
    textmode(0x13);
    SetPalette(OptimalPalette);
    free(OptimalPalette);
    Display(Image1, Image2, Palette1, Palette2, PaletteArray);

    getch();
    DeinitQuantization2(256);
    textmode(0x03);
    return 0;
}
