#ifndef __PCX2_H
#define __PCX2_H

#include <string.h>
#include <stdlib.h>
#include <io.h>

/* Tm PCX-laturi lataa koko tiedostoon puskuriin ja purkaa tiedot
   sielt, nopeampaa ja muutenkin mukavempaa. Lisksi x ja y
   palautetaan haluttaessa (aseta arvoksi NULL jos et halua niit.
   Lisksi lataaja varaa itse muistin, joten en ei tarvitse huolehtia
   onko puskuri oikean kokoinen. */
unsigned char * LoadPCX(char filename[], int *x, int *y) {
  int xsize, ysize, tavu1, tavu2, position=0;
  FILE *handle=fopen(filename, "rb");
  unsigned char * buffer;
  unsigned char * tmp;
  int size, fpos;

  if(handle==(FILE *)-1) {
    printf("Virhe PCX-tiedoston avauksessa: Tiedostoa ei lydy!\n");
    exit(1);
  }

  size=filelength(fileno(handle));
  tmp=(unsigned char *)malloc(size);

  fread(tmp, size, 1, handle);
  fclose(handle);

  fpos=8;

  xsize=tmp[fpos]+(int)(tmp[fpos+1]<<8)+1; fpos+=2;
  ysize=tmp[fpos]+(int)(tmp[fpos+1]<<8)+1; fpos+=2;

  buffer = (unsigned char *) malloc(xsize*ysize);

  fpos=128;
  while(position<(xsize*ysize)) {
    tavu1=tmp[fpos++];
    if(tavu1>192) {
      tavu2=tmp[fpos++];
      for(; tavu1>192; tavu1--)
        buffer[position++]=tavu2;
    } else buffer[position++]=tavu1;
  }

  if(x!=NULL)
    *x=xsize;
  if(y!=NULL)
    *y=ysize;

  free(tmp);

  return buffer;
}

/* Tmkin osaa ladata paletin yhten palana ja varata muistin sille. */
unsigned char * LoadPAL(char filename[]) {
  FILE *handle=fopen(filename, "rb");
  unsigned char * palette;

  if(handle==(FILE *)-1) {
    printf("The PCX file %s could not be found!\n", filename);
    exit(1);
  }

  palette = (unsigned char *)malloc(768);
  fseek(handle,-768,SEEK_END);
  fread(palette, 3, 256, handle);
  fclose(handle);

  return palette;
}

void ConvertImage16(unsigned short * buf, unsigned char * orig,
                    unsigned char * pal, int x, int y) {
  int loop, color;

  for(loop=0; loop<x*y; loop++) {
    color=orig[loop];
    buf[loop]=( ( pal[color*3+0] >> 3 ) << 11 ) + /* 8->5 ja siirretn 11 */
              ( ( pal[color*3+1] >> 2 ) << 5  ) + /* 8->6 ja siirretn 5  */
              ( ( pal[color*3+2] >> 3 ) << 0  );  /* 8->5                  */
  }
}

/* Apufunktio, joka lataa 256-vrisen PCX-kuvan, konvertoi sen 16-bittiseksi
   ja palauttaa tmn 16-bittisen puskurin. Pitisi toimia kaiken kokoisilla
   kuvilla. Ainakin melkein. */
unsigned short * LoadPCX16(char name[]) {
  int x, y;
  unsigned char *tm, *tp;
  unsigned short *ts;

  tm=LoadPCX(name, &x, &y);
  tp=LoadPAL(name);

  ts=(unsigned short *)malloc(x*y*2);

  ConvertImage16(ts, tm, tp, x, y);

  free(tm);
  free(tp);

  return ts;
}
#endif
