#ifndef __BITMAP_H
#define __BITMAP_H

typedef struct {
    char *bitmap;
    char *background;
    int x;
    int y;
    int xsize;
    int ysize;
    int xspeed;
    int yspeed;
} BITMAP;

void bdraw(BITMAP *b) {
    int y=b->y,
        x=b->x,
        yy, xx;

    /* Eli loopataan koko suorakulman kokoinen alue. bitmap- ja
       ja background -puskureissahan lasketaan sijainti seuraavasti:
       y * b->xsize + x. */
    for(yy=0; yy<b->ysize; yy++) { 
    for(xx=0; xx<b->xsize; xx++) {
        /* eli vrill 0 tm vertailu alla ei ole tosi, joten vrill
           0 merkittyj kohtia EI piirret! */
        if(b->bitmap[yy*b->xsize+xx]) {
            /* doublebuffer muuttuja osoittaa kaksoispuskuriin. Huomaa, ett
               ylkulma on y*320+x, mutta koska haluamme viel piirt useita
               rivej, lismme yy-looppimme y-arvoon, kutenn mys xx-looppi
               x-arvoon. Jos et ymmrtnyt niin poista vliaikaisesti kohdat
               ja net mit tapahtuu */
            b->background[yy*b->xsize+xx]=
                doublebuffer[ (y+yy) * 320 + (x+xx) ];

            /* sitten vain asetetaan bittikartasta oikea kohta ruudulle,
               alle peittyv osa on jo tallessa puskurin background vastaa-
               valla kohdalla. */
            doublebuffer[ (y+yy) * 320 + (x+xx) ]=
                b->bitmap[yy*b->xsize+xx];
        }
    }
    }
}

void bhide(BITMAP *b) {
    int y=b->y,
        x=b->x,
        yy, xx;

    /* Eli loopataan koko suorakulman kokoinen alue. bitmap- ja
       ja background -puskureissahan lasketaan sijainti seuraavasti:
       y * b->xsize + x. */
    for(yy=0; yy<b->ysize; yy++) { 
    for(xx=0; xx<b->xsize; xx++) {
        /* eli vrill 0 tm vertailu alla ei ole tosi, joten vrill
           0 merkittyj kohtia EI piirret! */
        if(b->bitmap[yy*b->xsize+xx]) {
            doublebuffer[ (y+yy) * 320 + (x+xx) ]=
                b->background[yy*b->xsize+xx];
        }
    }
    }
}

void bmove(BITMAP *b) {
    b->x+=b->xspeed;
    b->y+=b->yspeed;
}

void bsetlocation(BITMAP *b, int x, int y) {
    b->x=x;
    b->y=y;
}

void bsetspeed(BITMAP *b, int xspeed, int yspeed) {
    b->xspeed=xspeed;
    b->yspeed=yspeed;
}

void bload(BITMAP *b, int x, int y, int xspeed, int yspeed, int xsize,
    int ysize, char *bitmapbuffer, int bufferx, int buffery, 
    int bufferxs) {
    int yy, xx;

    bsetlocation(b, x, y);
    bsetspeed(b, xspeed, yspeed);
    b->xsize=xsize;
    b->ysize=ysize;

    b->bitmap=(char *)malloc(xsize*ysize);
    b->background=(char *)malloc(xsize*ysize);
    if(b->background==NULL || b->background==NULL) {
        printf("Ei tarpeeksi muistia bitmap-puskureille!\n");
        exit(1);
    }
    
    /* Eli loopataan koko suorakulman kokoinen alue. bitmap-
       puskurissahan lasketaan sijainti seuraavasti:
       y * b->xsize + x. */
    for(yy=0; yy<ysize; yy++) { 
    for(xx=0; xx<xsize; xx++) {
        /* doublebuffer muuttuja osoittaa kaksoispuskuriin. Huomaa, ett
           ylkulma on y*320+x, mutta koska haluamme viel piirt useita
           rivej, lismme yy-looppimme y-arvoon, kutenn mys xx-looppi
           x-arvoon. Jos et ymmrtnyt niin poista vliaikaisesti kohdat
           ja net mit tapahtuu */
        b->bitmap[yy*xsize+xx]=
            bitmapbuffer[ (buffery+yy) * bufferxs + (bufferx+xx) ];
    }
    }
}

#endif
