/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */

/* strip the pallete out of an image file */

#include <stdio.h>
#include <jlib.h>

int main(int argc, char *argv[])
{
  FILE *new;
  UBYTE *pal=NULL;
  image *img=NULL;

  if(argc!=3){
	      printf("strippal - strip the palette of a .pcx or .jlb into a seperate file.\n");
	      printf("Usage: strippal <infile> <outfile> \n");
	      printf("Where: <infile>  = image file to get palette from.\n");
	      printf("Where: <outfile> = file to put palette into.\n");
	      exit(-1);
  }

  /* try to load as .jlb then .pcx */
  if((img=image_load_jlb(argv[1]))!=NULL){
     pal=IMG_PALETTE(img);
  }
  else{
     if((img=image_load_pcx(argv[1]))!=NULL){
        pal=IMG_PALETTE(img);
     }        
     else{
        puts("couldn't load image as .jlb or .pcx.\n");
        return 0;
     }
  }
  
  if((new=fopen(argv[2],"wb"))==NULL){
     printf(" ERROR: Could not open file %s for writing.",argv[2]);
     exit(-1);
  }

  fwrite(pal,(SCREEN_NUM_COLORS*3),1,new);
  fclose(new);

  puts("palette written.\n");
   
  return(0);
}
