#include "xm.h"
#include "structs.h"
#include "ialot.h"

extern unsigned char error[]; /* error string */
extern samrec samples[];
extern gpoke_type gpoke;
extern module_type module;
extern output_type _output;
extern void free_mod();
extern instrument_type *instruments;


#define PACKED __attribute__ ((packed))
#pragma pack(1)
struct
{
 char id_text[17] PACKED; /* 'Extended Module: ' */
 char module_name[20] PACKED;
 char __0x1a_ PACKED;
 char tracker_name[20] PACKED;
 unsigned short version_number PACKED; /* hi-byte major and low-byte minor, 0x104 */
 unsigned int header_size PACKED; /* FROM THIS OFFSET, not from the beginning of the file! */
 unsigned short song_length PACKED; /* in pattern order table */
 unsigned short restart_position PACKED; /* modeissakin on, mutta siell this is ignored */
 unsigned short number_of_channels PACKED; /* thank god */
 unsigned short number_of_patterns PACKED; /* empty patterns not included */
 unsigned short number_of_instruments PACKED; /* max 128 */
 unsigned short flags PACKED; /* bit 0: 0 = amiga freq. table, 1 linear */
 unsigned short i_tempo PACKED;
 unsigned short i_bpm PACKED;
 unsigned char order_table[256] PACKED;
} xm_header;

#pragma pack(1)
struct
{
 unsigned int header_length PACKED;
 unsigned char packing_type PACKED; /* always 0 */
 unsigned short number_of_rows PACKED; /* 1-256 !!! */
 unsigned short packed_size PACKED; /* might be 0 if no data follows */
} xm_pat_header;

#pragma pack(1)
struct
{
 unsigned int instrument_header_size PACKED;
 char instrument_name[22] PACKED;
 unsigned char instrument_type PACKED; // random
 unsigned short number_of_samples_in_instrument PACKED;
} xm_inst_header;

#pragma pack(1)
struct // if number of samples in instrument > 0 then this follows
{
 unsigned int sample_header_size PACKED;
 unsigned char sample_number_for_all_notes[96] PACKED;
// unsigned char points_for_volume_envelope[48] PACKED;
// unsigned char points_for_panning_envelope[48] PACKED;
 unsigned short points_for_volume_envelope[24] PACKED;
 unsigned short points_for_panning_envelope[24] PACKED;
 unsigned char number_of_volume_points PACKED;
 unsigned char number_of_panning_points PACKED;
 unsigned char volume_sustain_point PACKED;
 unsigned char volume_loop_start_point PACKED;
 unsigned char volume_loop_end_point PACKED;
 unsigned char panning_sustain_point PACKED;
 unsigned char panning_loop_start_point PACKED;
 unsigned char panning_loop_end_point PACKED;
 unsigned char volume_type PACKED; // bit 0: On; 1: Sustain; 2: Loop
 unsigned char panning_type PACKED; // bit 0: On; 1: Sustain; 2: Loop
 unsigned char vibrato_type PACKED;
 unsigned char vibrato_sweep PACKED;
 unsigned char vibrato_depth PACKED;
 unsigned char vibrato_rate PACKED;
 unsigned short volume_fadeout PACKED;
 unsigned short reserved PACKED;
} xm_extended_inst_header;

#pragma pack(1)
typedef struct
{
 unsigned int sample_length PACKED;
 unsigned int sample_loop_start PACKED;
 unsigned int sample_loop_length PACKED;
 unsigned char volume PACKED;
 signed char finetune PACKED; // (signed byte -16..+15)
 unsigned char type PACKED; // Bit 0-1: 0 = No loop, 1 = Forward loop,
                            //          2 = Ping-pong loop;
                            // bit 4: 16-bit sampledata
 unsigned char panning PACKED; // 0-255
 signed char relative_note_number PACKED; // signed byte
 unsigned char reserved PACKED;
 char sample_name[22] PACKED;
} xm_sample_header_type;
#pragma pack()

void mute_pattern(pattern_type *pattern, unsigned int channels)
{
 int b, a, paik;

 for (b=0;b<pattern->rows;b++)
  for (a=0;a<channels;a++)
  {
    paik = (5 * b * module.channels) + 5 + a * 5;

    pattern->data[paik]   = _nothing;
    pattern->data[paik+1] = _nothing;
    pattern->data[paik+2] = 0;
    pattern->data[paik+3] = 0;
    pattern->data[paik+4] = 0; // with xm, volume column 0 means nothing
  }
}

int new_pattern(pattern_type *pattern, unsigned int o, unsigned int rows, unsigned int channels)
{
 memset(&pattern[o], 0, sizeof(pattern_type));

 pattern[o].rows = rows;
 pattern[o].data = (char *)malloc(5 * rows * channels + 10);
 if (pattern[o].data == NULL)
 {
   strcat(error, "new_pattern: out of memory.\n");
   return -1;
 }

 memset(pattern[o].data, 0, 5 * rows * channels + 10);

// mute_pattern(pattern, channels);
 return 0;
}

#pragma pack()
int load_xm(char *name)
{
 FILE *f;
 unsigned int i,a,where_to_seek,xms_samples,b,totalsamples = 0,paik;
 unsigned char b1,b2;
 xm_sample_header_type xm_sample_header[97];
 unsigned char instrument_used[130];

 unsigned int sample_count = 0;
 unsigned int loadlist_offset[130];
 unsigned char loadlist_flags[130];
 unsigned char loadlist_index[130];

 signed int old, uusi;
 signed char *smpbuf8;
 signed short *smpbuf16;

 unsigned int efu, efpar;

 memset(instrument_used, 0, 130);
 memset(loadlist_offset, 0, 130*4);
 memset(loadlist_flags, 0, 130);
 memset(loadlist_index, 0, 130);

 f=fopen(name,"rb");
 if (f==NULL) { return -1; }
 fseek(f,0 + module.file_offset,SEEK_SET);
 fread(&xm_header,1,sizeof(xm_header),f);
// printf("id_text: %s",xm_header.id_text);
// printf("\n\n");
// printf("module name: %s",xm_header.module_name);
// printf("\n\n");
// printf("version number: 0x%X \n",xm_header.version_number);

 if ((int)strstr(xm_header.id_text,"Extended Module:") == NULL)
 {
   strcat(error,"load_xm: not a XM module.\n");
   return -1;
 }

 if (xm_header.version_number!=0x104)
 {
   strcat(error,"load_xm: not a valid XM module.\n");
   return -1;
 }

 instruments = (instrument_type *)malloc(xm_header.number_of_instruments *
   sizeof(instrument_type));

 memset(instruments, 0, sizeof(instrument_type) *
   xm_header.number_of_instruments);

 strncpy(module.title, xm_header.module_name, 20);
 module.title[20]    = 0;
 module.minporta     = 1;
 module.maxporta     = 100000;
 module.max_volume   = 64;
 module.init_master  = 64;
 module.maxsamples   = 128;
 module.maxinstrus   = xm_header.number_of_instruments;
 module.length       = xm_header.song_length;
 module.patterns     = xm_header.number_of_patterns - 1;
 module.speed        = xm_header.i_tempo;
 module.bpm          = xm_header.i_bpm;
 module.channels     = xm_header.number_of_channels;
 module.type         = XM;
 module.linear_freq  = (xm_header.flags & 1);
 module.fast_vslides = 0;
 memcpy(&module.order[1],&xm_header.order_table,256);

 printf("loading %d-channel XM module called '%s' ..",
   module.channels, module.title);
 fflush(stdout);

 for (i = 1; i <= module.channels; i++)
  module.initial_pan[i] = 0x80;

// printf("channels: %d\n",module.channels); fflush(stdout);
// getch();

 fseek(f,60 + xm_header.header_size + module.file_offset,SEEK_SET); /* seek to where the pattern data begins */

// is there 'extra' patterns in the order table?

 for (i = 1; i <= module.length; i++)
 {
   if (module.order[i] > module.patterns) module.patterns = module.order[i];
 }

// allocate pattern structures
 module.pattern =
   (pattern_type*)malloc((module.patterns + 1) * sizeof(pattern_type));

// fix this: allocate the empty patterns :
 if ((xm_header.number_of_patterns-1) != module.patterns)
   for (i = xm_header.number_of_patterns; i <= module.patterns; i++)
     if (new_pattern(module.pattern, i, 64, module.channels) == -1)
     {
       strcat(error,"load_xm: unable to load module.\n");
       return -1;
     }

// printf("reading patterns.."); fflush(stdout);
// read the patterns that actually are in the file :
 for (i = 0; i < xm_header.number_of_patterns; i++)
 {
//   printf("reading pattern #%u\n",i);
   where_to_seek = ftell(f);
   fread(&xm_pat_header,1,sizeof(xm_pat_header),f);
   where_to_seek += xm_pat_header.header_length + xm_pat_header.packed_size;
   if (xm_pat_header.packed_size != 0)
   {
//     printf("frows: %d\n",xm_pat_header.number_of_rows); fflush(stdout);
     if (-1 == new_pattern(module.pattern, i, xm_pat_header.number_of_rows, module.channels))
     {
       strcat(error,"load_xm: unable to load module.\n");
       return -1;
     }
//     printf("rows: %d\n",module.pattern[i].rows); fflush(stdout);
//     getch();

     for (b=0;b<module.pattern[i].rows;b++)
      for (a=0;a<module.channels;a++)
      {
        paik = (5 * b * module.channels) + 5 + a * 5;

        module.pattern[i].data[paik]   = _nothing;
        module.pattern[i].data[paik+1] = _nothing;
        module.pattern[i].data[paik+2] = 0;
        module.pattern[i].data[paik+3] = 0;
        module.pattern[i].data[paik+4] = 0;

        /* now we are at the actual pattern data */
        fread(&b1,1,1,f);
        if ((b1&0x80)==0) // if the MSBit is not set, a full note is present
        {
          if (b1 == 97) b1 = _keyoff + 1;
          module.pattern[i].data[paik+1]=b1 - 1; //note

          fread(&b2,1,1,f);
          module.pattern[i].data[paik+0]=b2 - 1; //inst
          if ((b1 != (_keyoff + 1)) && (b2)) instrument_used[b2 - 1] = 1;

          fread(&b2,1,1,f);
          module.pattern[i].data[paik+4]=b2; //volume

          fread(&b2,1,1,f);
          module.pattern[i].data[paik+2]=b2; //effect

          fread(&b2,1,1,f);
          module.pattern[i].data[paik+3]=b2; //effect parameter
        }
         else // MSBit is set so packing is used.
        {
          if (b1&1) // bit 0 set: Note follows
          {
            fread(&b2,1,1,f);
            if (b2 == 97) b2 = _keyoff + 1;
            module.pattern[i].data[paik+1]=b2 - 1; //note
          }

          if (b1&2) // bit 1 set: Instrument follows
          {
            fread(&b2,1,1,f);
            module.pattern[i].data[paik+0]=b2 - 1; //inst
            if ((module.pattern[i].data[paik+1]<_keyoff)&&(b2)) instrument_used[b2 - 1] = 1;
          }

          if (b1&4) // bit 2 set: Volume column byte follows
          {
            fread(&b2,1,1,f);
            module.pattern[i].data[paik+4]=b2; //volume
          }

          if (b1&8) // bit 3 set: Effect follows
          {
            fread(&b2,1,1,f);
            module.pattern[i].data[paik+2]=b2; //effect
          }

          if (b1&16) // bit 4 set: Guess what!
          {
            fread(&b2,1,1,f);
            module.pattern[i].data[paik+3]=b2; //effect parameter
          }
        }

        // convert xm effects :
        efu   = module.pattern[i].data[paik + 2];
        efpar = module.pattern[i].data[paik + 3];

        switch (efu)
        {
          case 0x00: // appregio
          case 0x01: // porta up
          case 0x02: // porta down
          case 0x03: // tone porta
          case 0x04: // vibrato
          case 0x05: // tone porta + vslide
          case 0x06: // vibrato + vslide
          case 0x07: // tremolo
          case 0x08: // set pan
          case 0x09: // sample offset
          case 0x0B: // position jump
          case 0x0C: // set volume
          case 0x0D: // pattern break
            break;

          case 0x0A: // volume slide
            efu = 0x06;
            break;

          case 0x0E: // Extended commands
            switch (efpar >> 4)
            {
              case 0x09: // retrig note
                efu   = 0x15; // retrig note, vslide 0
                efpar = (efpar >> 4) & 0x0F;
                break;

              case 0x01: // fine porta up
                efu   = 0x13;
                efpar = 0xF0 + (efpar & 0x0F);
                break;

              case 0x02: // fine porta down
                efu   = 0x12;
                efpar = 0xF0 + (efpar & 0x0F);
                break;

              case 0x04: // vibrato control
              case 0x06: // pattern loop
              case 0x07: // tremolo control
              case 0x0A: // fine volume slide up
              case 0x0B: // fine volume slide down
              case 0x0C: // note cut
              case 0x0E: // pattern delay
                break;

              case 0x0D: // note delay
                efu    = 0x18;
                efpar &= 0x0F;
                break;

              case 0x03: // glissando, not supported
              case 0x05: // set finetune, not supported
              default:
                efu   = 0;
                efpar = 0;
                break;
            }
            break;

          case 0x0F: // set tempo/BPM
            if (efpar > 0x1F) efu = 0x10; // set bpm
            break;

          case ('G' - 55): // set global volume
            efu    = 0x17;
            break;

          case ('K' - 55): // key off
            module.pattern[i].data[paik+1] = _keyoff;
            efu   = 0;
            efpar = 0;
            break;

          case ('R' - 55): // multri retrig note
            efu = 0x15;
            break;

          case ('T' - 55): // tremor
            efu = 0x14;
            break;

          case ('X' - 55): // eXtended commands
            switch (efpar >> 4)
            {
              case 1: // extra fine porta up
                efu   = 0x13;
                efpar = 0xE0 + (efpar & 0x0F);
                break;

              case 2: // extra fine porta down
                efu   = 0x12;
                efpar = 0xE0 + (efpar & 0x0F);
                break;

              default:
                efu   = 0;
                efpar = 0;
                break;
            }
            break;

          case ('H' - 55): // global volume slide
            efu = 0x19;
            break;

          case ('P' - 55): // panning slide
            efu = 0x20;
            break;

          case ('L' - 55): // set envelope position
          default:
            efu   = 0; // 0,0 equals
            efpar = 0; // no effect
            break;
        }
        module.pattern[i].data[paik+2] = efu;
        module.pattern[i].data[paik+3] = efpar;

      } // end of for
   }
   else // end of if packed_size != 0
     new_pattern(module.pattern, i, 64, module.channels);

   fseek(f,where_to_seek,SEEK_SET); // seek to the next pattern.
 } // end of for
// printf("patterns read!\n");

 // now we are at the position where the instruments begin. so
 // read them :
// printf("reading instruments.."); fflush(stdout);
 xms_samples = 0; // xm's samples
 for (i = 0; i < xm_header.number_of_instruments; i++)
 {
//   printf("reading instrument #%u..",i);
   where_to_seek = ftell(f);
   fread(&xm_inst_header,1,sizeof(xm_inst_header),f);

   where_to_seek += xm_inst_header.instrument_header_size;

//   printf("%s\n",xm_inst_header.instrument_name); fflush(stdout);
//   getch();

   instruments[i].basesample = xms_samples;

   if ( (instrument_used[i]) && (xm_inst_header.number_of_samples_in_instrument == 0))
     xm_inst_header.number_of_samples_in_instrument = 1;

   if (xm_inst_header.number_of_samples_in_instrument > 0)
   {
     fread(&xm_extended_inst_header,1,sizeof(xm_extended_inst_header),f);
     fseek(f, where_to_seek, SEEK_SET);

     where_to_seek = ftell(f);
     where_to_seek += xm_extended_inst_header.sample_header_size *
                        xm_inst_header.number_of_samples_in_instrument;

     for (b = 0; b < 96; b++) instruments[i].samplenro[b] =
       xm_extended_inst_header.sample_number_for_all_notes[b];

     for (b = 0; b < 24; b++)
     {
       instruments[i].vol_env[b] =
         xm_extended_inst_header.points_for_volume_envelope[b];
       instruments[i].pan_env[b] =
         xm_extended_inst_header.points_for_panning_envelope[b];
     }

     instruments[i].fadeout =
       xm_extended_inst_header.volume_fadeout;
     instruments[i].vol_pts =
       xm_extended_inst_header.number_of_volume_points;
     instruments[i].pan_pts =
       xm_extended_inst_header.number_of_panning_points;
     instruments[i].vol_sustain =
       xm_extended_inst_header.volume_sustain_point;
     instruments[i].vol_loop_start =
       xm_extended_inst_header.volume_loop_start_point;
     instruments[i].vol_loop_end =
       xm_extended_inst_header.volume_loop_end_point;
     instruments[i].pan_sustain =
       xm_extended_inst_header.panning_sustain_point;
     instruments[i].pan_loop_start =
       xm_extended_inst_header.panning_loop_start_point;
     instruments[i].pan_loop_end =
       xm_extended_inst_header.panning_loop_end_point;
     instruments[i].vol_type =
       xm_extended_inst_header.volume_type;
     instruments[i].pan_type =
       xm_extended_inst_header.panning_type;

//     for (b = 0; b < 96; b++)
//       printf("%u, ",instruments[i].samplenro[b]);
//     printf("\n");
//     fflush(stdout);
//     getch();

//     printf("nro of smps in instr: %d\n",xm_inst_header.number_of_samples_in_instrument);
//     fflush(stdout); //getch();

     for (a = 0; a < xm_inst_header.number_of_samples_in_instrument; a++)
     {
      // lue xm_sample_header[a]
      fread(&xm_sample_header[a],1,sizeof(xm_sample_header_type),f);
      where_to_seek += xm_sample_header[a].sample_length;

      // get sample's name
      strncpy(samples[xms_samples + a].name, xm_sample_header[a].sample_name,22);
      samples[xms_samples + a].name[23] = 0;

//      printf("%s\n",samples[xms_samples + a].name); fflush(stdout);
//      getch();

      samples[xms_samples + a].length = xm_sample_header[a].sample_length;
      if ((xm_sample_header[a].type & 16) == 16) // 16 bit sample
        totalsamples += (samples[xms_samples + a].length / 2);
      else
        totalsamples += samples[xms_samples + a].length;

      if ((xm_sample_header[a].type & 3) == 2)
        samples[xms_samples + a].loop_type = 16;
      else
        samples[xms_samples + a].loop_type = 0;

      samples[xms_samples + a].c2spd    = 8363;
      samples[xms_samples + a].finetune = xm_sample_header[a].finetune;

      samples[xms_samples + a].relativenote = xm_sample_header[a].relative_note_number;

      samples[xms_samples + a].volume = xm_sample_header[a].volume;
      samples[xms_samples + a].pan = xm_sample_header[a].panning;

      samples[xms_samples + a].loop_start = xm_sample_header[a].sample_loop_start;
      samples[xms_samples + a].loop_length = xm_sample_header[a].sample_loop_length;

      if ( (samples[xms_samples + a].loop_length == 0) ||
           ((xm_sample_header[a].type & 3)  == 0) // loop type == none
         )
     {
       samples[xms_samples + a].loop_start  = 0;
       samples[xms_samples + a].loop_length = 0;
     }

      samples[xms_samples + a].loop_endi = samples[xms_samples + a].loop_start + samples[xms_samples + a].loop_length;
      samples[xms_samples + a].used = 1;
     } // end of for a=..

     for (a = 0; a < xm_inst_header.number_of_samples_in_instrument; a++)
     {
       loadlist_offset[sample_count] = ftell(f);
       loadlist_flags[sample_count]  = xm_sample_header[a].type;
       loadlist_index[sample_count]  = xms_samples + a;
       sample_count++;

       fseek(f, samples[xms_samples + a].length, SEEK_CUR);
     }

   }
   fseek(f,where_to_seek,SEEK_SET); // seek to the next instrument
   xms_samples += xm_inst_header.number_of_samples_in_instrument;
 }
// printf("instruments read!\n");

 gpoke.total = totalsamples + (sample_count * 99) + module.sample_space + 256;
  // leave "some" extra space, it is REQUIRED

// printf("reading samples.."); fflush(stdout);
 for (a = 0; a < sample_count; a++)
 {
   i = samples[loadlist_index[a]].length;

   // allocate a tmp buffer :
   smpbuf8 = (char *)smpbuf16 = (char *)malloc(i+4);

   // seek to the position where the sample data is :
   fseek(f, loadlist_offset[a], SEEK_SET);

   // read the sample data :
   fread(smpbuf8, 1, i, f);

   // convert samples to 8 bit non-delta :
   old = 0;
   if (loadlist_flags[a] & 16)
   { // we have a 16 bit sample :
     for (b = 0; b < (i / 2); b++)
     {
       uusi = smpbuf16[b] + old;
       smpbuf8[b] = (uusi / 256);
       old = uusi;
     }
     samples[loadlist_index[a]].length /= 2;
     samples[loadlist_index[a]].loop_start /= 2;
     samples[loadlist_index[a]].loop_length /= 2;
     samples[loadlist_index[a]].loop_endi /= 2;
   }
   else // the sample is 8 bit
   for (b = 0; b < i; b++)
   {
     uusi = smpbuf8[b] + old;
     smpbuf8[b] = uusi;
     old = uusi;
   }

   // upload to the sound device :
   if (_output.loadsample_8_bits_raw_from_memory(smpbuf8,
                 loadlist_index[a],
                 8363,
                 samples[loadlist_index[a]].pan,
                 samples[loadlist_index[a]].loop_start,
                 samples[loadlist_index[a]].loop_endi,
                 samples[loadlist_index[a]].length, 0x80) != 0)
   {
     strcat(error, "xm_load: unable to load samples.\n");
     return -1;
   }

   // dispose the tmp buffer
   free(smpbuf8);
   smpbuf8  = NULL;
   smpbuf16 = NULL;
 } // end of for a=..

 if (_output.device == GUS)
   module.basefreq = ((uhuge)8363L * (uhuge)_output.memory()) / gpoke.total;
 else
   module.basefreq = 8363L;

// printf("%d samples read!\n", sample_count);
 printf("ok!\n");
 fflush(stdout);

 // we're loaded now :D
 fclose(f);
 return 0;
}

// end of file
