/************************************************************************/
/* mod.c, .mod loader code.                                             */
/************************************************************************/
#include "mod.h"
#include "structs.h"
#include "ialot.h"

extern unsigned char error[]; // error string
extern samrec samples[];
extern gpoke_type gpoke;
extern module_type module;
extern output_type _output;
extern unsigned int finetunes[];
extern unsigned int periods[];
extern instrument_type instruments[];

int check_mk(FILE *f, char output) // 0 ok, -1 failed
{
  char sig[5];

  fseek(f, 1080 + module.file_offset, SEEK_SET);
  fread(sig, 1, 4, f);
  sig[4] = 0;

  module.channels = 0;

  if ( (strcmp(sig, "M.K.") == 0) || (strcmp(sig, "M!K!") == 0) )
    module.channels =4 ;

  else
  if (strcmp(sig, "OCTA") == 0) module.channels = 8;

  else
  if ((unsigned int)strstr(sig, "CHN") == 1 )
    module.channels = atoi(sig);

  else
  if ((unsigned int)strstr(sig, "CH") == 2) module.channels = atoi(sig);

  else
  if ((unsigned int)strstr(sig, "FLT") == 0) module.channels = atoi(sig);

  if ((module.channels > 32) || (module.channels < 1))
   {
    if (output == 1) strcat(error, "check_mk: not a valid MOD module.\n");
    return -1;
   }
  module.instruments = 31;
  return 0;
}


/************************************************************************/
/* int load_mod(char *name)                                             */
/* IN:                                                                  */
/*  name=filename                                                       */
/* OUT:                                                                 */
/*   0 successful                                                       */
/*  -1 failed                                                           */
/* DESCRIPTION:                                                         */
/*  Loads 31 instrument 1-32 channel protracker/fast tracker 1          */
/*  compatible modules.                                                 */
/************************************************************************/
int load_mod(char *name)
{
 FILE *f;
 char sig[5];
 int ii;
 unsigned int totalsamples;

 void getname()
 {
  char str[20];
  fseek(f, 0 + module.file_offset, SEEK_SET);
  fread(str, 1, 20, f);
  str[20] = 0;
  strcpy(module.title, str);
 }

 unsigned short amigaword(unsigned short w)
 { // "xchg lo.byte,hi.byte"
  return ( ((w & 0xFF) << 8) + ((w >> 8) & 0xFF) );
 }

 int getsampleinfo() /* 0 successful */
 {
  int i;
  unsigned short w;
  unsigned char b;

  fseek(f, 20 + module.file_offset, SEEK_SET);
  totalsamples = 0;
  for (i = 1; i <= module.instruments; i++)
  {
   samples[i].pan = 128;
   samples[i].loop_type = 0;

   fread(samples[i].name, 1, 22, f); // get sample's name
   samples[i].name[23] = 0;

   fread(&w, 2, 1, f);               // get sample's length
   samples[i].length = 2 * ((int)amigaword(w));
   totalsamples += samples[i].length;

   fread(&b, 1, 1, f);               // get sample's c2spd
   if (b<16) samples[i].c2spd = finetunes[b]; else samples[i].c2spd = 8363;

   fread(&b, 1, 1, f);               // get sample's volume
   samples[i].volume = ((int)b);

   fread(&w, 2, 1, f);               // get sample's loop start
   samples[i].loop_start=2*((int)amigaword(w));

   fread(&w, 2, 1, f);               // get sample's loop length
   samples[i].loop_length = 2 * ((int)amigaword(w));
   if (samples[i].loop_length < 3)
   {
     samples[i].loop_length = 0;
     samples[i].loop_start = 0;
   }
   // some modules have loops with length 1 or 2 yet meaning no loop at all

   samples[i].loop_endi = samples[i].loop_start + samples[i].loop_length;
   samples[i].used = (samples[i].length != 0);
  }

  gpoke.total = totalsamples + (module.instruments * 99) +
                module.sample_space + 256;
  // leave "some" extra space, it is REQUIRED

  return 0;
 }

 int loadpatterns() /* 0 successful */
 {
  unsigned int i, a;
  unsigned char b0, b1, b2, b3, ef, efpar;
  unsigned char *p;
  unsigned int offs;
  unsigned int periodfreq;

  unsigned char getnote(unsigned int __amigaval)
  { // seek through the period table and return the correct index
   unsigned char c2;
   for (c2 = 0; c2 < 108; c2++)
    if (__amigaval >= periods[(c2 + 24)]) return c2;
   return _nothing;
  }

//  printf("reading patterns..");
//  fflush(stdout);

  module.pattern =
    (pattern_type*)malloc( (module.patterns + 1) * sizeof(pattern_type));

  p = (char *)malloc(64 * module.channels * 4);
  for (i = 0; i<= module.patterns; i++)
   {
    module.pattern[i].rows = 64;
    module.pattern[i].data = (char *)malloc(5 * 64 * module.channels + 10);
    fread(p, 1, 64 * (unsigned int)module.channels * 4, f);
    offs = 0;
    for (a = 1; a <= (64 * (unsigned int)module.channels); a++)
     {
      b0 = p[offs];   // get
      b1 = p[offs+1]; // the
      b2 = p[offs+2]; // magical
      b3 = p[offs+3]; // 4 bytes
      offs+=4;

      module.pattern[i].data[a * 5] = (b0 & 0xF0) + (b2 >> 4);
      if ((module.pattern[i].data[a * 5] == 0) ||
          (module.pattern[i].data[a * 5] > 31))
        module.pattern[i].data[a * 5] = _nothing;

      periodfreq = (((unsigned int)(b0 & 0x0F)) << 8) + (unsigned int)b1;
      module.pattern[i].data[a * 5 + 1] = getnote(periodfreq);

      ef = (b2 & 0x0F);
      efpar = b3;
      switch (ef) // convert .mod-commands to the internal format
      {
       case 0x0F:
        if (efpar > 0x1F) ef=0x10; // set bpm
        break;

       case 0x08:
        if (efpar < 0x80) efpar *= 2; // set pan
        else if (efpar == 0xA4) efpar = 0x80; // surround my arse
        else efpar = 0xFF;
        break;

       case 0x0A:ef=0x06; break; // combined vslide
       case 0x0E: // extended commands
         switch (efpar & 0xF0)
         {
           case 0x90: // retrig note
             ef    = 0x15;
             efpar = (efpar >> 4) & 0x0F; // retrig note, vslide 0
             break;
           case 0x0D: // note delay
             ef     = 0x18;
             efpar &= 0x0F;
             break;
           default:
             break;
         }
         break;
       default: break;
      }
      module.pattern[i].data[a * 5 + 2] = ef;
      module.pattern[i].data[a * 5 + 3] = efpar;
      module.pattern[i].data[a * 5 + 4] = _nothing; // volume is always undefined
/*
      if ( (i==10) || (i==9) ) {
       printf("samp: %d, note: %d, effe: %d, epar: %d \n",
        module.pattern[i][a*5],module.pattern[i][a*5+1],module.pattern[i][a*5+2],
        module.pattern[i][a*5+3]);
       getch();
      }
*/
     }
   }
  free(p); // free the temp pattern buffer
//  printf("patterns read!\n");
  return 0;
 } // end of loadpatterns

 int readsamples() // 0 successful
 {
  int a;
  int i, ok = 0;
/*  printf("sampleja yhteens %d tavua.\n",totalsamples);
  printf("filess sampleja  %ld tavua.\n",filelength(fileno(f))-(1084+((int)module.channels)*4*64*((int)module.patterns+1))); */
//  printf("reading samples..");
//  fflush(stdout);

  // seek to the beginning of the sampledata :
  fseek(f, 1084 + module.file_offset +
           ((int)module.channels) * 4 * 64 * ((int)module.patterns + 1),
           SEEK_SET);

  for (i = 1; i <= module.instruments; i++) if (samples[i].length > 0)
  {
   a = samples[i].length;
   ok += _output.loadsample_8_bits_raw_from_opened_file_curpos(f, i,
           samples[i].c2spd, samples[i].pan, samples[i].loop_start,
           samples[i].loop_endi, samples[i].length, 0x80);
   if (ok != 0)
    {
     strcat(error, "load_mod: unable to load samples.\n");
     return -1;
    }
  }
//  printf("samples read!\n");
  return ok;
 }

 int loadsong() // 0 succesful
 {
  unsigned char b;
  fseek(f,950 + module.file_offset, SEEK_SET);
  fread(&b, 1, 1, f); // get song length
  module.length=b;
//  printf("song length: %d\n",module.length);

  fread(&b,1,1,f); // get "restart position"

  // get orders :
  module.patterns = 0;
  for (b = 1;b <= 128; b++)
  {
   fread(&module.order[b], 1, 1, f);
   if ( (module.order[b] > module.patterns) && (b <= module.length) )
     module.patterns = module.order[b];
  }
//  printf("patterns: %d\n", module.patterns + 1);
  if (ftell(f) != (1080 + module.file_offset)) printf("..er..");
  fread(sig, 1, 4, f);
  sig[4] = 0;
/*  printf("module type: %s\n",sig); */
  if (loadpatterns() != 0)
  {
    strcat(error, "load_mod: unable to load patterns.\n");
    return -1;
  }
  if (readsamples() != 0)
  {
    strcat(error, "load_mod: unable to load samples.\n");
    return -1;
  }
  return 0;
 }

// memset(instruments, 0, sizeof(instrument_type) * 130);

 f = fopen(name, "rb");
 if (f == NULL)
  {
   strcat(name, ".MOD");
   f = fopen(name, "rb");
  }

 if (f == NULL)
  {
   strcat(error, "load_mod: file not found.\n");
   return -1;
  }

/* printf("loading module: %s\n",name); */
 if (check_mk(f, 1) != 0)
  {
   fclose(f);
   strcat(error, "load_mod: not a 31 instrument MOD module.\n");
   return -1;
  } // not a valid mod

 for (ii = 1; ii <= module.channels; ii++)
  switch ((ii - 1) & 3) // default pnnings
   {
    case 0:module.initial_pan[ii] = 0x39; break;
    case 1:module.initial_pan[ii] = 0xC7; break;
    case 2:module.initial_pan[ii] = 0xC7; break;
    case 3:module.initial_pan[ii] = 0x39; break;
   }
 module.max_volume   = 64;
 module.maxsamples   = 32;
 module.fast_vslides = 0;
 module.type         = MOD;
 module.speed        = 6;
 module.bpm          = 125;
 module.init_master  = 64;
 module.minporta     = 56;
 module.maxporta     = 27392;
 getname();
 printf("loading %d-channel MOD module called '%s' ..",
   module.channels, module.title);
 fflush(stdout);

 totalsamples = 0;
 if (getsampleinfo() != 0)
  {
   fclose(f);
   strcat(error, "load_mod: read error.\n");
   return -1;
  }
 if (loadsong() != 0)
  {
   fclose(f);
   strcat(error, "load_mod: unable to load module.\n");
   return -1;
  }
/* printf("%ld / %ld \n",ftell(f),filelength(fileno(f))); */
 printf("ok!\n");
 fclose(f);
/* getch(); */
 return 0;
}

// end of mod.c
