/************************************************************************/
/* devices.c, device interface code.                                    */
/************************************************************************/
#include "devices.h" // header
#include "sbdev.h"   // sound blaster device (header)
#include "nsdev.h"   // no sound device (header)
#include "usdev.h"   // ultrasound device (header)

extern unsigned char error[]; // error string

struct
{
 unsigned int device, base, irq, dma, dma16;
} best_setup;

void best_dev()
{
 if (gus_get_settings() == 0)
 {
   best_setup.device = GUS;
   best_setup.base   = gus_settings.base;
   best_setup.irq    = 0;
   best_setup.dma    = 0;
   best_setup.dma16  = 0;
 }
 else if (sb_get_settings() == 0)
 {
   best_setup.device = SB;
   best_setup.base   = sb_settings.base;
   best_setup.irq    = sb_settings.irq;
   best_setup.dma    = sb_settings.dma;
   best_setup.dma16  = sb_settings.hdma;
 }
 else
 {
   best_setup.device = NOSOUND;
   best_setup.base   = 0;
   best_setup.irq    = 0;
   best_setup.dma    = 0;
   best_setup.dma16  = 0;
 }
}

typedef struct
{
 char name[70];
} device_t;

device_t devices[3]=
{
 {"          No Sound           "},
 {"Sound Blaster(1/1.5/2/pro/16)"},
 {"      Gravis UltraSound      "}
};

int choose_device()
{
 vali_t ddevices[3];
 int i;

 for (i = 0; i < 3; i++)
 {
   strcpy(ddevices[i].menutext, devices[i].name);
   ddevices[i].selectable = 1;
 }
 return (valintabar(ddevices, 3, " Select ", 1) + 200);
}

void mastervolume(signed int vol) // 0-64
{
 if (vol > 64) vol = 64; else if (vol < 0) vol = 0;
 master = vol;
}

void deinit_device()
{
 switch (_output.device)
 {
  case SB:
    sb_deinit();
    break;

  case GUS:
    gus_deinit();
    break;

  default:
  case NOSOUND:
    ns_deinit();
    break;
 }
 memset(&_output, 0, sizeof(_output));
}

int init_device(int ask_user)
{
 int device, i;

 memset(&_output, 0, sizeof(_output));

 if (ask_user == 1)
 {
   device = choose_device();
   best_setup.base = 0xEEEE;
 }
 else
 {
   best_dev();
   device = best_setup.device;
 }

 _output.device = device;

 switch (_output.device)
 {
   case -1:
     strcat(error, "init_device: aborted by user.\n");
     return -1;
     break;

   case SB:
     _output.playsample   = sb_playsample;
     _output.freesample   = sb_freesample;
     _output.stopchannel  = sb_stopchannel;
     _output.set_volume   = sb_set_volume;
     _output.set_pan      = sb_set_pan;
     _output.set_freq     = sb_set_freq;
     _output.memory       = sb_memory;
     _output.set_channels = sb_set_channels;
     _output.get_channels = sb_get_channels;

     _output.loadsample_signed_8_bits_raw
                          = sb_loadsample_signed_8_bits_raw;
     _output.loadsample_8_bits_raw_from_opened_file_curpos
                          = sb_loadsample_8_bits_raw_from_opened_file_curpos;

     _output.loadsample_8_bits_raw_from_memory
                          = sb_loadsample_8_bits_raw_from_memory;

     if (atexit(deinit_device) != 0)
      strcat(error,"init_device: auto clean-up not inited.\n");

     return (sb_init(ask_user));
     break;

   case GUS:
     _output.playsample   = gus_playsample;
     _output.freesample   = _1_int_para_return_0;
     _output.stopchannel  = gus_stopchannel;
     _output.set_volume   = gus_set_volume;
     _output.set_pan      = gus_set_pan;
     _output.set_freq     = gus_set_freq;

     if (atexit(deinit_device) != 0)
      strcat(error,"init_device: auto clean-up not inited.\n");

     i = gus_init(best_setup.base);

     _output.memory       = gus_memory;

     _output.set_channels = gus_set_channels;
     _output.get_channels = gus_get_channels;

     _output.loadsample_signed_8_bits_raw
                          = gus_loadsample_signed_8_bits_raw;
     _output.loadsample_8_bits_raw_from_opened_file_curpos
                          = gus_loadsample_8_bits_raw_from_opened_file_curpos;

     _output.loadsample_8_bits_raw_from_memory
                          = gus_loadsample_8_bits_raw_from_memory;

     return i;
     break;

   default:
   case NOSOUND:
     _output.playsample   = _6_int_paras_return_0;
     _output.freesample   = _1_int_para_return_0;
     _output.stopchannel  = _1_int;
     _output.set_volume   = _2_int;
     _output.set_pan      = _2_int;
     _output.set_freq     = _2_int_u;
     _output.memory       = ns_memory;
     _output.set_channels = _1_int;
     _output.get_channels = _0_int_paras_return_0;
     _output.loadsample_signed_8_bits_raw
                          = ns_loadsample_signed_8_bits_raw;
     _output.loadsample_8_bits_raw_from_opened_file_curpos
                          = ns_loadsample_8_bits_raw_from_opened_file_curpos;
     _output.loadsample_8_bits_raw_from_memory
                          = ns_loadsample_8_bits_raw_from_memory;
     return (ns_init(0));
     break;
 }
 return -1;
}

void freeallsamples()
{
 int i;
 switch (_output.device)
  {
   case SB:
     for (i = 0; i < 130; i++) _output.freesample(i);
     break;

   case GUS:
     gus_freeallsamples();
     break;

   default:
   case NOSOUND:
     break;
  }
}

// sound effect -"support" :

struct
{
 int curpos, endpos, startpos, channels_res;
 int sam_count;
} s_fx;

/************************************************************************/
/* __get_sfx_chan() returns a channel number for a new sound effect     */
/************************************************************************/
int __get_sfx_chan()
{
 s_fx.startpos     = _output.get_channels() + 1 - s_fx.channels_res;
 s_fx.endpos       = _output.get_channels();

 s_fx.curpos++;
 if (s_fx.curpos > s_fx.endpos) s_fx.curpos = s_fx.startpos;
 return s_fx.curpos;
}

/************************************************************************/
/* __get_sfx_channels_res() returns the amount of channels reserver for */
/* sound effect output                                                  */
/************************************************************************/
int __get_sfx_channels_res()
{
 return s_fx.channels_res;
}

/************************************************************************/
/* __init_sfx_engine(int how_many_channels);                            */
/* initialize the sound effect "engine".                                */
/* IN: how many channels to reserve for sfx purposes.                   */
/************************************************************************/
void __init_sfx_engine(int how_many_channels)
{
 s_fx.channels_res = how_many_channels;
 how_many_channels--;
 s_fx.startpos     = _output.get_channels() - how_many_channels;
 s_fx.endpos       = _output.get_channels();
 s_fx.curpos       = s_fx.startpos;
}

/************************************************************************/
/* __get_smp_nro() returns a sample slot for a sfx sample.              */
/************************************************************************/
int __get_smp_nro()
{
 s_fx.sam_count++;
 return (130 - s_fx.sam_count);
}

/************************************************************************/
/* __init_sam_engine() initializes the sfx sample load-system.          */
/************************************************************************/
void __init_sam_engine()
{
 s_fx.sam_count = 0;
}

// end of file
