// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef STACK_H
#define STACK_H

#include "error.h"
#include "dynarray.h"

template <class T> class Stack
  {
  private:
  DynArray<T> array;
  public:
  Stack() { };
  ~Stack() { };
  void Pop();
  void Push(T Item);
  T Top();
  int IsEmpty() { return(array.Entries()==0); };
  };
template <class T> T Stack<T>::Top() 
  { 
  #ifdef DEBUG
  if (array.Entries()==0) ErrorHandler.Abort("Stack::Top()  empty.");
  #endif
  return(array[array.Entries()-1]); 
  };
template <class T> void Stack<T>::Pop() 
  {
  #ifdef DEBUG
  if (array.Entries()==0) ErrorHandler.Abort("Stack::Pop()  empty.");
  #endif
  array.Delete(array.Entries()-1);
  };
template <class T> void Stack<T>::Push(T Item) 
  {
  const int TopIndex=array.Entries();
  array.Insert(TopIndex);
  array[TopIndex]=Item;
  };

#endif
