// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// Heap checking memory allocation. (debugging help)
// works only with WATCOM C++.

#ifdef HEAPCHECK

#include <stdlib.h>
#include <malloc.h>
#include "misc/mem.h"
#include "misc/error.h"

static int HeapBlockExists(void *Ptr);

void *operator new(size_t size)
  {
  void *ptr=malloc(size);
  HeapCheck();
  if (size && ptr==0) ErrorHandler.Abort("new(): out of memory.");
  HeapCheck();
  return(ptr);
  };
void operator delete(void *ptr)
  {
  if (ptr)
    {
    HeapCheck();
    if (!HeapBlockExists(ptr)) ErrorHandler.Abort("delete():  can't free unknown entry.");
    free(ptr);
    HeapCheck();
    }
  }
int HeapBlockExists(void *Ptr)
  {
  struct _heapinfo Block;
  int Zustand;

  Block._pentry = NULL;
  Zustand=_heapwalk(&Block);
  while (Zustand==_HEAPOK)
    {
    if (Block._useflag==_USEDENTRY)
      if ((char*)Ptr==(char*)(Block._pentry)+4)
        return(1); // mem block found
    Zustand=_heapwalk(&Block);
    }
  return(0); // block is no ptr to allocated array
  }
// check all heap entries.
void HeapCheck()
  {
  if (_heapchk()!=_HEAPOK) ErrorHandler.Abort("_heapcheck  bad heap.");
  int LocalUsedHeapEntries=0;
  _heapinfo Block;
  Block._pentry = NULL;
  int State=_heapwalk(&Block);
  while (State==_HEAPOK)
    {
    if (Block._useflag==_USEDENTRY)
      LocalUsedHeapEntries++;
    if (!Block._size) ErrorHandler.Abort("HeapCheck  nil block.");
    State=_heapwalk(&Block);
    }
  if (State!=_HEAPEND) ErrorHandler.Abort("HeapCheck  bad heap end.");
  }

#endif
