// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef GFX_RECT_H
#define GFX_RECT_H

#include "gfx/rect.h"

class Rect
  {
  public:
  int Left,Top,Right,Bottom;
  Rect() { };
  Rect(int l,int t,int r,int b) : Left(l),Top(t),Right(r),Bottom(b) { };
  void Set(int l,int t,int r,int b) { Left=l;Top=t;Right=r;Bottom=b; };
  void Clip(Bitmap &Bitmap);         // adjust *this, so that it won't overlap the destination bitmap
  void Clip(Rect &Rect);             // adjust *this, so that it won't overlap the dest rect, when it is copied into the top left edge of it
  void ClipSize(Rect &Rect);         // adjust *this, so that it won't overlap the dest rect, when it is copied into the top left edge of it
void operator &=(Rect &Mask);
  int Width() const  { return(Right-Left+1); };
  int Height() const { return(Bottom-Top+1); };
  };
// Call before blitting the rect into the bitmap
inline void Rect::Clip(Bitmap &Bitmap)
  {
  #ifdef DEBUG
  if (!Bitmap.IsValid()) ErrorHandler.Abort("Rect::Clip  Invalid bitmap.");
  #endif
  if (Left<0) Left=0;
  if (Top<0) Top=0;
  const int MaxX=Bitmap.Width()-1,MaxY=Bitmap.Height()-1;
  if (Right>MaxX) Right=MaxX;
  if (Bottom>MaxY) Bottom=MaxY;
  };
// Call before blitting *this into the DstRect.
inline void Rect::Clip(Rect &DstRect)
  {
  if (Left<DstRect.Left) Left=DstRect.Left;
  if (Top<DstRect.Top) Top=DstRect.Top;
  if (Right>DstRect.Right) Right=DstRect.Right;
  if (Bottom>DstRect.Bottom) Bottom=DstRect.Bottom;
  };
inline void Rect::ClipSize(Rect &DstRect)
  {
  int MaxX=DstRect.Right-DstRect.Left;
  if (Right-Left>MaxX) Right=Left+MaxX;
  int MaxY=DstRect.Bottom-DstRect.Top;
  if (Bottom-Top>MaxY) Bottom=Top+MaxY;
  };
inline void Rect::operator &=(Rect &OtherRect)
  {
  if (Left<OtherRect.Left) Left=OtherRect.Left;
  if (Top<OtherRect.Top) Top=OtherRect.Top;
/*
  int MaxX=OtherRect.Right-OtherRect.Left;
  if (Right-Left>MaxX) Right=Left+MaxX;
  int MaxY=OtherRect.Bottom-OtherRect.Top;
  if (Bottom-Top>MaxY) Bottom=Top+MaxY;
*/
  };

#endif
