// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de
// Functions for merging two bitmaps together.

#ifndef GFX_MERGE_H
#define GFX_MERGE_H

#include "gfx/bitmap.h"
#include "gfx/rect.h"
#include "compiler/types.h"

// This struct keeps info for fast merging of two PackedPixel8 bitmaps
// into a that, all three must use the same palette.
class MergeTablePP8
  {
  private:
  Palette *palette;
  DWORD *palindex_to_rgb4_4_mul; // size=colors*18 (18 tables, already multiplied with 0 .. 16)
  UBYTE *grb4_to_palindex;       // size=1<<12=4096
  friend void MergeRect(Bitmap &Dst,int dxs,int dy,Bitmap &Src1,int x1s,int y1,Bitmap &Src2,const Rect &SrcRect2,int Gradient,MergeTablePP8 &PaletteInfo);
  public:
  MergeTable() { palette=0;palindex_to_rgb4_4_mul=0;grb4_to_palindex=0; }
  MergeTablePP8(Palette &Pal)  { palette=0;palindex_to_rgb4_4_mul=0;grb4_to_palindex=0;Construct(Pal); };
  ~MergeTablePP8() { delete palindex_to_rgb4_4_mul;delete grb4_to_palindex; };
  void Construct(Palette &Pal);
  };

void MergeRect(Bitmap &Dst,int dxs,int dy,Bitmap &Src1,int x1s,int y1,Bitmap &Src2,const Rect &SrcRect2);
void MergeRect(Bitmap &Dst,int dxs,int dy,Bitmap &Src1,int x1s,int y1,Bitmap &Src2,const Rect &SrcRect2,int Gradient,MergeTablePP8 &PaletteInfo);

#endif
