// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#include "compiler/types.h"
#include "misc/error.h"
#include "misc/template.h"
#include "gfx/bitmap.h"
#include "gfx/line.h"

void (*DrawLineFunc[Bitmap::Classes])(Bitmap& Dst,int x1,int y1,int x2,int y2,ColorRef Color);

void DrawLineInvalid(Bitmap& Dst,int x1,int y1,int x2,int y2,ColorRef Color);
void DrawLineGeneral(Bitmap& Dst,int x1,int y1,int x2,int y2,ColorRef Color);
void DrawLineDC565(Bitmap& Dst,int x1,int y1,int x2,int y2,ColorRef Color);
static class AutoInitDrawLineFunc
  {
  public:
  AutoInitDrawLineFunc()
    {
    for (int i=0;i<Bitmap::Classes;i++) DrawLineFunc[i]=DrawLineGeneral;
    DrawLineFunc[Bitmap::ClassInvalid]=DrawLineInvalid;
/* not yet implemented
    #if defined(ACCEL_Drawline_PP8) || defined(ACCEL_PP8)
    DrawLineFunc[Bitmap::ClassDC565]=DrawLinePP8;
    #endif
*/
    };
  } InitDrawLineFunc;





void DrawLineInvalid(Bitmap& Bitmap,int x1,int y1,int x2,int y2,ColorRef Color)
  {
  ErrorExit("DrawLineSolid  invalid bitmap.");
  }
void DrawLineGeneral(Bitmap& Bitmap,int x1,int y1,int x2,int y2,ColorRef Color)
  {
  if (ColorRefType(Color)==CRRGB8) Color=Bitmap.Palette().GetPaletteIndex(Color);
  #ifdef DEBUG
  if (x1<0 || x2<0 || y1<0 || y2<0
   || x1>Bitmap.Width() || x2>Bitmap.Width() || y1>Bitmap.Height() || y2>Bitmap.Height())
    ErrorExit("DrawLine()  Coordinates exceed bitmap size.");
  #endif
  int dx,dy;
  dx=x2-x1;
  dy=y2-y1;
  if (Abs(dy)>Abs(dx))
    {
    // Steep line: one pixel per hor. scanline.
    int y=y1; // TopY
    int x=x1;
    if (dy<0) { dy=-dy;dx=-dx;y=y2;x=x2; }
    x<<=WORDBITS;                  // fixed point (WORDBITSbit after the point)
    int Pixels=dy+1;
    long xAddPerLine=0;
    if (dx!=0)
      {
      if (dx>0) dx++; else dx--;
      xAddPerLine=(dx<<WORDBITS)/(dy+1);
      // Adjust AddPerLine.
      if (xAddPerLine>0)
        {
        x+=xAddPerLine;
        if (xAddPerLine>=1L<<WORDBITS) x-=1<<WORDBITS; // steep line adjustment
        }
      else
        x+=(1L<<WORDBITS)-1;    // prevent round down
      }
    // Calculate x-coords.
    while (Pixels--) { Bitmap.SetPixel(x>>WORDBITS,y++,Color);x+=xAddPerLine; }
    }
  else
    {
    // Flat line: one pixel per vertical. scanline.
    int y=y1; // LeftX
    int x=x1;
    if (dx<0) { dy=-dy;dx=-dx;y=y2;x=x2; }
    y<<=WORDBITS;                  // fixed point (WORDBITSbit after the point)
    int Pixels=dx+1;
    long yAddPerColumn=0;
    if (dy!=0)
      {
      if (dy>0) dy++; else dy--;
      yAddPerColumn=(dy<<WORDBITS)/(dx+1);
      // Adjust AddPerColumn.
      if (yAddPerColumn>0)
        {
        y+=yAddPerColumn;
        if (yAddPerColumn>=1L<<WORDBITS) y-=1<<WORDBITS; // steep line adjustment
        }
      else
        y+=(1L<<WORDBITS)-1;    // prevent round down
      while (Pixels--) { Bitmap.SetPixel(x++,y>>WORDBITS,Color);y+=yAddPerColumn; }
      }
    }
  return;
  }
