// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef FONT_H
#define FONT_H

#include <string.h>
#include "gfx/bitmap.h"
#include "compiler/types.h"
class Font
  {
  private:
  int charwidth,charheight;
  int codebytes;
  UBYTE *code;      // all 256 chars are run length encoded
  UBYTE **charcode; // ptrs to the beginning of the code for each char
  friend void TextOut(Bitmap &Dst,int dx, int dy,Font &Src,ColorRef Color,char *Text,int Chars);
  public:
  Font();
  ~Font();
  Font& operator =(const Font &Font);
  Font(const Font &Font) { *this=Font; };
  int Load(char *FileName);
  int CharWidth(char) const { return(charwidth); };
  int CharHeight(char) const { return(charheight); };
  int StringWidth(char *Text) const { return(charwidth*strlen(Text)); };
  int StringHeight(char *) const { return(charheight); };
  };

void TextOut(Bitmap &Dst,int dx,int dy,Font &Src,ColorRef Color,char *Text,int Width);

#endif

