// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#include "gfx/bitmap.h"
#include "gfx/blit.h"
#include "gfx/fastmem.h"
#include "misc/error.h"

void (*CopyRectConvertedFunc[Bitmap::Classes])(Bitmap& Dst,int DstX,int DstY,Bitmap& Src,const Rect &SrcRect);

void CopyRectConvertedInvalid(Bitmap& Dst,int dx0,int dy,Bitmap &Src,const Rect &SrcRect);
void CopyRectConvertedGeneral(Bitmap& Dst,int dx0,int dy,Bitmap &Src,const Rect &SrcRect);
void CopyRectConvertedPackedPixel8(Bitmap& Dst,int dx0,int dy,Bitmap& Src,const Rect &SrcRect);
static class AutoInitCopyRectConvertedFunc
  {
  public:
  AutoInitCopyRectConvertedFunc()
    {
    for (int i=0;i<Bitmap::Classes;i++) CopyRectConvertedFunc[i]=CopyRectConvertedGeneral;
    CopyRectConvertedFunc[Bitmap::ClassInvalid]=CopyRectConvertedInvalid;
    };
  } InitCopyRectConvertedFunc;

void CopyRectConvertedInvalid(Bitmap&,int,int,Bitmap &,const Rect &)
  {
  ErrorHandler.Abort("CopyRect  invalid bitmap.");
  }
void CopyRectConvertedGeneral(Bitmap& Dst,int dx0,int dy,Bitmap &Src,const Rect &SrcRect)
  {
  #ifdef DEBUG
  int RectWidth=SrcRect.Right-SrcRect.Left+1;
  int RectHeight=SrcRect.Bottom-SrcRect.Top+1;
  if (dx0<0          || dy<0          || dx0+RectWidth>Dst.Width() || dy+RectHeight>Dst.Height()
   || SrcRect.Left<0 || SrcRect.Top<0 || SrcRect.Right>=Src.Width() || SrcRect.Bottom>=Src.Height()) ErrorHandler.Abort("CopyRect  rect exceeds bitmap.");
  #endif
  int sy=SrcRect.Top;
  while (sy<=SrcRect.Bottom)
    {
    int sx=SrcRect.Left;
    int dx=dx0;
    while (sx<=SrcRect.Right)
      {
      Dst.SetPixelRGB(dx,dy,Src.GetPixelRGB(sx,sy));
      dx++;
      sx++;
      }
    dy++;
    sy++;
    }
  }



void ConversionTablePP8PP8::Construct(Palette &Dst,Palette &Src)
  {
  #ifdef DEBUG
  if (Dst.Colors()!=256 || Dst.ClassID()!=Palette::ClassColorArray || Src.Colors()!=256 || Src.ClassID()!=Palette::ClassColorArray) ErrorHandler.Abort("ConversionTablePP8PP8::Construct()  need 256 color palettes.");
  #endif
  dst=&Dst;
  src=&Src;
  const int Colors=Dst.Colors();
  for (int PalIndex=0;PalIndex<Colors;PalIndex++)
    palindex[PalIndex]=(UBYTE)Dst.GetPaletteIndex(Src.GetColor(PalIndex));
  }
void CopyRectConverted(Bitmap& Dst,int dx0,int dy,Bitmap& Src,const Rect &SrcRect,const ConversionTablePP8PP8 &Tab)
  {
  #ifdef DEBUG
  if (Dst.Class()!=Src.Class() || (Dst.Palette.Class()==Palette::ClassColorArray && (ClassDst.Palette()!=Src.Palette())) ErrorHandler.Abort("CopyRect()  Incompatible bitmaps.");
  if (dx0<0          || dy<0          || dx0+RectWidth>Dst.Width() || dy+RectHeight>Dst.Height()
   || SrcRect.Left<0 || SrcRect.Top<0 || SrcRect.Right>=Src.Width() || SrcRect.Bottom>=Src.Height()) ErrorHandler.Abort("CopyRect  rect exceeds bitmap.");
  #endif
  int RectWidth=SrcRect.Right-SrcRect.Left+1;
  int RectHeight=SrcRect.Bottom-SrcRect.Top+1;
  int SrcDiff,DstDiff;
  SrcDiff=Src.WidthBytes()-RectWidth;
  DstDiff=Dst.WidthBytes()-RectWidth;
  UBYTE *SrcPtr,*DstPtr;
  SrcPtr=Src.Bits()+SrcRect.Top*Src.WidthBytes()+SrcRect.Left;
  DstPtr=Dst.Bits()+dy*Dst.WidthBytes()+dx0;
  while (RectHeight--)
    {
    int Width=RectWidth;
    while (Width--)
      {
      *DstPtr=Tab.ConvertPaletteIndex(*SrcPtr);
      DstPtr++;
      SrcPtr++;
      }
    DstPtr+=DstDiff;
    SrcPtr+=SrcDiff;
    }
  }
