// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// Prototypes of functions that manipulate a rectangular area in a
// bitmap: rect filling,copying,stretching,masking,conversion.


#ifndef BLIT_H
#define BLIT_H

#include "gfx/bitmap.h"
#include "gfx/rect.h"
#include "compiler/types.h"

extern void (*FillRectFunc[])(Bitmap& Dst,const Rect &SrcRect,ColorRef Filler);
extern void (*CopyRectFunc[])(Bitmap& Dst,int DstX,int DstY,Bitmap& Src,const Rect &SrcRect);
extern void (*CopyRectMaskedFunc[])(Bitmap& Dst,int DstX,int DstY,Bitmap& Src,const Rect &SrcRect);
extern void (*CopyRectStretchedFunc[])(Bitmap& Dst,const Rect &DstRect,Bitmap& Src,const Rect &SrcRect);
extern void (*CopyRectConvertedFunc[])(Bitmap& Dst,int dx,int dy,Bitmap& Src,const Rect &SrcRect);
inline void CopyRect(Bitmap& Dst,int DstX,int DstY,Bitmap& Src,const Rect &SrcRect)       { (CopyRectFunc[Dst.ClassID()])(Dst,DstX,DstY,Src,SrcRect); };
inline void FillRect(Bitmap& Dst,const Rect &SrcRect,ColorRef Filler)                     { (FillRectFunc[Dst.ClassID()])(Dst,SrcRect,Filler); };
inline void CopyRectMasked(Bitmap& Dst,int DstX,int DstY,Bitmap& Src,const Rect &SrcRect) { (CopyRectMaskedFunc[Dst.ClassID()])(Dst,DstX,DstY,Src,SrcRect); };
inline void CopyRectStretched(Bitmap& Dst,const Rect &DstRect,Bitmap& Src,const Rect &SrcRect) { (CopyRectStretchedFunc[Dst.ClassID()])(Dst,DstRect,Src,SrcRect); };
inline void CopyRectConverted(Bitmap& Dst,int DstX,int DstY,Bitmap& Src,const Rect &SrcRect) { (CopyRectConvertedFunc[Dst.ClassID()])(Dst,DstX,DstY,Src,SrcRect); };

// This table is needed for faster color conversion when calling 
// CopyRectConverted between different PackedPixel8 bitmaps.
class ConversionTablePP8PP8
  {
  private:
  Palette *dst,*src;
  UBYTE palindex[256];
  public:
  ConversionTablePP8PP8() : dst(0),src(0) { };
  ConversionTablePP8PP8(Palette &Dst,Palette &Src) { Construct(Dst,Src); };
  void Construct(Palette &Dst,Palette &Src);
  UBYTE ConvertPaletteIndex(UBYTE SrcPalIndex) const;
  };
inline UBYTE ConversionTablePP8PP8::ConvertPaletteIndex(UBYTE SrcPalIndex) const
  { 
  #ifdef DEBUG
  if (dst==0) ErrorHandler.Abort("ConversionTable::Convert()  table not initialized.");
  #endif
  return(palindex[SrcPalIndex]); 
  };
void CopyRectConverted(Bitmap& Dst,int DstX,int DstY,Bitmap& Src,const Rect &SrcRect,const ConversionTablePP8PP8 &Table);

#endif
