// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// Merging demo (timer controlled).

#include "iostream.h"
#include "device/vesadrv.h"
#include "device/keyboard.h"
#include "device/timer.h"
#include "gfx/bitmap.h"
#include "gfx/imageio.h"
#include "gfx/blit.h"
#include "gfx/merge.h"
#include "misc/template.h"

const int MergeTime=500; // spend 500 milliseconds merging

main()
  {
  // print start msg.
  {cout << "Pressing <space> will merge the two pictures, <Escape> quits.\nPress a key to start.";
  const int StartTime=SystemTimer.Time();
  while (SystemTimer.Time()-StartTime<6000 && !Keyboard.GetKey());} // wait 6 secs
  /////////////////// init section /////////////////
  if (Video.SetMode(VideoDriver::VGA320x200x256)!=0) ErrorHandler.Abort("main()  Can't set VGA mode 13h.");
  // load two images
  Bitmap Image1,Image2Orig;
  if (LoadPCX(Image1,"apple.pcx")!=0) ErrorHandler.Abort("main()  Can't load picture apple.pcx.");
  if (LoadPCX(Image2Orig,"flower.pcx")!=0) ErrorHandler.Abort("main()  Can't load picture flower.pcx.");
  // Convert the second image so it uses the same palette as the first.
  // Use the accelerated image conversion algo, that why a table must
  // be precomputed.
  Bitmap Image2(320,200,Image1.ClassID());
  Image2.UsePalette(Image1.Palette());
  ConversionTablePP8PP8 ConversionTable(Image2.Palette(),Image2Orig.Palette());
  CopyRectConverted(Image2,0,0,Image2Orig,Rect(0,0,319,199),ConversionTable);
  // Original image is no longer needed.
  Image2Orig.Delete();
  // Create a third bitmap that shall contain the merging result.
  // This bitmap will be directly copied onto the screen.
  // Let the screen use the same palette as the two images.
  Bitmap HiddenScreen(320,200,Video.ClassID());
  HiddenScreen.UsePalette(Video.Palette());
  // Set video colors to the same colors as the images.
  Video.UsePalette(Image1.Palette());
  Rect FullRect(0,0,HiddenScreen.Width()-1,HiddenScreen.Height()-1);
  // Precompute merging info.
  MergeTablePP8 MergeInfo(Image1.Palette());
  
  ////////////////////// main loop ////////////////////
  Bitmap *Src1=&Image1,*Src2=&Image2;
  for(;;)
    {
    // Show the first image, wait for key stroke.
    Video.BlitToScreen(0,0,*Src1,FullRect);
    while (!Keyboard.GetKey());
    if (Keyboard.WasPressed(KeyboardDriver::Escape)) break;
    // Merge both images with different levels of intensity.
    const int StartTime=SystemTimer.Time();
    const int EndTime=StartTime+MergeTime;
    const Rect FullScreen(0,0,319,199);
    while (SystemTimer.Time()<EndTime)
      {
      int Gradient=(SystemTimer.Time()-StartTime)*256/MergeTime;
      if (Gradient>256) Gradient=256;
      MergeRect(HiddenScreen,0,0,*Src2,0,0,*Src1,FullScreen,Gradient,MergeInfo);
      Video.BlitToScreen(0,0,HiddenScreen,FullScreen);
      }
    Swap(Src1,Src2);
    }
  return 0;
  }

