
/*
   Demonstration of Subtotals,

   Short program to update average age for each family in familys.dbf
   The average age is a field in each record which will indicate how far
   away each family member is in age from the average age in that family

   Index expression in familys.ndx is : 
   
     UPPER(SURNAME)

   Thus all family members will be grouped together
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "database.hpp"

void main()
{
 char ws[128];                   // Workspace

 database db("familys","familys");              // Open database
 record rec(db);                                        // Current record
 record first(db);                                                              // Used to save position
 int fn=db.getfield("avgage")->getnumber();             // Field no. avgage field

 int sel=rec.select(FIRST);             // Select first record
 do
 {
  char surname[128];            // Holds current surname
  double avgage=0;                      // Holds average age
  first=rec;                            // Save position
  int ssel=sel;                 // save sel at current position
  int trec=0;                           // Total no. of records in patrol

  strcpy(surname,rec.getfield("surname"));          // Copy in patrol name

  while(!sel && !strcmp(surname,rec.getfield("surname"))) // Until new name
  {
   avgage+=atof(rec.getfield("age"))+atof(rec.getfield("agem"))/12;
   trec++;
   sel=rec.select(NEXT);                        // On to next record
  }
  avgage/=trec;

  while(!ssel && !strcmp(surname,first.getfield("surname")))  // Round again
  {
   double age;

   age=atof(first.getfield("age"))+atof(first.getfield("agem"))/12;
   first.setfield(fn,int(age-avgage));
   first.write();                       // Write the new record
   ssel=first.select(NEXT);
  }
  printf("\nAverage age of %s is %f",surname,avgage);
 }
 while(!sel);
}
