/*                     Calculator Addition Tutorial In C
										By : Desolation/VLA

		This is a small calculator program that will add numbers for you under
	a certain constraint (you can only add numbers that are from -99999 to
	99999).  There is a small menu setup that is also included.  As the
	tutorial continues, I will integrate more operations such as dividing,
	multiplying, to the power of, averaging, and so on.  This will also allow
	me to implement the menu further to show you how to incorporate one style
	for a menu system also.  Please, comment on Phantasm.  I will be more
	than happy to try and explain any part of the coding.
*/


#include <stdio.h>      // Include standard header file.

void main  (void);      // Function protyping to setup for the functions
void addit (void);      //  I will write later (not really necessary, but
								//  good programming practice).

void main (void)        // The actual main function.
{
	char selection;      // Setup variable 'selection' which is of type char.

/* A 'do while' loop is used to repeat the menu system after every function
	you do, such as adding, subtracting, etc. The exiting condition is
	explained lower in the while section. */

	do {                                  // Start the do loop.
		fflush(stdin);                     // flush keyboard buffer (don't worry about this yet).
		printf("1.  Add Numbers \n");      // Print first option of menu.
		printf("Q.  Quit Program \n");     // Print Termination option of menu.
		printf("Enter Menu Selection : "); // Print text for menu selection.
		selection = getchar();             // This grabs the char for the menu selection
													  //  which is '1' or 'q'.

/* A 'switch' command is used for case statements.  This allows you to
	constrain which selections the user can make, and tells the program which
	function to goto for each selection.  You put 'selection' inside the ()
	because that's the variable that will be changed by the user.  For example,
	if the user were to  choose '1' for Add Numbers, the case statement which
	corresponds to '1' tells it to goto the 'addit' function which is defined
	later on in the code.  Break exits out of the switch block after the addit
	function was completed.  If you didn't have this break statement, and the
	user chose '1' to add number, then it would call the addit function routine,
	do whatever the addit function said to do, come back to the switch statement
	block, then continue on to the next statement.  The break tells it to
	not contine on after the addit routine is called.  When the user inputs
	'q', it just breaks out of the switch block, and then contines on with
	the other commands after the switch statement (where it will say to
	exit). */

		switch(selection) {  // Begin switch statement.
			case '1' :        // If user put '1' then go to addit function.
				addit();       // Runs addit. () is used because no values get sent in.
				break;         // Break out of the switch block.
			case 'q' :        // If user inputs 'q' then simply break out.
				break;
		}                    // End switch block.

/* The 'while' is used for the looping structure.  When the switch block is
	finished, a value is stuck in it (either '1' or 'q' for this program).
	As long as selection is not equal to 'q', then keep DOing the code that's
	between the 'do' up above and the 'while' below. */

		} while (selection != 'q');

	printf("Calculator Program Terminated.\n");  // Print termination notice.
}                                               // End of the main program.

void addit (void)                               // Start of the addit function.
{
	int value1,value2,value3;                    // Setup 3 variables of type integer.

/* The PROMPTA is used as another looping structure.  This is called a
	'goto loop'.  If you notice the 'if' statement a few lines below, it
	puts a constraint or condition on the value the user enters in.  It has
	to be between 9999 and -9999 (I only did this to show how to use an
	'if' statement, no other reason).  What happens is that a number will
	be stored into value1, then the number in value1 is checked.  If it's
	greater than 9999 OR less then -9999 text comes up that says 'Value
	not Valid'.  Then the 'goto PROMPTA' statement goes back up to the place
	where 'PROMPTA:' (NOTICE a colon is used instead of a semi-colon!).
	is located and executes the code from that spot over again.  REMEMBER!
	C is case sensitive, 'PROMPTA' and 'prompta' are not the same.  It's good
	programming practice to use capitals for goto loop names because it's easy
	to keep track of. If value1 satisfies the conditions, then it goes on with
	the code. */

PROMPTA:
	printf("Enter In the 1st value  : ");  // Text to get 1st number.
	scanf("%d",&value1);                   // Grab that # and store it into value1.
	if (value1 > 9999 | value1 < -9999) {  // Checks value1.
		printf("Value not valid.\n");       // If value1 > 9999 OR value1 < -9999
		goto PROMPTA;                       //  then it goes up to PROMPTA and
	}                                      //  re-executes this part of code again.

PROMPTB:                                  // PROMPTB is done the same as PROMPTA.
	printf("Enter In the 2nd number : ");
	scanf("%d",&value2);
	if (value2 > 9999 | value2 < -9999) {
		printf("Value not valid.\n");
		goto PROMPTB;
	}

	value3 = value1+value2;       // Store into value3, the addition of value1
											//  and value2.

	printf("%d + %d = %d \n\n", value1,value2,value3); // Print value1, value2,
																		//  and the addition of
																		//  the 2 values.

}                                // End of Addit function



/* That sums it up for now.  If you have any questions of comments, leave
	them on Phantasm (206)232-5912 (in case you forgot the number) or mail
	me.  As soon as we get through this tutorial, the future progression will
	be to add more commands to the menu system to see how to handle multiple
	case statements, do the other numerical operators (subtraction, division,
	etc.), do relational operators (less than, greater than, etc.) and
	whatever else we can jam in here as time goes on and we all learn a
	little more.  Thanks for learning.

	VLA email : vlasite@carson.u.washington.edu

														Desolation/VLA
														decko@u.washington.edu
														Phantasm CoSysop
*/
