//       XXXXX  X      X   X    X    X   X    X    X   X
//       X      X      X   X   X X   X   X   X X   X   X
//       X      X       X X   X   X  X   X  X   X   X X
//       XXX    X        X    X   X  X   X  X   X    X
//       X      X        X    XXXXX  X X X  XXXXX    X
//       X      X        X    X   X  X X X  X   X    X
//       X      XXXXX    X    X   X   X X   X   X    X

//                    FLYAWAY - version 2.00
//          Written by: Gordon Dodrill - July 20, 1990
//          Copywrite 1989, 1990 - Coronado Enterprises

#include "stdio.h"
#include "conio.h"
#include "iostream.h"
#include "flyaway.h"
#include "location.hpp"
#include "items.hpp"
#include "message.h"
#include "schedule.hpp"
#include "clock.hpp"


word verb, noun;
clock time_of_day;
schedule flight_info;
location your_car;
location pass_drop_off;
location lobby;
location baggage_claim;
location dark_room;
location ticket_counter;
location tunnel;
location rest_room;
location snack_bar;
location security;
location waiting_area;
location gate1;
location gate2;
location gate3;
location gate4;
location plane1;
location plane2;
location plane3;
location plane4;
location *present_location = &your_car;
location *result;
items personal_items;      // The stuff I am carrying




main()
{
   initialize();
   cout << " Your best friend offered to drop you off at the airport\n"
           " so you can begin your dream vacation and you have just\n"
           " arrived at the passenger drop off area.  You have about\n"
           " 25 minutes to get to your plane, you haven't had any \n"
           " lunch, and you have a full bladder.  Be very careful, \n"
           " there is a lot of construction going on all around the \n"
           " airport.      Good luck!\n\n"
           " Type help if you want a few clues and a word list.\n\n";

   do {
      time_of_day.inc_and_print_time(); // This makes the user prompt
      get_command(verb, noun);          // Get user prompt
      perform_action(verb, noun);       // Try to perform the request
      flight_info.shuffle_flights();
      flight_info.shuffle_gates(present_location);
              // See if the flight has been found and all is in order
      flight_info.check_flight(present_location);
   } while (verb != quit);
}


void initialize(void)
{
   cout << "            Welcome to Flyaway, version 2.00\n\n";

   your_car.init(&pass_drop_off, // North from here
              NULL,              // East from here
              NULL,              // South from here
              NULL,              // West from here
              your_car_message,  // message when entering here
              y_c_look_message); // message for look command

   pass_drop_off.init(&lobby,
              NULL,
              NULL,    // You cannot go back to the car, it leaves
              NULL,
              pass_drop_off_message,
              p_d_o_look_message);

   lobby.init(&ticket_counter,
              NULL,
              &pass_drop_off,
              &baggage_claim,
              lobby_message,
              l_look_message);

   baggage_claim.init(NULL,
              &lobby,
              NULL,
              &dark_room, 
              baggage_claim_message,
              b_c_look_message);

   dark_room.init(NULL,
              NULL,
              NULL,
              NULL,
              dark_room_message,
              d_r_look_message);

   ticket_counter.init(&tunnel,
              NULL,
              &lobby,
              NULL, 
              ticket_counter_message,
              t_c_look_message);

   tunnel.init(&security,
              &snack_bar,
              &ticket_counter,
              &rest_room,
              tunnel_message,
              t_look_message);

   rest_room.init(NULL,
              &tunnel,
              NULL,
              NULL,
              rest_room_message,
              r_r_look_message);

   snack_bar.init(NULL,
              NULL,
              NULL,
              &tunnel,
              snack_bar_message,
              s_b_look_message);

   security.init(&waiting_area,
              NULL,
              &tunnel,
              NULL, 
              security_message,
              s_look_message);

   waiting_area.init(NULL,
              &gate3,
              &security,
              &gate2,
              waiting_area_message,
              w_a_look_message);

   gate1.init(&plane1,
              &gate2,
              NULL,
              NULL,
              gate1_message,
              g1_look_message);

   plane1.init(NULL,
              NULL,
              NULL,
              NULL,
              plane_message,
              plane_look_message);
 
   gate2.init(&plane2,
              &waiting_area,
              NULL,
              &gate1,
              gate2_message,
              g2_look_message);

   plane2.init(NULL,
              NULL,
              NULL,
              NULL,
              plane_message,
              plane_look_message);
 
   gate3.init(&plane3,
              &gate4,
              NULL,
              &waiting_area,
              gate3_message,
              g3_look_message);

   plane3.init(NULL,
              NULL,
              NULL,
              NULL,
              plane_message,
              plane_look_message);
 
   gate4.init(&plane4,
              NULL,
              NULL,
              &gate3,
              gate4_message,
              g4_look_message);

   plane4.init(NULL,
              NULL,
              NULL,
              NULL,
              plane_message,
              plane_look_message);
 
   personal_items.add_item(keys);     // Player gets keys
   personal_items.add_item(money);    // Player gets money

   your_car.add_item(ticket);         // Ticket is in car
   snack_bar.add_item(candy);         // Candy is in snack bar
}




       // A reference variable is used for the verb so we can get a 
       //  change back to main to end the game when the time comes.
void perform_action(word &verb, word noun)
{
   if (is_a_direction(verb)) {              // Move to a new location
      result = present_location->move(verb);
      if (result) {                  // If Non-NULL
         present_location = result;  // Valid move found
         present_location->display_message();
      }

                                 // Force end of game if in dark room
      if (present_location == &dark_room) {
         verb = quit;
         cout << "Hit any key to end the game.";
         int c = getch();
      }
   }

                                                         // Inventory
   else if (verb == inventory)
      personal_items.list_items();

                                                              // Look
   else if (verb == look)
      present_location->display_list_of_items();

                                                         // Drop item
   else if (verb == drop) {
      if (personal_items.item_here(noun)) {
         personal_items.drop_item(noun);
         present_location->add_item(noun);
         cout << " Dropped.\n";
      } else {
         cout << "You can't drop what you don't have.\n";
      }
   }

                                                          // Get item
   else if (verb == get) {
      if (present_location->item_here(noun)) {
         present_location->drop_item(noun);
         personal_items.add_item(noun);
         cout << " Picked up.\n";
      } else {
         cout << "It isn't here so you can't pick it up.\n";
      }
   }

                                                         // Buy candy
   else if ((verb == buy) && (noun == candy) && 
                           (present_location == &snack_bar)) {
      if ((personal_items.item_here(money)) &&
                           (present_location->item_here(candy))) {
         personal_items.drop_item(money);
         personal_items.add_item(candy);
         present_location->drop_item(candy);
         present_location->add_item(money);
         cout << " You now have candy.\n";
      } else 
         cout << "Surely you are not serious about that!\n";
   }

                                                       // Read ticket
   else if ((verb == read) && (noun == ticket)) 
      if (personal_items.item_here(ticket))
         flight_info.list_actual_destination();
      else
         cout << "You don't have a ticket to read.\n";

                                                      // Read monitor
   else if ((verb == read) && (noun == monitor) &&
            (present_location == &ticket_counter)) 
      flight_info.list_flights(present_location);

                                                      // Read monitor
   else if ((verb == read) && (noun == monitor) &&
            (present_location == &waiting_area)) 
      flight_info.list_flights(present_location);

                                                        // Read paper
   else if ((verb == read) && (noun == paper) && 
                                    (present_location == &lobby))
      cout <<
       "\n                C++ TUTORIAL RELEASED\n"
       "Coronado Enterprises has a full line of computer language\n"
       "programming tutorials available.  Write and ask for the\n"
       "latest information.\n"
       "   Coronado Enterprises\n"
       "   12501 Coronado Ave NE\n"
       "   Albuquerque, NM 87122\n\n"
       "There is another story about danger at the airport due to\n"
       "construction.  Be very careful!\n";

                                                              // Help
   else if (verb == help)
      cout << 
      "Each action requires a verb, or a verb and a noun, and only\n"
      "the first two words of the command are significant, any \n"
      "other words on a line are ignored.  The four directions can\n"
      "be abbreviated to the first letter to make it easier to get\n"
      "to your flight.  The entire vocabulary is given as;\n\n"
      "      ------- verbs -------          ---- nouns ----\n"
      "      north   drop   read            keys    money\n"
      "      east    get    buy             candy   monitor\n"
      "      south   look   help            ticket  paper\n"
      "      west    quit   inventory\n\n"
      "   look = give more information on current location\n"
      "   inventory = list items I am carrying\n\n"
      "You better hurry, you just wasted a minute reading this.\n\n";
                                                              // Quit
   else if (verb == quit) ;  // Ignore to prevent message

   else
      cout << "I don't understand what you want.\n";

}
