/* Fichier: dcodrle3.c
   Auteur: David Bourgin
   Date de creation: 1/2/94
   Date de derniere mise a jour: 22/5/94
   Dessein: Exemple de decodage RLE type 3 avec comme donnees a decompresser le contenu d'un fichier.
*/

#include <stdio.h>
/* Pour les routines printf,fgetc,fputc,fread */
#include <stdlib.h>
/* Pour la routine exit */

/* Codes d'erreur renvoyes a l'appelant */
#define NO_ERROR      0
#define BAD_FILE_NAME 1
#define BAD_ARGUMENT  2

/* Constantes pratiques */
#define FALSE 0
#define TRUE  1

/* Variables globales */
FILE *f_source,*f_dest;

                             /* Puisque fgetc=EOF uniquement apres un acces
                                alors statut_octet_stocke vaut TRUE si un octet a ete engrange par fgetc
                                ou FALSE s'il n'y aucun octet valide, deja lu et non traite dans val_octet_stocke */
int statut_octet_stocke=FALSE;
int val_octet_stocke;

/* Pseudo procedures */
#define fin_des_donnees() (statut_octet_stocke?FALSE:!(statut_octet_stocke=((val_octet_stocke=fgetc(f_source))!=EOF)))
#define lire_octet()  (statut_octet_stocke?statut_octet_stocke=FALSE,(unsigned char)val_octet_stocke:(unsigned char)fgetc(f_source))
#define lire_tableau(tableau,nb_a_lire)  ((void)fread((tableau),1,(nb_a_lire),f_source))
#define ecrire_octet(octet)  ((void)fputc((octet),f_dest))
#define ecrire_tableau(tableau,nb_octets_a_ecrire)  ((void)fwrite((tableau),1,(nb_octets_a_ecrire),f_dest))

void decodagerle3()
/* Parametres en sortie: Aucun
   Action: Decompresse suivant la methode RLE type 3 tous les octets lus par la fonction lire_octet
   Erreurs: Une erreur d'entree/sortie peut perturber le deroulement de l'algorithme
*/
{ unsigned char octet_repere,octet_lu,nb_repetitions,
                trame[256];
  register unsigned int longueur_trame,
                        i;

  if (!fin_des_donnees())
     { octet_repere=lire_octet();
       do {                  /* Puisqu'il y a l'octet repeere c'est qu'il y a des donnees a decompresser */
            octet_lu=lire_octet();
            if (octet_lu==octet_repere)
                             /* Codage d'une repetition ou de l'octet repere */
               { nb_repetitions=lire_octet();
                 longueur_trame=((unsigned int)lire_octet())+1;
                 if (!nb_repetitions)
                    for (i=1;i<=longueur_trame;i++)
                        ecrire_octet(octet_repere);
                 else { lire_tableau(trame,longueur_trame);
                        for (i=0;i<=nb_repetitions;i++)
                            ecrire_tableau(trame,longueur_trame);
                      }
               }
            else ecrire_octet(octet_lu);
          }
       while (!fin_des_donnees());
     }
}

void aide()
/* Parametres en sortie: Aucun
   Action: Affiche l'aide du programme et termine son execution
   Erreurs: Aucune
*/
{ printf("Cet utilitaire permet de decompresser un fichier par la methode RLE type 3\n");
  printf("telle qu'elle est exposee dans 'La Video et Les Imprimantes sur PC'\n");
  printf("\nUsage: dcodrle3 source destination\n");
  printf("source: Nom du fichier a decompresser\n");
  printf("destination: Nom du fichier decompresse\n");
}

int main(argc,argv)
/* Parametres en sortie: Renvoie un code d'erreur (0=Aucune)
   Action: Procedure principale
   Erreurs: Detectee, traitee et un code d'erreur est renvoye si necessaire
*/
int argc;
char *argv[];
{ if (argc!=3)
     { aide();
       exit(BAD_ARGUMENT);
     }
  else if ((f_source=fopen(argv[1],"rb"))==NULL)
          { aide();
            exit(BAD_FILE_NAME);
          }
       else if ((f_dest=fopen(argv[2],"wb"))==NULL)
               { aide();
                 exit(BAD_FILE_NAME);
               }
            else { decodagerle3();
                   fclose(f_source);
                   fclose(f_dest);
                 }
  printf("Execution de dcodrle3 achevee.\n");
  return (NO_ERROR);
}
