/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "bccgrx00.h"

void set_BGI_mode(int *graphdriver, int *graphmode)
{
  int rx = 0;
  int ry = 0;
  int rc = 0;

  switch (*graphdriver) {
    case VGA     : switch (*graphmode) {
		     case VGALO : rx = 640; ry = 200; rc = 16; break;
		     case VGAMED: rx = 640; ry = 350; rc = 16; break;
		     case VGAHI : rx = 640; ry = 480; rc = 16; break;
		   }
		   break;
    case IBM8514 : switch (*graphmode) {
		     case IBM8514LO: rx =  640; ry = 480; rc = 256; break;
		     case IBM8514HI: rx = 1024; ry = 768; rc = 256; break;
		   }
		   break;
    case HERCMONO: if (*graphmode == HERCMONOHI) {
		     rx = 720;
		     ry = ((__gr_ADAPTER == GR_HERC) ? 348 : 350);
		     rc = ((__gr_ADAPTER == GR_HERC) ?   2 :  16);
		   }
		   break;
    case CGA     :
    case MCGA    :
    case ATT400  : switch (*graphmode) {
		     case CGAC0 :
		     case CGAC1 :
		     case CGAC2 :
		     case CGAC3 : rx = 320; ry = 200;            break;
		     case CGAHI : /* == MCGAMED == ATT400MED */
				  rx = 640; ry = 200;            break;
		     case MCGAHI: /* == ATT400HI */
				  switch (*graphdriver) {
				    case MCGA  : rx = 640; ry = 480; break;
				    case ATT400: rx = 640; ry = 400; break;
				  }
				  break;
		   }
		   rc = 16;
		   break;
    case EGA64   : switch (*graphmode) {
		     case EGA64LO : rx = 640; ry = 200; rc = 16;     break;
		     case EGA64HI : rx = 640;
				    ry = 350;
				    rc = ((__gr_ADAPTER == GR_EGA) ? 4 : 16);
				    break;
		   }
		   break;
    case EGA     : switch (*graphmode) {
		     case EGALO : rx = 640; ry = 200; rc = 16;       break;
		     case EGAHI : rx = 640; ry = 350; rc = 16;       break;
		   }
		   break;
    case EGAMONO : if (*graphmode == EGAMONOHI) {
		     rx = 640; ry = 350; rc = 16;
		   }
		   break;
    case PC3270  : if (*graphmode == PC3270HI) {
		     rx = 720; ry = 350; rc = 16;
		   }
		   break;
    default      : ERR = grInvalidDriver;
		   return;
  }

  if (rx != 0) {
    __gr_BGI_w = rx;
    __gr_BGI_h = ry;
    __gr_BGI_c = rc;
    *graphdriver = NATIVE_GRX;
    *graphmode   = GRX_BGI_EMULATION;
  } else
    ERR = grInvalidMode;
}
