; ROT.ASM contains one function, _RotatePoints, that can be called from C.
; To do this, the C program must have some global variables
; these variables are defined as extrn here in the asm source.
; They are _bx, _by, _bz that should contain the coordinates of the object
; to be rotated. They are never changed instead the rotated coordinates
; are stored in _rx, _ry, _rz. _sx and _sy will contain the screen coordinates
; _addx, _addy, _addz are the distance the object will be moved in the x,y,z 
; direction. If they are 0 the object will appear at the center of the screen.
; ROT.ASM also contains two local routines that are called from _RotatePoints.        
        
        P386N                   ;allow 386 specific instructions (ie movsd)
        IDEAL
        MODEL small             ;data < 64k, program < 64k
        DATASEG
                
        EXTRN   _bx,_by,_bz,_rx,_ry,_rz,_sx,_sy ;extrn variables & arrays
        EXTRN   _addx, _addy, _addz             ;must be defined elsewhere (in c)

        sinax   dw      ?               ;the sin & cos variables are only
        sinay   dw      ?               ;used here, in the asm source
        sinaz   dw      ?
        cosax   dw      ?
        cosay   dw      ?
        cosaz   dw      ?

        HALFX   EQU      320/2          ;Constants
        HALFY   EQU      200/2
        
;This is the precalculated sin & cos table
;It's the sin & cos values of a 256 "degree" circle with each value
;multiplied by 2^14 (we use fixed point math with 14 bits shift).
;The cosine values are the same as (sinevalues + 90 degrees). 90 deg in
;a 360 deg circle is the same as 64 "deg" in a 256 "deg" circle. That means
;that after 64 values in sintab, the costab & sintab can share the same values
sintab  dw      0, 402, 804, 1205, 1606, 2006, 2404, 2801, 3196, 3590, 3981, 4370, 4756, 5139, 5520, 5897
        dw      6270, 6639, 7005, 7366, 7723, 8076, 8423, 8765, 9102, 9434, 9760, 10080, 10394, 10702, 11003, 11297
        dw      11585, 11866, 12140, 12406, 12665, 12916, 13160, 13395, 13623, 13842, 14053, 14256, 14449, 14635, 14811, 14978
        dw      15137, 15286, 15426, 15557, 15679, 15791, 15893, 15986, 16069, 16143, 16207, 16261, 16305, 16340, 16364, 16379
costab  dw      16384, 16379, 16364, 16340, 16305, 16261, 16207, 16143, 16069, 15986, 15893, 15791, 15679, 15557, 15426, 15286
        dw      15137, 14978, 14811, 14635, 14449, 14256, 14053, 13842, 13623, 13395, 13160, 12916, 12665, 12406, 12140, 11866
        dw      11585, 11297, 11003, 10702, 10394, 10080, 9760, 9434, 9102, 8765, 8423, 8076, 7723, 7366, 7005, 6639
        dw      6270, 5897, 5520, 5139, 4756, 4370, 3981, 3590, 3196, 2801, 2404, 2006, 1606, 1205, 804, 402
        dw      0, -402, -804, -1205, -1606, -2006, -2404, -2801, -3196, -3590, -3981, -4370, -4756, -5139, -5520, -5897
        dw      -6270, -6639, -7005, -7366, -7723, -8076, -8423, -8765, -9102, -9434, -9760, -10080, -10394, -10702, -11003, -11297
        dw      -11585, -11866, -12140, -12406, -12665, -12916, -13160, -13395, -13623, -13842, -14053, -14256, -14449, -14635, -14811, -14978
        dw      -15137, -15286, -15426, -15557, -15679, -15791, -15893, -15986, -16069, -16143, -16207, -16261, -16305, -16340, -16364, -16379
        dw      -16384, -16379, -16364, -16340, -16305, -16261, -16207, -16143, -16069, -15986, -15893, -15791, -15679, -15557, -15426, -15286
        dw      -15137, -14978, -14811, -14635, -14449, -14256, -14053, -13842, -13623, -13395, -13160, -12916, -12665, -12406, -12140, -11866
        dw      -11585, -11297, -11003, -10702, -10394, -10080, -9760, -9434, -9102, -8765, -8423, -8076, -7723, -7366, -7005, -6639
        dw      -6270, -5897, -5520, -5139, -4756, -4370, -3981, -3590, -3196, -2801, -2404, -2006, -1606, -1205, -804, -402
        dw      0, 402, 804, 1205, 1606, 2006, 2404, 2801, 3196, 3590, 3981, 4370, 4756, 5139, 5520, 5897
        dw      6270, 6639, 7005, 7366, 7723, 8076, 8423, 8765, 9102, 9434, 9760, 10080, 10394, 10702, 11003, 11297
        dw      11585, 11866, 12140, 12406, 12665, 12916, 13160, 13395, 13623, 13842, 14053, 14256, 14449, 14635, 14811, 14978
        dw      15137, 15286, 15426, 15557, 15679, 15791, 15893, 15986, 16069, 16143, 16207, 16261, 16305, 16340, 16364, 16379

        CODESEG

                PUBLIC  _RotatePoints   ;this function can be called from C
                PUBLIC  _qsort3d        ;sorts sx & sy in "rz-order"

; qsort(int low_boundary, int upper_boundary);
PROC    _qsort3d       NEAR
        ARG     lb:Word, ub:Word        ;lower & upper boundary

;       down = BX, up = SI index = DI a=DX
        
        push    bp
        mov     bp,sp
        push    si
        push    di
        push    ax
        
        mov     di,[lb]         ;/* set index to lower boundary */
        shl     di,1            ;integer arrays
        mov     ax,[_rz+di]
        shr     di,1
        mov     dx,ax           ; a=rz[indexA];
        mov     bx,[lb]         ; down=lb;
        mov     si,[ub]         ; up=ub;

@@lp1:
;        while((rz[down]<=a)&&(down<=ub)) down++;
        shl     bx,1
        mov     ax,[_rz+bx]
        shr     bx,1
        cmp     ax,dx
        jg      @@s1
        cmp     bx,[ub]
        jg      @@s1
        inc     bx
        jmp     @@lp1
@@s1:
;        while((rz[up]>a)&&(up>=lb)) up--;
        shl     si,1
        mov     ax,[_rz+si]
        shr     si,1
        cmp     ax,dx
        jle     @@s2
        cmp     si,[lb]
        jl      @@s2
        dec     si
        jmp     @@s1
@@s2:
        cmp     si,bx
        jle     @@s3            ;if up > down xchange rz[up] and rz[down]
        shl     bx,1
        shl     si,1
        mov     cx,[_rz+bx]
        mov     ax,[_rz+si]
        mov     [_rz+bx],ax
        mov     [_rz+si],cx
        mov     cx,[_sx+bx]
        mov     ax,[_sx+si]
        mov     [_sx+bx],ax
        mov     [_sx+si],cx
        mov     cx,[_sy+bx]
        mov     ax,[_sy+si]
        mov     [_sy+bx],ax
        mov     [_sy+si],cx
        shr     bx,1
        shr     si,1
@@s3:
        cmp     bx,si
        jl     @@lp1
        shl     di,1
        shl     si,1
        mov     cx,[_rz+di]
        mov     ax,[_rz+si]
        mov     [_rz+di],ax
        mov     [_rz+si],cx
        mov     cx,[_sx+di]
        mov     ax,[_sx+si]
        mov     [_sx+di],ax
        mov     [_sx+si],cx
        mov     cx,[_sy+di]
        mov     ax,[_sy+si]
        mov     [_sy+di],ax
        mov     [_sy+si],cx
        shr     di,1
        shr     si,1

        mov     di,si   ;indexA=up;

        push    [ub]    ;assume that conditions below is true and push
        inc     di      ;parameters to recursive call
        mov     ax,di
        push    di
        dec     di
        dec     di
        push    di
        push    [lb]
; if(indexA-1-lb > 0) quicksort(lb,indexA-1);
; if(ub-(indexA+1) > 0) quicksort(indexA+1,ub);
        sub     di,[lb]
        jle     @@s4
        call    _qsort3d
@@s4:   pop     [lb]              ;pop used parameters off the stack
        pop     di
        mov     cx,[ub]
        sub     cx,ax
        jle     @@s5
        call    _qsort3d
@@s5:   pop     di
        pop     [ub]
        
        pop     ax
        pop     di
        pop     si
        pop     bp
        ret
ENDP    _qsort3d



;RotPoint rotates one point using the precalculated values stored in
;sinax,sinay,sinaz,cosax,cosay and cosaz
;Destroys: ax,edx,si,edi,es
;Input:    bx= X cx= Y bp= Z
;Output:   bx= rotatedX cx= rotatedY bp= rotatedZ
        PROC    RotPoint       NEAR
    
                                ; Rotate point around the X-axis
                                ; ry = cos(angle x) * y - sin(angle x) * z
                                ; rz = sin(angle x) * y + cos(angle x) * z
        mov     ax,[cosax]      ; ax = cos(angle x)
        imul    cx              ; dx:ax = cos(angle x) * y
        mov     di,dx           ; dx:ax means that the high word of the multiplication
        shl     edi,16          ; is in dx and the low word in ax
        mov     di,ax           ; edi = by * cos(angle x)
        mov     ax,[sinax]      ; ax = sin(angle x)
        imul    bp              ; ax = sin(angle x) * z
        shl     edx,16
        mov     dx,ax           ; edx = bz * sinax
        sub     edi,edx         ; edi=edi-edx= cos(angle x)*y - sin(angle x)*z
        sar     edi,14          ; shift to the actual value (fixed point math)
        mov     es,di           ; save rotated y in es
        mov     ax,[sinax]      ; ax = sin(angle x)
        imul    cx              ; dx:ax = sin(angle x) * y
        mov     di,dx
        shl     edi,16
        mov     di,ax           ; edi = sin(angle x) * y
        mov     ax,[cosax]      ; ax = cos(angle x)
        imul    bp              ; dx:ax = cos(angle x) * z
        shl     edx,16
        mov     dx,ax           ; edx = cos(angle x) * z
        add     edi,edx         ;edi=edi+edx = sin(angle x)*y + cos(angle x)*z
        sar     edi,14          ;shift right => di = actual value of rotated z
        mov     cx,es           ; cx = ry (rotated y)
        mov     bp,di           ; bp = rz (rotated z)

                                ; Rotate point around the Y-axis
                                ; rx =  cos(angle y) * x + sin(angle y) * rz
                                ; rrz = -sin(angle y) * x + cos(angle y) * rz
        mov     ax,[cosay]      ; ax = cos(angle y)
        imul    bx              ; dx:ax = cos(angle y) * x
        mov     di,dx
        shl     edi,16
        mov     di,ax           ; edi = cos(angle y) * x
        mov     ax,[sinay]      ; ax = sin(angle y)
        imul    bp              ; dx:ax = sin(angle y) * rz
        shl     edx,16
        mov     dx,ax           ; edx = sin(angle y) * rz
        add     edi,edx         ;edi=edi+edx= cos(angle y)*x + sin(angle y)*rz
        sar     edi,14          ; apply fixed point math
        mov     es,di           ; save rx (rotated x) in es
        mov     ax,[sinay]      ; ax = sin(angle y)
        neg     ax              ; ax = -sin(angle y)
        imul    bx              ; dx:ax = -sin(angle y) * x
        mov     di,dx
        shl     edi,16
        mov     di,ax           ; edi = -sin(angle y) * x
        mov     ax,[cosay]      ; ax = cos(angle y)
        imul    bp              ; dx:ax = cos(angle y) * rz
        shl     edx,16
        mov     dx,ax           ; edx = cos(angle y) * rz
        add     edi,edx         ;edi=edi-edx=-sin(angle y)*x + cos(angle y)*rz
        sar     edi,14          ;fp math, di = rrz (rotated rz)
        mov     bx,es           ; bx = rx (rotated x)
        mov     bp,di           ; bp = rrz (rotated rotated z)

                                ; Rotate point around the Z-axis
                                ; rrx = cos(vz) * rx - sin(vz) * ry
                                ; rry = sin(vz) * rx + cos(vz) * ry
        mov     ax,[cosaz]      ; ax = cos(angle z)
        imul    bx              ; dx:ax = cos(angle z) * rx
        mov     di,dx
        shl     edi,16
        mov     di,ax           ;edi = cos(angle z) * rx
        mov     ax,[sinaz]      ; ax = sin(angle z)
        imul    cx              ; dx:ax = sin(angle z) * ry
        shl     edx,16
        mov     dx,ax           ; edx = sin(angle z) * ry
        sub     edi,edx         ;edi=edi-edx=cos(angle z)*rx - sin(angle z)*ry
        sar     edi,14          ; shift right to actual value
        mov     es,di           ; es = rrx
        mov     ax,[sinaz]      ; ax = sin(angle z)
        imul    bx              ; dx:ax = sin(angle z) * rx
        mov     di,dx
        shl     edi,16
        mov     di,ax           ; edi = sin(angle z) * rx
        mov     ax,[cosaz]      ; ax = cos(angle z)
        imul    cx              ; dx:ax = cos(angle z) * ry
        shl     edx,16
        mov     dx,ax           ; edx = cos(angle z) * ry
        add     edi,edx         ;edi=edi+edx=sin(angle z)*rx + cos(angle z)*ry
        sar     edi,14          ; shift right to actual value
        mov     bx,es           ; bx = rrx (rotated rx)
        mov     cx,di           ; cx = rry (rotated ry)
    
    ret
ENDP RotPoint

                
;CalcSxSy Calculates the Screen (x,y) coordinates using a perspective
;projection on the (x,y,z) coordinates. Screen distance is 256.
;CalcSxSy also adds half width of the screen to the sx coordinate and half 
;height of the screen to the sy coordinate to make the coordinates
;centered around the center of the screen.
;Destroys: ax,dx,bp
;Input:    bx= X cx= Y bp= Z
;Output:   bx= SX, cx =SY
PROC    CalcSxSy    NEAR
                                ; Perspective Projection:
                                ; SX = DIST * X / (DIST + Z)
                                ; SY = DIST * Y / (DIST + Z)
        movsx   eax,bx          ; eax = x-coord. with Sign eXtension
        shl     eax,8           ; eax = 256*x  (distance is 256)
        mov     edx,eax         ; edx = 256*x
        shr     edx,16          ; dx:ax = 256*x (DIST * X)
        add     bp,256          ; bp = DIST + Z 
        idiv    bp              ; quote of division => ax
        add     ax,HALFX        ; add ax with 320/2 (half width of screen)
        mov     bx,ax           ; bx = 256*x / (256 + z) + 160
        
        movsx   eax,cx          ; eax = y-coord. with Sign eXtension
        shl     eax,8           ; eax = 256*y
        mov     edx,eax
        shr     edx,16          ; dx:ax = 256*y (DIST * Y)
        idiv    bp              ; divide with (DIST + Z)
        add     ax,HALFY        ; add result of division with half screen height
        mov     cx,ax           ; cx = 256*y/(256 + z) + 100
        ret
ENDP    CalcSxSy
    
;_RotatePoints rotates NUM_OF_PTS points in (_bx,_by,_bz) (rotx,roty,rotz) degrees,
;adds addx,addy,addz to the coordinates, stores them in _rx, _ry & _rz
;and finally calculates the screen coordinates and stores them in _sx and _sy.
;*********** Call from c with: ***************
;*** RotatePoints(ax, ay, az, num_of_pts); *** 
;*********************************************
        PROC    _RotatePoints   NEAR
        ARG     rotx:Byte, roty:Byte, rotz:Byte, num_of_pts:Word
        
        push    bp              ;this bp,sp trick must be here if
        mov     bp,sp           ;you use arguments (has to do with the stackframe)
        pushad                  ;save all registers
    
        mov     bl,[rotx]
        xor     bh,bh
        shl     bx,1            ;bx = index in sintab and costab
        mov     ax,[sintab + bx] ;move the appropriate value from the sintab
        mov     [sinax],ax       ; to sinax
        mov     ax,[costab + bx] ; and the appropriate value from costab
        mov     [cosax],ax       ; to cosax
        mov     bl,[roty]       ; do the same with sinay & cosay
        xor     bh,bh
        shl     bx,1
        mov     ax,[sintab + bx]
        mov     [sinay],ax
        mov     ax,[costab + bx]
        mov     [cosay],ax
        mov     bl,[rotz]       ; and sinaz & cosaz
        xor     bh,bh
        shl     bx,1
        mov     ax,[sintab + bx]
        mov     [sinaz],ax
        mov     ax,[costab + bx]
        mov     [cosaz],ax
        
        mov     di,[num_of_pts] ;di = loopcounter
@@rotloop:                      ;loop through all points in the arrays
        dec     di              ;let di be both loopcounter and index in the arrays
        shl     di,1            ;di = di * 2 because the arrays are type int
        mov     bx,[_bx + di]   ;load cordinates to rotate
        mov     cx,[_by + di]
        mov     bp,[_bz + di]

        push    di
        call    RotPoint        ;rotate the coordinates of one point
        pop     di

        add     bx,[_addx]      ;add "movement" to the rotated coordinates
        add     cx,[_addy]
        add     bp,[_addz]
        
        mov     [_rx + di],bx   ;save rotated coordintates in _rx, _ry & _rz
        mov     [_ry + di],cx
        mov     [_rz + di],bp
        call    CalcSxSy        ;calculate the screen coordinates
        mov     [_sx + di],bx   ;and save them in _sx and _sy
        mov     [_sy + di],cx
        
        shr     di,1            ;shift di back into acting as loopcounter
        or      di,di           ;is di 0 yet?
        jnz     @@rotloop       ;if not, rotate another point
    
        popad                   ;restore the saved registers
        pop     bp
        ret
ENDP _RotatePoints
        
        
        END
