'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |   BASWIZ  (C) Copyright 1996 Charon Software, All Rights Reserved    |
'   |                                                                      |
'   |                      The BASIC Wizard's Library                      |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   DECLARE SUB FOpen (File$, FMode$, BufferLen%, Handle%, ErrCode%)
   DECLARE FUNCTION FGetSize& (BYVAL Handle%)
   DECLARE FUNCTION FRead$ (BYVAL Handle%, BYVAL Bytes%)
   DECLARE SUB FClose (Handle%)

SUB GetInfoBMP (File$, PicWidth%, PicHeight%, PicColors%, ErrCode%)
   ErrCode% = 0
   FOpen File$, "R", 100, Handle%, ErrCode%
   IF ErrCode% = 0 THEN
      Header$ = FRead$(Handle%, 34)
      IF FGetError% OR (LEN(Header$) <> 34) THEN
         ErrCode% = FGetError%
      ELSE
         PWide& = CVL(MID$(Header$, 19, 4))
         PHigh& = CVL(MID$(Header$, 23, 4))
         BitPlanes% = CVI(MID$(Header$, 27, 2))
         ColorBits% = CVI(MID$(Header$, 29, 2))
         IF LEFT$(Header$, 2) <> "BM" THEN
            ErrCode% = -1    ' invalid BMP
         ELSEIF NOT (BitPlanes% = 1 AND (ColorBits% = 4 OR ColorBits% = 8)) THEN
            ErrCode% = -2    ' color format not supported
         ELSEIF CVL(MID$(Header$, 31, 4)) <> 0& THEN
            ErrCode% = -3    ' compression not supported
         ELSEIF CVL(MID$(Header$, 3, 4)) <> FGetSize&(Handle%) THEN
            ErrCode% = -4    ' incorrect file size
         ELSEIF PWide& < 1& OR PWide& > 32767& OR PHigh& < 1& OR PHigh& > 32767& THEN
            ErrCode% = -5    ' ludicrous image size
         END IF
         IF ErrCode% = 0 THEN
            PicWidth% = PWide&
            PicHeight% = PHigh&
            IF ColorBits% = 4 THEN
               PicColors% = 16
            ELSE
               PicColors% = 256
            END IF
         END IF
      END IF
      FClose Handle%
   END IF
END SUB
