        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include argc.inc
include vrt.inc
include kb.inc
include gnbg.inc
include muz.inc
include grfx.inc
include end.inc

extrn   _l0_setup:near, _l0start:near, _l1start:near, _l2start:near

public  _main

public  _pals_ptr, _pals_len, _pals_index, _bufptr
public  _bufsel, _vidsel, _loop, _ending, _cpal, _bpal
public  _l0rout, _l1rout, _l2rout, _l1stop, _l1on, _l2on, _l2order

public  _done, _pals

;
; DATA
;
align 4
_l0rout         dd      _l0start
_l1rout         dd      _l1start        ;                                    |
_l2rout         dd      _l2start        ;                                    |

_l1stop         db      0
_l1on           db      0
_l2on           db      0
_l2order        db      0

align 4
_pals_ptr       dd      ?               ; ptr to RGB data for pal slide
_pals_len       dw      ?               ; number of colors to slide
_pals_index     db      ?               ; first color to slide

align 4
_bufptr         dd      ?               ; ptr to 256x256 virtual screen

_loop           dd      0               ; loop counter

_bufsel         dw      ?               ; selector of 256x256 virtual screen
_vidsel         dw      ?               ; selector of beginning of real vidmem

_skipend        db      0               ; skip end screen
_ending         db      0               ; demo is ending

_cpal           db      300h dup(0)
_bpal           db      300h dup(0)

copyrightmsg    db      'Timeless: Copywrong (c) 1994, Tran (a.k.a. Thomas Pytel).',0dh,0ah,0dh,0ah,36
byemsg          db      'Cogito ergo sum... NOT!$'
errmsg0         db      'Not enough low memory!!!',7,36

;
; CODE
;

include pdoschar.rt
include pdosmsg.rt
include slbytet.rt
include gm56.rt

@set_palso      macro   index, len, ptr
        mov _pals_ptr,offset &ptr
        mov _pals_index,&index
        mov _pals_len,&len
        mov _vrt_rout,offset _pals
endm

@set_palo       macro   index, len, ptr
        mov esi,offset &ptr
        mov _vrt_palptr,esi
        mov ecx,&index
        mov _vrt_palindex,cl
        lea edi,[ecx*2+ecx+offset _cpal]
        mov ecx,&len
        mov _vrt_pallen,cx
        lea ecx,[ecx*2+ecx]
        rep movsb
endm

include misc.m

;
_pals:
        cmp _vrt_pallen,0
        jne _ret
        push ebx edi
        movzx ecx,_pals_len
        lea eax,[ecx-1]
        shr al,7
        mov _vrt_pallen,cx
        lea ecx,[ecx*2+ecx]
        movzx ebx,_pals_index
        mov _vrt_palindex,bl
        lea edi,[ebx*2+ebx+offset _cpal]
        mov _vrt_palptr,edi
        mov esi,_pals_ptr
        call _slidebytetbl
        jnc short palsd
        mov _vrt_rout,offset _ret
palsd:
        pop edi ebx
        ret

;
exit:
        push edx
        call _vrt_uninit
        call _resetkb
        mov v86r_ax,3
        mov al,10h
        int 33h
        mov edx,offset copyrightmsg
        call _putdosmsg
        call _muz_uninit
        pop edx
        call _putdosmsg
        jmp _exit

;
_main:
        sti

        call _l0_setup
        call _misc_setup
        call _muz_setup
        call _gm56
        call _initkb
        call _vrt_init
        call _muz_init
        @vrt_setpalo 0,100h,_cpal

        mov eax,10000h
        call _getlomem
        mov edx,offset errmsg0
        jc exit
        mov edi,eax
        mov edx,eax
        mov _bufptr,eax
        mov ecx,64*256
        xor eax,eax
        rep stosd
        call _getselector
        add edx,_code32a
        call _setselector
        mov _bufsel,ax
        call _getselector
        mov edx,0a0000h
        call _setselector
        mov _vidsel,ax

        mov esi,offset align256start
        mov edi,esi
        and edi,0ffffff00h
        mov ecx,offset align256end
        sub ecx,esi
        rep movsb

        call _gnbg_setup
        call _muz_play
        mov fs,_bufsel

;-----------------------------------------------------------------------------
ml0:
        call _l0rout
        call _gnbg_draw

        movzx eax,_l2order
        push eax
        call _l1rout[eax*4]
        pop eax
        xor al,1
        call _l1rout[eax*4]
        call _gnbg_flip

        cmp _kbtbl1[1],0
        je ml0
        mov _kbtbl1[1],0

_done:
        @set_palso 0,100h,_bpal
        call _muz_stop
        mov _ending,1

ml1:
        call _l0rout
        call _gnbg_draw

        movzx eax,_l2order
        push eax
        call _l1rout[eax*4]
        pop eax
        xor al,1
        call _l1rout[eax*4]
        call _gnbg_flip

        cmp _vrt_rout,offset _pals
        je ml1
        call _muz_wait

;-----------------------------------------------------------------------------
        cmp _skipend,0
        jne short mf0
        call _end
mf0:

        mov edx,offset byemsg
        jmp exit

code32  ends
        end

