;Hi-res plasma code.  (c) Alex Allmont (AKA btf) 1995  aallmont@plym.ac.uk
;Not SVGA, just pretty darned hi-res VGA mode-x trickery!
;Because of the HUUUUUGGE amounts of data being dumped to the screen, this
;code is only really happy on a hefty machine.

;The 'plasma' is just a load of sine waves along x and y, thrown together in
;a reckless manner.  That's not a totally great description, but if you can't
;suss it out...TOUGH!

	.model medium
	.386
	.dosseg
	.stack
	.data

SCREEN_SIZE EQU 400*80

ESCAPE	EQU	01h	    ;Scancodes
CUR_UP	EQU	48h
CUR_DN	EQU	50h
CUR_LF	EQU	4bh
CUR_RT	EQU	4dh
CTRL	EQU	1dh
ALT	EQU	38h
DELETE	EQU	53h

;۲     Structures used to store plasma data
;Each wave is defined as a starting angle; 'theta', an amplitute; 'amp', and
;a frequency' 'freq', (though it merely a relative measure).  The change in
;theta per cycle is given by 'dtheta'
wave	STRUCT
	theta	dw  ?	    ;Current angle at which wave starts
	amp	dw  ?	    ;Amplitude of wave
	freq	dw  ?	    ;Sampling rate along curve => frequency
	dtheta	dw  ?	    ;Change in theta per cycle
wave	ENDS

LENWAVE EQU	200
;'wave4' stores 4 separate waves.  The below routines manipulate each of these
;and sum and store the output into one wave, stored in 'output'
wave4	STRUCT
	wave0	wave	<?,?,?,?>
	wave1	wave	<?,?,?,?>
	wave2	wave	<?,?,?,?>
	wave3	wave	<?,?,?,?>
	output	db	LENWAVE DUP (?)
wave4	ENDS

;۲     Wave info
xwave1	wave4	<<0,40,1,5>,<30,50,2,4>,<71,18,8,2>,<1,18,7,3>>
ywave1	wave4	<<10,50,2,3>,<450,30,3,5>,<110,26,3,8>,<150,20,13,7>>
xwave2	wave4	<<40,30,3,-2>,<80,60,2,-3>,<291,16,2,-1>,<51,20,11,-4>>
ywave2	wave4	<<100,40,3,5>,<45,40,3,8>,<10,22,11,11>,<150,26,5,13>>

;Pointer to current wave to calculate
curwave dw	OFFSET xwave1
curlen	dw	200	;length of current wave

;'detail' relates to the zoom ratio, it actually scales down the angle within
;the wave building routine.  'grain' has the effect of adding more 'bands' of
;colour to each contour of plasma
detail	db	2
grain	db	13

;INT 9 INFO - key is a table of keys, 1 if hit, 0 if not
;currentkey is the most recent keypress
;lastkey is used as a cache to prevent keyboard repeat
key	db	128 dup (0)
currentkey	db	0
lastkey	db	0

;Palette data
pal	db	'pal',768-3 dup (0)

;End text
txt1	db	'Use the cursors to alter zoom/grain.   btf / Esponge - aallmont@plym.ac.uk.'
txt1l	dw	$-txt1

;Insults to the minorities...
crapPC1 db	"Wha?  No VGA card?  Blimey...$"
crapPC2 db	"Tum tee tum, tee-tum tee too, your machine is a piece of poo.  I WANNA 386!$"

;A 'virtual' screen is employed.  This 320x200 mode uses approximately half of
;the total video memory, so the code writes to a part of the video mem that is
;currently off (pointed to by soff1) screen and then uses a hardware scroll to
;do a fast pan to that part of the video memory (yoff1).  - ie FLICKER FREE!
yoff1	dw	400	    ;Current y offset of screen
yoff2	dw	0
soff1	dw	400*80	    ;Offset of screen at which to write data
soff2	dw	0

filename    db	40 dup (0)  ;filename of palette if specified at com-line.
txt2	db	'Error opening palette file.$'

	.code

;۲     Select plane macro
plane	MACRO	reg
	mov dx, 03c4h
	mov ah, reg
	mov al, 02h
	out dx, ax
	ENDM

	.startup

;۲     Main code segment
main	PROC	FAR

	call OKmachine	    ;Is machine good enough?
	call commandline    ;Get what the user says, if anything

	call init_int8	    ;Init timer
	call init_int9	    ;Init keyboard
	call initgraph	    ;Init graphics

m0:	call buildwaves     ;Construct waves
	call plotplasma     ;Plot the output to the video planes
	call getkeyinfo     ;User input
	cmp key[ESCAPE], 0  ;escape not recieved?
	je  m0

	call deinitgraph    ;Restore graphics
	call deinit_int9    ;Restore keyboard
	call deinit_int8    ;Restore timer

main	ENDP

	.exit


;۲     Check machine stats
OKmachine   PROC    NEAR		;Check for 386+, thanks to
	push sp				;Psi for the code.
	pop dx
	cmp dx, sp
	jz  o1
o2:	jmp need386
o1:	mov bx, OFFSET xwave1.output
	sgdt ds:[bx]			;Don't understand this bit,
	cmp byte ptr ds:[bx+5],0	;though %-/  Protected mode goobers!
	js  o2

	mov ax, 1A00h			;Check for VGA
	int 10h
	cmp al, 1Ah
	jne needVGA
	cmp bl, 07h
	jb  needVGA
	ret

;PC not good enough.  Return -1
needVGA:
	mov ah, 09h
	mov dx, OFFSET crapPC1
	int 21h
	mov ax, 4cffh
	int 21h

need386:
	mov ah, 09h
	mov dx, OFFSET crapPC2
	int 21h
	mov ax, 4cffh
	int 21h

OKmachine   ENDP


;۲ 	Get command line info - was another palette file specified?
commandline PROC    NEAR

	push es
	mov ah, 51h		;Get PSP
	int 21h

	push ds
	push ds
	pop es
	mov ds, bx		;es=data seg, ds=PSP

	mov si, 128		;Beginning of text in PSP
	lodsb

	xor ah, ah		;Any text at command line?
	xor cx, cx
	mov cl, al
	or  cx, cx		;(cx=no chars)
	jz  cl1
	cmp cx, 38
	jg  cl1

	dec cx
	inc si
	mov di, OFFSET filename     ;Get filename in psp > filename
	cld
rep	movsb

	pop ds
	pop es

	mov dx, OFFSET filename     ;Open filename
	mov al, 0
	mov ah, 3dh
	int 21h
	jc  diskerror
	mov bx, ax		    ;Load in palette > pal
	mov dx, OFFSET pal
	mov cx, 768
	mov ah, 3fh
	int 21h
	jc  diskerror
	ret

cl1:	pop ds			;Exit with no effect
	pop es
	ret

diskerror:			;Cripes!  Disk error.  Exit to dos and cry
	mov ah, 09h
	mov dx, OFFSET txt2
	int 21h
	.exit

commandline ENDP


;۲     ;Operate on different keypresses
getkeyinfo  PROC    NEAR

	.if key[CUR_UP]==1 && lastkey!=CUR_UP
	dec detail
	.if detail>128
	mov detail, 0
	.endif
	.endif

	.if key[CUR_DN]==1 && lastkey!=CUR_DN
	inc detail
	.if detail>3
	mov detail, 3
	.endif
	.endif

	.if key[CUR_RT]==1 && lastkey!=CUR_RT
	dec grain
	.if grain<9
	mov grain, 9
	.endif
	.endif

	.if key[CUR_LF]==1 && lastkey!=CUR_LF
	inc grain
	.if grain>16
	mov grain, 16
	.endif
	.endif

	;Just in case the user panics!
	.if key[CTRL]==1 && key[ALT]==1 && key[DELETE]==1
	mov key[ESCAPE], 1
	.endif

	mov al, currentkey
	mov lastkey, al

	ret

getkeyinfo  ENDP


;----------------KEYBOARD HANDLER STUFF-----------------------------------
oldint9 dd  ?	    ;address of old interrupt

;۲     Install new handler
init_int9   PROC    NEAR

	cli
	mov ax, 0
	mov gs, ax
	mov eax, gs:[4*9]			;store old interrupt
	mov cs:oldint9, eax
	mov ax, cs				;newint address in eax
	shl eax, 16
	mov ax, OFFSET int9
	mov gs:[4*9], eax			;store new int
	sti

	ret

init_int9   ENDP


;۲     Reinstall old handler
deinit_int9 PROC    NEAR

	cli
	mov ax, 0
	mov gs, ax
	mov eax, cs:oldint9
	mov gs:[4*9], eax			;store new int
	sti

	ret

deinit_int9    ENDP


;۲     New keyboard routine.  Stores table of active keys in 'key'
int9	PROC	NEAR

	cli
	push ax
	push bx
	push ds
	mov ax, DGROUP
	mov ds, ax
	in  al, 60h		;Get scancode
	mov currentkey, al	;Current key
	mov bl, al
	mov bh, 0
	.if bl<80h
	mov key[bx], 1		;Store a hit
	.else
	mov key[bx-80h], 0	;Store a release
	.endif

	in  al, 61h		;Acknowledge interrupt
	mov ah, al
	or  al, 80h
	out 61h, al
	mov al, ah
	out 61h, al

	pop ds
	pop bx
	mov al,20h
	out 20h,al
	pop ax
	sti

	iret

int9	ENDP

;------------INTERRUPT 8 HANDLER STUFF(timer) ------------------------------
oldint8 dd  ?		;Address of old interrupt

;۲ 	install new timer int.	runs at 70Hz approx
init_int8   PROC    NEAR

	mov ax, 0
	mov gs, ax

	mov eax, gs:[4*8]			;store old interrupt
	mov cs:oldint8, eax

	mov ax, cs				;newint address in eax
	shl eax, 16
	mov ax, OFFSET int8
	mov dx, 17000				;70 Hz
	cli
	mov gs:[4*8], eax			;store new int

	mov al, 036h			;dx=freq
	out 43h, al
	mov al, dl
	out 40h, al
	mov al, dh
	out 40h, al
	sti

	ret

init_int8   ENDP


;۲     Restore timer
deinit_int8 PROC    NEAR

	mov ax, 0
	mov gs, ax

	mov eax, cs:oldint8
	mov dx, 0

	cli
	mov gs:[4*8], eax			;store new int

	mov al, 036h			;dx=freq
	out 43h, al
	mov al, dl
	out 40h, al
	mov al, dh
	out 40h, al
	sti

	ret

deinit_int8    ENDP

;۲ 	New handler, increments the sine angles.
int8	PROC	NEAR

	cli
	push ax
	push cx
	push si
	push ds
	mov ax, DGROUP
	mov ds, ax

	mov si, OFFSET xwave1
	call add4waveoff
	mov si, OFFSET ywave1
	call add4waveoff
	mov si, OFFSET xwave2
	call add4waveoff
	mov si, OFFSET ywave2
	call add4waveoff

	pop ds
	pop si
	pop cx
	mov al, 20h		;this be end of interrupt
	out 20h, al
	pop ax

	sti
	iret				;interrupt return

int8	ENDP


;۲     Routine to add all the offsets in one wave
add4waveoff PROC    NEAR

	mov cx, 4
a4wo:	mov ax, [si+6]
	add [si], ax
	add si, 8
	dec cx
	jnz a4wo

	ret

add4waveoff ENDP

;---------------------------------------------------------------------------


;۲     Builds all the waves
buildwaves  PROC    NEAR

	mov ax, OFFSET xwave1
	mov curwave, ax
	mov curlen, 160
	call buildwave

	mov ax, OFFSET ywave1
	mov curwave, ax
	mov curlen, 200
	call buildwave

	mov ax, OFFSET xwave2
	mov curwave, ax
	mov curlen, 160
	call buildwave

	mov ax, OFFSET ywave2
	mov curwave, ax
	mov curlen, 200
	call buildwave

	ret

buildwaves  ENDP


;۲    Builds the wave pointed to by 'curwave'
buildwave   PROC    NEAR

	mov si, curwave
	mov di, si
	add di, 8*4	    ;di points to output

	mov cx, curlen	    ;Clear the current contents
	shr cx, 2
	push di
	push es
	push ds
	pop es
	mov eax, 0
rep	stosd
	pop es
	pop di

	mov cx, 4	    ;4 waves to add up
bw0:	push di
	push cx

	mov cx, curlen
	mov bx, [si]
bw1:	push bx
	push cx
	shl bx, 1	    ;\
	mov cl, detail	    ; }(has the effect of zooming in)
	shr bx, cl	    ;/
	call sine
	mov ax, [si+2]	    ;Mul by amplitude
	imul bx
	mov cl, grain	    ;\Has the effect of adding more 'bands'
	shrd ax, dx, cl     ;/
	pop cx
	add [di], al	    ;Add to output
	pop bx
	add bx, [si+4]	    ;Add frequency to current theta
	inc di
	dec cx
	jnz bw1

	add si, 8	    ;Onto next wave
	pop cx
	pop di
	dec cx
	jnz bw0

	ret

buildwave   ENDP


;-----------VIDEO SCMOOO-----------------------------------------------------

;۲     Set VGA 320x400x256 cols, es=video seg, also sets up 'rows' table
;	    sets palette as data in pal
initgraph   PROC    NEAR

	mov ax, 13h		    ;VGA
	int 10h
	call chain4		    ;Tweak 'im

	mov ax, 0a000h
	mov es, ax

	plane 1111b		    ;Clear alllllll memory
	mov eax, 0
	mov cx, 80*400/4
	mov di, 0
rep	stosd

	call waitv		    ;Contemplate for a bit
	call waitv

	mov al, 0		    ;Palette
	mov dx, 3c8h
	out dx, al
	inc dx
	mov cx, 768
	mov si, OFFSET pal
rep	outsb

	ret

initgraph   ENDP


;۲     Return to standard DOS mode 3
deinitgraph PROC    NEAR

	mov ax, 03h		    ;Dos mode
	int 10h

	mov ax, 0b800h		    ;Endtext - gotta get my name on it <g!>
	mov es, ax
	mov si, OFFSET txt1
	mov cx, txt1l
	mov di, 0
	mov ah, 0ah
dig0:	lodsb
	stosw
	dec cx
	jnz dig0

	ret

deinitgraph ENDP


;۲     Plonk video into a 320x400x256 col modex mode
;	    just remembered - these tweaks are from Dreaden/VLA, so I'll give
;	    him a huuuuge amount of credit fo them!  TA!
;	    (I think it's from an archive called modex.zip or something...)
tweaks	LABEL	word

    dw	    04009h  ; cell height
    dw      00014h  ; turn off dword mode
    dw      0e317h  ; turn on byte mode

chain4	PROC	NEAR

;do right bits to unchain
	mov dx, 03c4h
	mov al, 4
	out dx, al
	inc dx
	in  al, dx
	and al, 11110111b
	out dx, al

;disable word/doubleword (I don't know why)
	mov dx, 03d4h
	mov ax, 0e317h
	out dx, ax
	mov ax, 0014h
	out dx, ax

;320x400
	mov dx, 3c2h		    ;Set dot clock
	mov al, 0e3h
	out dx, al

	mov dx, 3d4h		    ;Tweaks
	mov cx, 3
	xor si, si
tw:	mov ax, cs:tweaks[si]
	out dx, ax
	inc si
	inc si
	loop tw

	ret

chain4	ENDP


;۲     Scroll screen up by yoff
pos	PROC	NEAR

	mov ax, yoff1
	mov bx, 80
	mul bx
	mov bx, ax

	mov dx, 03d4h
	mov al, 0ch
	out dx, al
	inc dx
	mov al, bh
	out dx, al

	dec dx
	mov al, 0dh
	out dx, al
	inc dx
	mov al, bl
	out dx, al

	ret

pos	ENDP


;۲     Plot plasma from data
;	    this form of 'plasma' is essentially a mad combination of sine
;	    waves.  This code creates it's image from 2 sets of waves.  Each
;	    'set' of waves consists of two waves, one running along x, the
;	    other along y, these are added to obtain a colour at point (x,y).
;	    The actual waves along x and y are built up from sampling 4 sine
;	    waves of various amplitude and frequency into one wave.  (see
;	    'buildwave').
;	    The 2 sets of waves create two separate images, but the high
;	    resolution/subtle colours fool the eye a little into thinking it's
;	    just one smooth image (I hope!). The waves are put together with
;	    the following pattern:
;			X  -->
;		     0	  1	2     3
;		    ---- ----- ----- -----	    1/2 = separate sets of
;	     Y	0 | 1-2 | 1-2 | 1-2 | 1-2 |		    colours
;		  | 2-1 | 2-1 | 2-1 | 2-1 |
;	     |	    ---- ----- ----- -----
;	     V	1 | 1-2 | 1-2 | 1-2 | 1-2 |
;		  | 2-1 | 2-1 | 2-1 | 2-1 |
;		    ---- ----- ----- -----
;
;
;	    ...Hmm, that doesn't make much sence, does it?  <g!> Essentially,
;	    it dithers one 'pixel' from two colours, arranged diagonally in a
;	    four pixel set.
;	    Though it's probably hard to see this from what's below...	;)
;	    that's because this all started out as one loop, but to make the
;	    dithering work and to optimize it for writing to separate planes,
;	    it's all become very convoluted and become 8 separate loops.
;
;	    btw, it tried not writing directly to the video buffer, using a
;	    chunk of memory to write to and then doing a 'fast' copy to video
;	    memory using a 'movsd' instruction, but on the whole it didn't
;	    make much difference, I think it actually slowed it down a bit.
;	    - & soaked up a big wodge of memory.  So I dumped that idea.
;
plotplasma  PROC    NEAR

;-----------PLANE 1
	plane 1000b

	mov di, soff1
	mov si, OFFSET xwave1
	add si, 8*4+1
	mov bx, OFFSET ywave1
	add bx, 8*4

	mov cx, 200
pp0:	push cx
	push si

	mov cx, 80
pp1:	mov al, [si]
	add al, [bx]
	add al, 128
	mov es:[di], al
	inc di
	add si, 2
	dec cx
	jnz pp1

	inc bx
	add di, 80
	pop si
	pop cx
	dec cx
	jnz pp0


	mov di, 80
	add di, soff1
	mov si, OFFSET xwave2
	add si, 8*4+1
	mov bx, OFFSET ywave2
	add bx, 8*4

	mov cx, 200
pp0a:	push cx
	push si

	mov cx, 80
pp1a:	mov al, [si]
	add al, [bx]
	add al, 128
	mov es:[di], al
	inc di
	add si, 2
	dec cx
	jnz pp1a

	inc bx
	add di, 80
	pop si
	pop cx
	dec cx
	jnz pp0a


;---------- PLANE 2
	plane 0100b

	mov di, soff1
	mov si, OFFSET xwave1
	add si, 8*4+1
	mov bx, OFFSET ywave1
	add bx, 8*4

	mov cx, 200
pp0b:	push cx
	push si

	mov cx, 80
pp1b:	mov al, [si]
	add al, [bx]
	add al, 128
	mov es:[di+80], al
	inc di
	add si, 2
	dec cx
	jnz pp1b

	inc bx
	add di, 80
	pop si
	pop cx
	dec cx
	jnz pp0b


	mov di, 80
	add di, soff1
	mov si, OFFSET xwave2
	add si, 8*4+1
	mov bx, OFFSET ywave2
	add bx, 8*4

	mov cx, 200
pp0ab:	push cx
	push si

	mov cx, 80
pp1ab:	mov al, [si]
	add al, [bx]
	add al, 128
	mov es:[di-80], al
	inc di
	add si, 2
	dec cx
	jnz pp1ab

	inc bx
	add di, 80
	pop si
	pop cx
	dec cx
	jnz pp0ab



;---------PLANE 3
	plane 0010b

	mov di, soff1
	mov si, OFFSET xwave1
	add si, 8*4
	mov bx, OFFSET ywave1
	add bx, 8*4

	mov cx, 200
pp01:	push cx
	push si

	mov cx, 80
pp11:	mov al, [si]
	add al, [bx]
	add al, 128
	mov es:[di], al
	inc di
	add si, 2
	dec cx
	jnz pp11

	inc bx
	add di, 80
	pop si
	pop cx
	dec cx
	jnz pp01


	mov di, 80
	add di, soff1
	mov si, OFFSET xwave2
	add si, 8*4
	mov bx, OFFSET ywave2
	add bx, 8*4

	mov cx, 200
pp01a:	push cx
	push si

	mov cx, 80
pp11a:	mov al, [si]
	add al, [bx]
	add al, 128
	mov es:[di], al
	inc di
	add si, 2
	dec cx
	jnz pp11a

	inc bx
	add di, 80
	pop si
	pop cx
	dec cx
	jnz pp01a


;-------- PLANE 4
	plane 0001b

	mov di, soff1
	mov si, OFFSET xwave1
	add si, 8*4
	mov bx, OFFSET ywave1
	add bx, 8*4

	mov cx, 200
pp01b:	push cx
	push si

	mov cx, 80
pp11b:	mov al, [si]
	add al, [bx]
	add al, 128
	mov es:[di+80], al
	inc di
	add si, 2
	dec cx
	jnz pp11b

	inc bx
	add di, 80
	pop si
	pop cx
	dec cx
	jnz pp01b


	mov di, 80
	add di, soff1
	mov si, OFFSET xwave2
	add si, 8*4
	mov bx, OFFSET ywave2
	add bx, 8*4

	mov cx, 200
pp01ab:	push cx
	push si

	mov cx, 80
pp11ab:	mov al, [si]
	add al, [bx]
	add al, 128
	mov es:[di-80], al
	inc di
	add si, 2
	dec cx
	jnz pp11ab

	inc bx
	add di, 80
	pop si
	pop cx
	dec cx
	jnz pp01ab


;-------- SWAP SCREENS
	call pos
	mov ax, yoff1
	mov bx, yoff2
	mov yoff2, ax
	mov yoff1, bx
	mov ax, soff1
	mov bx, soff2
	mov soff2, ax
	mov soff1, bx

	ret

plotplasma  ENDP


;۲     Wait for FULL vertical refresh
waitv	PROC	NEAR

	mov dx, 3dah
wv0:	in al, dx
	test al, 8
	jnz wv0
wv1:	in al, dx
	test al, 8
	jz wv1

	ret

waitv	ENDP

;----------------------------------------------------------------------------

;۲     Sine function returns bl=32767*sine(bl*360/1024)
;	    (this is a rather detailed table, but the extra info helps the
;	    granularity of the output a little)

sintable     dw   0 , 201 , 402 , 603 , 804 , 1005 , 1206 , 1407
        dw   1608 , 1809 , 2009 , 2210 , 2410 , 2611 , 2811 , 3012 
        dw   3212 , 3412 , 3612 , 3811 , 4011 , 4210 , 4410 , 4609 
        dw   4808 , 5007 , 5205 , 5404 , 5602 , 5800 , 5998 , 6195 
        dw   6393 , 6590 , 6786 , 6983 , 7179 , 7375 , 7571 , 7767 
        dw   7962 , 8157 , 8351 , 8545 , 8739 , 8933 , 9126 , 9319 
        dw   9512 , 9704 , 9896 , 10087 , 10278 , 10469 , 10659 , 10849 
        dw   11039 , 11228 , 11417 , 11605 , 11793 , 11980 , 12167 , 12353 
        dw   12539 , 12725 , 12910 , 13094 , 13279 , 13462 , 13645 , 13828 
        dw   14010 , 14191 , 14372 , 14553 , 14732 , 14912 , 15090 , 15269 
        dw   15446 , 15623 , 15800 , 15976 , 16151 , 16325 , 16499 , 16673 
        dw   16846 , 17018 , 17189 , 17360 , 17530 , 17700 , 17869 , 18037 
        dw   18204 , 18371 , 18537 , 18703 , 18868 , 19032 , 19195 , 19357 
        dw   19519 , 19680 , 19841 , 20000 , 20159 , 20317 , 20475 , 20631 
        dw   20787 , 20942 , 21096 , 21250 , 21403 , 21554 , 21705 , 21856 
        dw   22005 , 22154 , 22301 , 22448 , 22594 , 22739 , 22884 , 23027 
        dw   23170 , 23311 , 23452 , 23592 , 23731 , 23870 , 24007 , 24143 
        dw   24279 , 24413 , 24547 , 24680 , 24811 , 24942 , 25072 , 25201 
        dw   25329 , 25456 , 25582 , 25708 , 25832 , 25955 , 26077 , 26198 
        dw   26319 , 26438 , 26556 , 26674 , 26790 , 26905 , 27019 , 27133 
        dw   27245 , 27356 , 27466 , 27575 , 27683 , 27790 , 27896 , 28001 
        dw   28105 , 28208 , 28310 , 28411 , 28510 , 28609 , 28706 , 28803 
        dw   28898 , 28992 , 29085 , 29177 , 29268 , 29358 , 29447 , 29534 
        dw   29621 , 29706 , 29791 , 29874 , 29956 , 30037 , 30117 , 30195 
        dw   30273 , 30349 , 30424 , 30498 , 30571 , 30643 , 30714 , 30783 
        dw   30852 , 30919 , 30985 , 31050 , 31113 , 31176 , 31237 , 31297 
        dw   31356 , 31414 , 31470 , 31526 , 31580 , 31633 , 31685 , 31736 
        dw   31785 , 31833 , 31880 , 31926 , 31971 , 32014 , 32057 , 32098 
        dw   32137 , 32176 , 32213 , 32250 , 32285 , 32318 , 32351 , 32382 
        dw   32412 , 32441 , 32469 , 32495 , 32521 , 32545 , 32567 , 32589 
        dw   32609 , 32628 , 32646 , 32663 , 32678 , 32692 , 32705 , 32717 
        dw   32728 , 32737 , 32745 , 32752 , 32757 , 32761 , 32765 , 32766 
        dw   32767 , 32766 , 32765 , 32761 , 32757 , 32752 , 32745 , 32737 
        dw   32728 , 32717 , 32705 , 32692 , 32678 , 32663 , 32646 , 32628 
        dw   32609 , 32589 , 32567 , 32545 , 32521 , 32495 , 32469 , 32441 
        dw   32412 , 32382 , 32351 , 32318 , 32285 , 32250 , 32213 , 32176 
        dw   32137 , 32098 , 32057 , 32014 , 31971 , 31926 , 31880 , 31833 
        dw   31785 , 31736 , 31685 , 31633 , 31580 , 31526 , 31470 , 31414 
        dw   31356 , 31297 , 31237 , 31176 , 31113 , 31050 , 30985 , 30919 
        dw   30852 , 30783 , 30714 , 30643 , 30571 , 30498 , 30424 , 30349 
        dw   30273 , 30195 , 30117 , 30037 , 29956 , 29874 , 29791 , 29706 
        dw   29621 , 29534 , 29447 , 29358 , 29268 , 29177 , 29085 , 28992 
        dw   28898 , 28803 , 28706 , 28609 , 28510 , 28411 , 28310 , 28208 
        dw   28105 , 28001 , 27896 , 27790 , 27683 , 27575 , 27466 , 27356 
        dw   27245 , 27133 , 27019 , 26905 , 26790 , 26674 , 26556 , 26438 
        dw   26319 , 26198 , 26077 , 25955 , 25832 , 25708 , 25582 , 25456 
        dw   25329 , 25201 , 25072 , 24942 , 24811 , 24680 , 24547 , 24413 
        dw   24279 , 24143 , 24007 , 23870 , 23731 , 23592 , 23452 , 23311 
        dw   23170 , 23027 , 22884 , 22739 , 22594 , 22448 , 22301 , 22154 
        dw   22005 , 21856 , 21705 , 21554 , 21403 , 21250 , 21096 , 20942 
        dw   20787 , 20631 , 20475 , 20317 , 20159 , 20000 , 19841 , 19680 
        dw   19519 , 19357 , 19195 , 19032 , 18868 , 18703 , 18537 , 18371 
        dw   18204 , 18037 , 17869 , 17700 , 17530 , 17360 , 17189 , 17018 
        dw   16846 , 16673 , 16499 , 16325 , 16151 , 15976 , 15800 , 15623 
        dw   15446 , 15269 , 15090 , 14912 , 14732 , 14553 , 14372 , 14191 
        dw   14010 , 13828 , 13645 , 13462 , 13279 , 13094 , 12910 , 12725 
        dw   12539 , 12353 , 12167 , 11980 , 11793 , 11605 , 11417 , 11228 
        dw   11039 , 10849 , 10659 , 10469 , 10278 , 10087 , 9896 , 9704 
        dw   9512 , 9319 , 9126 , 8933 , 8739 , 8545 , 8351 , 8157 
        dw   7962 , 7767 , 7571 , 7375 , 7179 , 6983 , 6786 , 6590 
        dw   6393 , 6195 , 5998 , 5800 , 5602 , 5404 , 5205 , 5007 
        dw   4808 , 4609 , 4410 , 4210 , 4011 , 3811 , 3612 , 3412 
        dw   3212 , 3012 , 2811 , 2611 , 2410 , 2210 , 2009 , 1809 
        dw   1608 , 1407 , 1206 , 1005 , 804 , 603 , 402 , 201 
        dw   0 ,-201 ,-402 ,-603 ,-804 ,-1005 ,-1206 ,-1407 
        dw  -1608 ,-1809 ,-2009 ,-2210 ,-2410 ,-2611 ,-2811 ,-3012 
        dw  -3212 ,-3412 ,-3612 ,-3811 ,-4011 ,-4210 ,-4410 ,-4609 
        dw  -4808 ,-5007 ,-5205 ,-5404 ,-5602 ,-5800 ,-5998 ,-6195 
        dw  -6393 ,-6590 ,-6786 ,-6983 ,-7179 ,-7375 ,-7571 ,-7767 
        dw  -7962 ,-8157 ,-8351 ,-8545 ,-8739 ,-8933 ,-9126 ,-9319 
        dw  -9512 ,-9704 ,-9896 ,-10087 ,-10278 ,-10469 ,-10659 ,-10849 
        dw  -11039 ,-11228 ,-11417 ,-11605 ,-11793 ,-11980 ,-12167 ,-12353 
        dw  -12539 ,-12725 ,-12910 ,-13094 ,-13279 ,-13462 ,-13645 ,-13828 
        dw  -14010 ,-14191 ,-14372 ,-14553 ,-14732 ,-14912 ,-15090 ,-15269 
        dw  -15446 ,-15623 ,-15800 ,-15976 ,-16151 ,-16325 ,-16499 ,-16673 
        dw  -16846 ,-17018 ,-17189 ,-17360 ,-17530 ,-17700 ,-17869 ,-18037 
        dw  -18204 ,-18371 ,-18537 ,-18703 ,-18868 ,-19032 ,-19195 ,-19357 
        dw  -19519 ,-19680 ,-19841 ,-20000 ,-20159 ,-20317 ,-20475 ,-20631 
        dw  -20787 ,-20942 ,-21096 ,-21250 ,-21403 ,-21554 ,-21705 ,-21856 
        dw  -22005 ,-22154 ,-22301 ,-22448 ,-22594 ,-22739 ,-22884 ,-23027 
        dw  -23170 ,-23311 ,-23452 ,-23592 ,-23731 ,-23870 ,-24007 ,-24143 
        dw  -24279 ,-24413 ,-24547 ,-24680 ,-24811 ,-24942 ,-25072 ,-25201 
        dw  -25329 ,-25456 ,-25582 ,-25708 ,-25832 ,-25955 ,-26077 ,-26198 
        dw  -26319 ,-26438 ,-26556 ,-26674 ,-26790 ,-26905 ,-27019 ,-27133 
        dw  -27245 ,-27356 ,-27466 ,-27575 ,-27683 ,-27790 ,-27896 ,-28001 
        dw  -28105 ,-28208 ,-28310 ,-28411 ,-28510 ,-28609 ,-28706 ,-28803 
        dw  -28898 ,-28992 ,-29085 ,-29177 ,-29268 ,-29358 ,-29447 ,-29534 
        dw  -29621 ,-29706 ,-29791 ,-29874 ,-29956 ,-30037 ,-30117 ,-30195 
        dw  -30273 ,-30349 ,-30424 ,-30498 ,-30571 ,-30643 ,-30714 ,-30783 
        dw  -30852 ,-30919 ,-30985 ,-31050 ,-31113 ,-31176 ,-31237 ,-31297 
        dw  -31356 ,-31414 ,-31470 ,-31526 ,-31580 ,-31633 ,-31685 ,-31736 
        dw  -31785 ,-31833 ,-31880 ,-31926 ,-31971 ,-32014 ,-32057 ,-32098 
        dw  -32137 ,-32176 ,-32213 ,-32250 ,-32285 ,-32318 ,-32351 ,-32382 
        dw  -32412 ,-32441 ,-32469 ,-32495 ,-32521 ,-32545 ,-32567 ,-32589 
        dw  -32609 ,-32628 ,-32646 ,-32663 ,-32678 ,-32692 ,-32705 ,-32717 
        dw  -32728 ,-32737 ,-32745 ,-32752 ,-32757 ,-32761 ,-32765 ,-32766 
        dw  -32767 ,-32766 ,-32765 ,-32761 ,-32757 ,-32752 ,-32745 ,-32737 
        dw  -32728 ,-32717 ,-32705 ,-32692 ,-32678 ,-32663 ,-32646 ,-32628 
        dw  -32609 ,-32589 ,-32567 ,-32545 ,-32521 ,-32495 ,-32469 ,-32441 
        dw  -32412 ,-32382 ,-32351 ,-32318 ,-32285 ,-32250 ,-32213 ,-32176 
        dw  -32137 ,-32098 ,-32057 ,-32014 ,-31971 ,-31926 ,-31880 ,-31833 
        dw  -31785 ,-31736 ,-31685 ,-31633 ,-31580 ,-31526 ,-31470 ,-31414 
        dw  -31356 ,-31297 ,-31237 ,-31176 ,-31113 ,-31050 ,-30985 ,-30919 
        dw  -30852 ,-30783 ,-30714 ,-30643 ,-30571 ,-30498 ,-30424 ,-30349 
        dw  -30273 ,-30195 ,-30117 ,-30037 ,-29956 ,-29874 ,-29791 ,-29706 
        dw  -29621 ,-29534 ,-29447 ,-29358 ,-29268 ,-29177 ,-29085 ,-28992 
        dw  -28898 ,-28803 ,-28706 ,-28609 ,-28510 ,-28411 ,-28310 ,-28208 
        dw  -28105 ,-28001 ,-27896 ,-27790 ,-27683 ,-27575 ,-27466 ,-27356 
        dw  -27245 ,-27133 ,-27019 ,-26905 ,-26790 ,-26674 ,-26556 ,-26438 
        dw  -26319 ,-26198 ,-26077 ,-25955 ,-25832 ,-25708 ,-25582 ,-25456 
        dw  -25329 ,-25201 ,-25072 ,-24942 ,-24811 ,-24680 ,-24547 ,-24413 
        dw  -24279 ,-24143 ,-24007 ,-23870 ,-23731 ,-23592 ,-23452 ,-23311 
        dw  -23170 ,-23027 ,-22884 ,-22739 ,-22594 ,-22448 ,-22301 ,-22154 
        dw  -22005 ,-21856 ,-21705 ,-21554 ,-21403 ,-21250 ,-21096 ,-20942 
        dw  -20787 ,-20631 ,-20475 ,-20317 ,-20159 ,-20000 ,-19841 ,-19680 
        dw  -19519 ,-19357 ,-19195 ,-19032 ,-18868 ,-18703 ,-18537 ,-18371 
        dw  -18204 ,-18037 ,-17869 ,-17700 ,-17530 ,-17360 ,-17189 ,-17018 
        dw  -16846 ,-16673 ,-16499 ,-16325 ,-16151 ,-15976 ,-15800 ,-15623 
        dw  -15446 ,-15269 ,-15090 ,-14912 ,-14732 ,-14553 ,-14372 ,-14191 
        dw  -14010 ,-13828 ,-13645 ,-13462 ,-13279 ,-13094 ,-12910 ,-12725 
        dw  -12539 ,-12353 ,-12167 ,-11980 ,-11793 ,-11605 ,-11417 ,-11228 
        dw  -11039 ,-10849 ,-10659 ,-10469 ,-10278 ,-10087 ,-9896 ,-9704 
        dw  -9512 ,-9319 ,-9126 ,-8933 ,-8739 ,-8545 ,-8351 ,-8157 
        dw  -7962 ,-7767 ,-7571 ,-7375 ,-7179 ,-6983 ,-6786 ,-6590 
        dw  -6393 ,-6195 ,-5998 ,-5800 ,-5602 ,-5404 ,-5205 ,-5007 
        dw  -4808 ,-4609 ,-4410 ,-4210 ,-4011 ,-3811 ,-3612 ,-3412 
        dw  -3212 ,-3012 ,-2811 ,-2611 ,-2410 ,-2210 ,-2009 ,-1809 
        dw  -1608 ,-1407 ,-1206 ,-1005 ,-804 ,-603 ,-402 ,-201 

sine	PROC	NEAR

	and bx, 1023
	add bx, bx
	mov bx, cs:sintable[bx]

	ret

sine	ENDP

	END
