; Smooth vertical scroller by Patch - hamell@cs.pdx.edu
; Made for the intro Motion by Avalanche
; Done sometime in December 1993
;
; If you use this code in any manner, please inform me.
;
; If you want to be cool, modify this so the number of lines can be unlimited.
; If you do so, please email me the new source code.

.model small
.stack 1024
.386

.data
linecount       db      0
screen_offs     dw      160
include         status.inc
include         motion-a.inc

.code
TOPSCREENOFFS   EQU     160
LINECOMPAREVAL  EQU     367
VIEWLINES       EQU     23
PIXELSTEP       EQU     2
NUMSTEPS        EQU     14/PIXELSTEP
include         key.inc

WaitVRetrace    MACRO
                LOCAL   VRetrace,NoVRetrace
                mov     dx,03dah
VRetrace:       in      al,dx
                test    al,00001000b
                jnz     VRetrace
NoVRetrace:     in      al,dx
                test    al,00001000b
                jz      NoVRetrace
                ENDM

WaitVActive     MACRO
                LOCAL   VActive
                mov     dx,03dah
VActive:        in      al,dx
                test    al,00001000b
                jnz     VActive
                ENDM
                
WaitVInactive   MACRO
                LOCAL   VInactive
                mov     dx,03dah
VInactive:      in      al,dx
                test    al,00001000b
                jz      VInactive 
                ENDM

WaitHRetrace    MACRO
                LOCAL   HRetrace,NoHRetrace
                mov     dx,03dah
HRetrace:       in      al,dx
                test    al,00000001b
                jnz     HRetrace
NoHRetrace:     in      al,dx
                test    al,00000001b
                jz      NoHRetrace
                ENDM

WaitHActive     MACRO
                LOCAL   HActive
                mov     dx,03dah
HActive:        in      al,dx
                test    al,00000001b
                jnz     HActive
                ENDM
                
WaitHInactive   MACRO
                LOCAL   HInactive
                mov     dx,03dah
HInactive:      in      al,dx
                test    al,00000001b
                jz      HInactive
                ENDM

Set_Start_Addr  MACRO
                mov     bx,[screen_offs]        ; set starting address
                mov     dx,03d4h
                mov     al,0ch
                mov     ah,bh
                out     dx,ax
                inc     al
                mov     ah,bl
                out     dx,ax
                ENDM

start:          mov     ax,@data
                mov     ds,ax

                call    _Set_New_Int9
                
                mov     ax,0003h
                int     10h
                mov     ax,0100h                ; hide the cursor
                mov     cx,0800h
                int     10h

                WaitVRetrace
                push    LINECOMPAREVAL
                call    _Set_Line_Compare
                add     sp,2

                Set_Start_Addr
                WaitVRetrace

                cld
                mov     ax,0b800h               ; dump status bar to screen
                mov     es,ax
                xor     di,di
                mov     si,offset STATUSBAR
                mov     cx,STATUSBAR_LEN
                rep     movsw

                mov     di,[screen_offs]        ; dump ansi to screen
                shl     di,1                    ; *2, each offset is 2 bytes
                mov     si,offset ANSI_SCREEN
;                add     si,160
                mov     cx,ANSI_DEPTH*80
                rep     movsw
                
get_key: 
;                cmp     cs:[_keynumpress],0
;                je      get_key
                
                cmp     cs:_keys[kUARROW],1     ; cursor up?
                je      key_up
                cmp     cs:_keys[kKEYPAD8],1    ; cursur up?
                je      key_up
                cmp     cs:_keys[kDARROW],1     ; cursor down?
                je      key_down
                cmp     cs:_keys[kKEYPAD2],1    ; cursor down?
                je      key_down
                cmp     cs:_keys[kHOME],1       ; home?
                je      key_home
                cmp     cs:_keys[kEND],1        ; end?
                je      key_end
                cmp     cs:_keys[kPGUP],1       ; pgup?
                je      key_pgup
                cmp     cs:_keys[kPGDN],1       ; pgdn?
                je      key_pgdn
                cmp     cs:_keys[kESC],1        ; esc?
                je      exit
                jmp     get_key
                
key_up:         cmp     [linecount],0           ; at top?
                je      get_key                 ; if so, jump
                dec     [linecount]             
                sub     [screen_offs],80        ; one line up

                WaitVRetrace
                Set_Start_Addr
                
                mov     bx,1008h                ; start at char line 14
                mov     cx,NUMSTEPS
pan_up:         WaitVInactive
                WaitHActive
                sub     bh,PIXELSTEP            ; next line of char
                mov     dx,03d4h
                mov     ax,bx
                out     dx,ax
                dec     cx
                jnz     pan_up

                WaitVInactive
                WaitHActive
                mov     dx,03d4h
                mov     ax,0008h                ; set char line to 0
                out     dx,ax
                
                jmp     get_key

key_down:       cmp     [linecount],ANSI_DEPTH-VIEWLINES
                je      get_key
                inc     [linecount]
                add     [screen_offs],80
                
                mov     bx,0008h                ; start at char line 0
                mov     cx,NUMSTEPS
pan_down:       WaitVInactive
                WaitHActive
                add     bh,PIXELSTEP            ; next char line
                mov     dx,03d4h
                mov     ax,bx
                out     dx,ax
                dec     cx
                jnz     pan_down

                WaitVRetrace
                Set_Start_Addr
                
                WaitVInactive
                WaitHActive
                mov     dx,03d4h
                mov     ax,0008h                ; set char line to 0
                out     dx,ax

                jmp     get_key

key_home:       cmp     [linecount],0
                je      get_key
                mov     [linecount],0
                mov     [screen_offs],TOPSCREENOFFS

                WaitVRetrace
                Set_Start_Addr
                
                jmp     get_key
                
key_end:        cmp     [linecount],ANSI_DEPTH-VIEWLINES
                je      get_key
                mov     [linecount],ANSI_DEPTH-VIEWLINES
                mov     [screen_offs],(ANSI_DEPTH-VIEWLINES)*80
                add     [screen_offs],TOPSCREENOFFS

                WaitVRetrace
                Set_Start_Addr
                
                jmp     get_key
                
key_pgup:       cmp     [linecount],0           ; at top line?
                je      get_key
                cmp     [linecount],24          ; full screen left to view?
                jbe     key_home                ; if not, jump
                
                sub     [linecount],VIEWLINES
                sub     [screen_offs],80*VIEWLINES

                WaitVActive
                Set_Start_Addr

                mov     cx,8
pan_pgup:       WaitVRetrace
                dec     cx
                jnz     pan_pgup
                
                jmp     get_key
                
key_pgdn:       cmp     [linecount],ANSI_DEPTH-VIEWLINES ; at bottom line?
                je      get_key
                cmp     [linecount],ANSI_DEPTH+1-VIEWLINES*2
                                                        ; full screen to view?
                jae     key_end                         ; if not, jump
                
                add     [linecount],VIEWLINES
                add     [screen_offs],80*VIEWLINES

                WaitVRetrace
                Set_Start_Addr
                
                mov     cx,8
pan_pgdn:       WaitVRetrace
                dec     cx
                jnz     pan_pgdn
                
                jmp     get_key
                
exit:           call    _Set_Old_Int9
                mov     ax,0003h                ; text mode 3
                int     10h
                mov     ax,4c00h                ; exit
                int     21h


;******************************************************************************
;* PROC    : void Set_Line_Compare(word rasterline);
;* Purpose : Sets the line compare
;*           The area above the line compare is the segment and offset where
;*                the start address is set to.
;*           The area below the line compare is at A000:0000.
;* Entrance: rasterline - the raster line to set for line compare
;*                        for every pixel line, there are 2 raster lines
;*                        so pixel line 100 is raster line 200
;* Exit    : nothing
;******************************************************************************
_Set_Line_Compare       PROC    NEAR
                        push    bp
                        mov     bp,sp

                        mov     bx,[bp + 4]             ; BX = line value
                        mov     dx,03d4h                ; CRTC reg

                        mov     al,09h                  ; 09h = max scan line index
                        out     dx,al                   ; 10th bit of line compare
                        inc     dl                      ;   goes in bit 6 of the index
                        in      al,dx                   ; read in previous contents
                        mov     ah,bh                   ; get bit 10 of line compare
                        or      ah,11111101b            ; make other bits 1 as a mask
                        ror     ah,03h                  ; move to bit 6
                        and     al,ah                   ; AND them together
                        out     dx,al

                        dec     dl                      ; 03d4h
                        mov     al,07h                  ; 07h = overflow index
                        out     dx,al                   ; 9th bit of line compare
                        inc     dl                      ;   goes in bit 4 of the index
                        in      al,dx                   ; read in previous contents
                        mov     ah,bh                   ; get bit 9 of line compare
                        or      ah,11111110b            ; make other bits 1 as a mask
                        rol     ah,04h                  ; move to bit 4
                        and     al,ah                   ; AND them together
                        out     dx,al

                        dec     dl                      ; 03d4h
                        mov     al,18h                  ; 18h = line compare index
                        mov     ah,bl                   ; AH = lower 8 bits
                        out     dx,ax

                        pop     bp
                        ret
_Set_Line_Compare       ENDP

                END     start
