/*******************************
**			      **
**	   Keyboard.h	      **
**			      **
**  A set of useful routines  **
**  for controlling keyboard  **
**  settings and information. **
**			      **
**  (C) 1994 by Sean Werkema  **
**  Revision 2.01  1/13/1995  **
**			      **
*******************************/

/*
**  Function prototypes
*/

extern int KeyASCII();
/*     Holds last ASCII value read from keyboard.  Changes with each read,
**     but does not change with each call.
*/
extern int KeyScan();
/*     Holds last scan code value read from keyboard.  Changes with each read,
**     but does not change with each call.
*/
extern int GetCursorStart(void);
/*     Returns value corresponding to top of cursor, usually 0-7.
*/
extern int GetCursorEnd(void);
/*     Returns value corresponding to bottom of cursor, usually 0-7.
*/
extern void SetCursorSize(int Start, int End);
/*     Adjusts cursor size to top and bottom values (usually from 0-7).
*/
extern int GetCursorX(int page);
/*     Returns horizontal position of cursor, ranging from 1 to <scrn width>.
**     If page is -1, the currently displayed page will be used.
*/
extern int GetCursorY(int page);
/*     Returns vertical position of cursor, ranging from 1 to <scrn height>.
**     If page is -1, the currently displayed page will be used.
*/
extern void SetCursorPos(int page, int X, int Y);
/*     Moves cursor to specified coordinates, with the origin at 1.
**     If page is -1, the currently displayed page will be used.
*/
extern int ReadKeyASCII(void);
/*     Waits for a key to be pressed, then returns the ASCII value of that
**     key.  KeyASCII and KeyScan are set to the key's ASCII value & scan code.
*/
extern int ReadKeyScan(void);
/*     Waits for a key to be pressed, then returns the scan code of that
**     key.  KeyASCII and KeyScan are set to the key's ASCII value & scan code.
*/
extern int KeyStatus(void);
/*     Returns 1 if a keypress is waiting, and 0 if no keypress is waiting.  If
**     1, KeyASCII and KeyScan are set to the key's ASCII value & scan code.
*/
extern int KeyFlags(void);
/*     Returns keyboard flags: L Shf, R Shf, Ctrl, Alt, Caps, Num, Scrl, Ins.
*/
extern int EReadKeyASCII(void);
/*     Waits for a key to be pressed, then returns the ASCII value of that
**     key.  KeyASCII and KeyScan are set to the key's ASCII value & scan code.
**     Same as ReadKeyASCII, except can detect extended keys.
*/
extern int EReadKeyScan(void);
/*     Waits for a key to be pressed, then returns the scan code of that
**     key.  KeyASCII and KeyScan are set to the key's ASCII value & scan code.
**     Same as ReadKeyScan, except can detect extended keys.
*/
extern int EKeyStatus(void);
/*     Returns 1 if a keypress is waiting, and 0 if no keypress is waiting.  If
**     1, KeyASCII and KeyScan are set to the key's ASCII value & scan code.
**     Same as KeyStatus, except can detect extended keys.
*/
extern int EKeyFlags(void);
/*     Returns keyboard flags: L Shf, R Shf, L Ctrl, R Ctrl, L Alt, R Alt,
**     Caps, Num, Scrl, Ins, SysReq.
**     Same as KeyFlags, except can detect extended keys.
*/
extern int IsEKeybd(void);
/*     Returns 0 if not an Extended Keyboard, 1 if is an Extended Keyboard.
*/

/*
**     Special keyboard control functions
*/

extern void NewKeyboard(void);
/*     Initializes special keyboard data control functions.
**     Standard functions will not work when special functions are
**     active, but the special functions allow more versatile control
**     of keyboard data.  Accepts no values, returns no values.
*/
extern void OldKeyboard(void);
/*     Deactivates special keyboard functions, allowing normal
**     functions to be used instead.  If special functions have
**     been activated, deactivate them before exiting program
**     or attempting to use normal functions.  Accepts no values,
**     returns no values.
*/
extern unsigned int GetStroke(void);
/*     Special function that returns a scan code corresponding to
**     a key press or release, both of which are stored in a FIFO
**     buffer from which this function reads its information.  If
**     the upper byte of the returned integer contains 0xE0 the
**     key press/release was from a key on the Extended Keyboard
**     (Gray Insert/Delete/Home/End/PgUp/PgDn/Arrows/Enter/Slash or Right
**     Ctrl/Alt).  If bit 7 is set (high bit of low byte) the value
**     indicates a key release; if bit 7 is clear, the value indicates
**     a key press.  If the returned integer is 0, no keystrokes are
**     waiting.  Low 7 bits contain scan code corresponding to
**     the key, as per the following table:
**
**			Scan Code Table (Hexadecimal values given)
**     Ŀ ĿĿ Ŀ Ŀ
**     01  3B3C3D3E3F404142 43445758 1246E1
**     Esc F1F2F3F4F5F6F7F8 F9101112 PSSLPz
**        
**     Ŀ Ŀ Ŀ
**     2902030405060708090A0B0C0D2B0E 524748 4535374A
**     ` 1 2 3 4 5 6 7 8 9 0 - = \ - InHmPU NL/ * - 
**     Ĵ Ĵ Ĵ
**     0F 101112131415161718191AAB     534F49 4748494E
**     TabQ W E R T Y U I O P [ ]      DlEnPD 7 8 9   
**      1C   Ĵ+ 
**     3A  1E1F202122232425262728	    		 4B4C4D  
**     CapsA S D F G H J K L ; '                4 5 6   
**     Ĵ	 Ŀ	 Ĵ
**      2A   2C2D2E2F303132333435 36    	 48	 4F50511C
**      ShiftZ X C V B N M , . /  Shift 	  	 1 2 3   
**     Ĵ Ŀ ĴE 
**      1D   38 	39		38   1D   4B504D 52   53n 
**     Ctrl  Alt	Spacebar	Alt  Ctrl     0    . t 
**           
**     NOTE: The following keys' scan codes are preceded by a 0xE0:
**     Right Alt;  Right Ctrl;	Grey Arrows,/,Ins,Home,Del,End,PgUp,PgDn,Enter.
*/
extern unsigned int TranASCII(int value);
/*     Translates a scan code into an unshifted (as if neither shift key
**     were held down) ASCII code.  Passed value is the same as that returned
**     by GetStroke, ReadKeyScan, or contained in KeyScan.  Returned value
**     is corresponding ASCII code.
*/
extern unsigned int TranASCII2(int value);
/*     Translates a scan code into a shifted (as if either shift key were
**     held down) ASCII code.  Passed value is the same as that returned
**     by GetStroke, ReadKeyScan, or contained in KeyScan.  Returned value
**     is corresponding ASCII code.
*/
