;****************************************************************************
; Filename: SETUPTO.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.April.13
;  Updated: -
;****************************************************************************
; Copyright Adam Seychell, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: _iostream_init
;  Comment: initalises the standard file io streams.
;    Input: Nothing.
;   Output: Nothing.
;****************************************************************************

        Include STDDEF.INC

        Codeseg

Public _opened_streams
Public __setupio


; ************ standard file stream structures ******************

_stdin_fstream   FILE < 11h ,,0, 0, 1,0, Offset _iobbuffer0 >
_stdout_fstream  FILE < 12h ,,1, 0, 1,0, Offset _iobbuffer1 >
_stderr_fstream  FILE < 12h ,,2, 0, 1,0, Offset _iobbuffer2 >
_stdaux_fstream  FILE < 12h ,,3, 0, BUFSIZ, 0, Offset _iobbuffer3 >
_stdprn_fstream  FILE < 12h ,,4, 0, BUFSIZ, 0, Offset _iobbuffer4 >



PROC fflush_all_outputs
        mov     eax,stdout
        call    @fflush
        mov     eax,stderr
        call    @fflush
        mov     eax,stdaux
        call    @fflush
        mov     eax,stdprn
        call    @fflush
        Ret
Endp


Proc __setupio
 ; see if the standard input or output has been redirected to a file
 ; if so then we must make it buffered.
 ;
        Mov     Edi,stdin
@@Loop01:
        Mov     eax,04400h          ; Get DOS device information
        mov     bx,[EDI+ FILE._handle]
        Int     21h
        Jc      LeaveAlone
        Test    Dl,128             ; if a file then bit 7 = 0
        jnz     LeaveAlone
		mov     [EDI+ FILE._buffersize], BUFSIZ ; give it a buffer
LeaveAlone:
        Add     Edi,(Size FILE)
        cmp     Edi,stdout
        jbe     @@Loop01
		mov     eax,Offset fflush_all_outputs     ; close on exit
        call    @atexit

 ;
 ; reset all static stream structures
 ;
        Clear   Eax
@@clrloop:
        Mov     [ EAX + _opened_streams._mode],0
        Add     Eax, Size FILE
        Cmp     Eax,FOPEN_MAX * (Size FILE)
        jb @@clrloop

        Ret
Endp





;          **** the standard stream buffers *****

Segment     _BSS
_iobbuffer0     DB  BUFSIZ Dup (?)
_iobbuffer1     DB  BUFSIZ Dup (?)
_iobbuffer2     DB  BUFSIZ Dup (?)
_iobbuffer3     DB  BUFSIZ Dup (?)
_iobbuffer4     DB  BUFSIZ Dup (?)

;         define all of the static file streams structures
_opened_streams  FILE FOPEN_MAX Dup (<>)

Ends       _BSS


End