;****************************************************************************
; Filename: FREAD.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.April.29
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: int @fread(char *storage, int size, int count, FILE *fileptr);
;  Comment: reads bytes from file stream
;    Input: Eax = pointer of data to be placed
;           Edx = size of elements
;           Ecx = number of elements read
;         [Esp] = pointer of opened file stream
;   Output: Eax = number of elements read.
;****************************************************************************

        Include STDDEF.INC

Extrn __UpdateBuffer:Near


        Codeseg

destination   dd ?

Proc    fread, 4
        Push    Edi
        Push    Esi
        Mov     Edi,[Esp+12]            ; get file ptr
        Push    Edx                     ; save element size
        Mov     [destination],Eax       ; Save read buffer
        Imul    Ecx,Edx
        Mov     Esi,Ecx
        Push    Esi                     ; save bytes to read

;        Test    [Edi+FILE._mode],1          ; Error if not readable
;        Jz      @@EOF
;        And     [Edi+FILE._mode],NOT 2      ; clear writeable flag

;        Cmp     Esi, [Edi+FILE._buffersize]
;        jae     _NoUpdate
;        Mov     Eax, [Edi+FILE._position]
;        Cmp     Eax, [Edi+FILE._size]
;        Jne     _SkipUpdate



;_SkipUpdate:

        Mov     Edx, [Edi+FILE._position]
        Mov     Ecx, [Edi+FILE._size]
        Sub     Ecx, Edx
        Ja      _NoMemcpy

        Cmp     Ecx,Esi
        Jb      _J99
        Mov     Ecx,Esi
_J99:
        Jecxz   _NoMemcpy
        Add     Edx, [Edi+FILE._base]
        Mov     Eax,[destination]
        Add     [destination],Ecx
        Add     [Edi+FILE._position],Ecx
        Sub     Esi,Ecx
        Call    @memcpy
        Test    Esi,Esi
        Jz      @@Finished

_NoMemcpy:
        Mov     Ax, [Edi+FILE._handle]
        Mov     Edx,[destination]
        Mov     Ecx,Esi
        Call    @read
        Cmp     Eax,-1
        Je @@Finished
        Sub     Esi,Eax

@@Finished:
        Pop     Eax                 ; Get bytes to read
        Pop     Ecx                 ; Get element size
        Sub     Eax,Esi
        Clear   Edx
        div     Ecx                 ; Calc number of items read.
        Pop     Esi
        Pop     Edi
        Ret

Endp

        End
