;****************************************************************************
; Filename: FOPEN.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.April.07
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: FILE * @fopen(void * filename, char * mode);
;  Comment: Opens the file specified by filename. The mode pointer is defined
;           "r"   open file for reading, return an error if it doesn't exist
;           "w"   open file for writing, create a new one if it doesn't exist
;           "a"   open file for writing at end of the file, create a new
;                 file if it doesn't exist
;                 doesn't exist
;           "r+"  open file for reading and writing, return an error if
;                 it doesn't already exist
;           "w+"  open new file for reading and writing, create a new
;                 file if it doesn't exist
;           "a+"  open file for reading and writing at end of file, create
;                 a new one if it does not exist
;    Input: Eax, filename - pointer to file name
;    Input: Edx, mode - pointer to file mode string
;   Output: file pointer of opened file or NULL if there were an error
;****************************************************************************

        Include STDDEF.INC

Public _findiop
Extrn _opened_streams :FILE

        Codeseg

Proc    _findiop
         Mov     Eax,Offset _opened_streams
@@Loop01:
         Test    [Eax + FILE._mode],10h
         Jz     @@exit
         Add     Eax, Size FILE
         cmp     Eax, (Offset _opened_streams)  + (FOPEN_MAX * Size FILE)
         Jb      @@Loop01
         Clear   Eax,Eax
@@exit:  Ret
Endp


Proc    fopen  ,2
        Push    Edi
        Push    Ebx
        Mov     Ecx,[Edx]
        Clear   Edx
        Cmp     Cl,"a"
        Mov     Dl,O_WRONLY Or O_CREAT Or O_APPEND
        Je      @@GotMode
        Cmp     Cl,"w"
        Mov     Dl,O_WRONLY Or O_CREAT Or O_TRUNC
        Je      @@GotMode
        Mov     Dl,0
@@GotMode:
        Cmp     Ch,"+"
        Jne     @@ReadWrite
        And     Dl,NOT 3
        Or      Dl,O_RDWR
@@ReadWrite:
        Mov     Bl,DL                   ; Save open mode in BL
        Call    @open
        Cmp     Eax,-1
        Je      @@Error
        Mov     Edi,Eax                 ; Di contains DOS file handle


  ; Find a free FILE structure and allocate file transfer buffer
  ;
        call    _findiop
        TestZ   Eax
        Jz      @@Error                     ; Error if run out of space
        Push    Eax

		Mov     Eax, BUFSIZ
        Call    @malloc
        Mov     Ecx,Eax
        Pop     Eax
        jecxz   @@Error
        Mov     [Eax + FILE._base], Ecx     ; Save address of the buffer
        Mov     [Eax + FILE._handle], Di    ; Save 16bit DOS file handle
        Mov     [Eax + FILE._position], 0
        Mov     [Eax + FILE._size], 0
		Mov     [Eax + FILE._buffersize], BUFSIZ
        And     bl,3
        Inc     bl
        or      bl,10h
        Mov     [Eax + FILE._mode], bl       ; Save i/o mode
@@Exit:
        Pop     Ebx
        Pop     Edi
        Ret

@@Error:
        Mov     Eax,NUL
        jmp @@Exit
Endp


        End
