;******************************************************************************
; Filename: OPEN.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1994.06.05
;  Updated: 1995.04.08
;******************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;******************************************************************************
; Function: LONG @open(PSZ filename,LONG filemode)
;  Comment: Opens a file
;    Input: Eax, filename - pointer to filename
;           Edx, filemode - O_APPEND, O_CREAT, O_TRUNC, O_EXCL
;                bits 0 & 1 control file access;
;                0 = read only
;                1 = write only
;                2 = read and write
;  Returns: file handle or -1 if an error occured
;******************************************************************************

        Include STDDEF.INC

        Codeseg

Proc    open ,2
                Test    Dl,O_TRUNC
                Push    Ebx,Eax,Edx
                Jz      @@Next01
                Mov     Eax,Edx
                And     [Byte Esp],Not O_EXCL
                Mov     Edx,[Esp+4]                     ;<- forgot this
@@Next03:       Mov     Ah,3Ch
                Clear   Ecx
                Int     21h
                Jc      @@Error
                Mov     Ebx,Eax
                Mov     Ah,3Eh
                Int     21h
                Jc      @@Error
@@Next01:       Mov     Edx,[Esp+4]
                Mov     Al,[Esp]
                And     Al,3
                Mov     Ah,3Dh
                Int     21h
                Jnc     @@Next02
                Cmp     Ax,2
                Jne     @@Error
                Test    [Byte Esp],O_CREAT
                Jz      @@Error
                And     [Byte Esp],Not O_EXCL
                Mov     Edx,[Esp+4]
                Jmp     @@Next03
        Align   4
@@Next02:       Test    [Byte Esp],O_CREAT
                Jz      @@Next04
                Test    [Byte Esp],O_EXCL
                Jne     @@ExitErr
@@Next04:       Test    [Byte Esp],O_APPEND
                Jz      @@Next05
                Mov     Ebx,Eax
                Clear   Edx
                Mov     Eax,4202h
                Int     21h
                Mov     Eax,Ebx
@@Next05:       Pop     +8,Ebx
                Ret
        Align   4
@@ExitErr:      Mov     Ebx,Eax
                Mov     Ah,3Eh
                Int     21h
                Mov     Eax,5
@@Error:        Mov     [Word errno],Ax
        IfDef   DEBUG
                Pop     Edx,+,Ebx
                Call    printf,Offset ErrOpenMsg,Edx,Ax
        Else
                Pop     +8,Ebx
        Endif
                Mov     Eax,-1
                Ret
Endp    

        Dataseg

errno           Dd      0

        IfDef   DEBUG
ErrOpenMsg      Db      "Error opening file '%s'! Error: %h",CRLF,0
        Endif

        End
