;****************************************************************************
; Filename: ATOI.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.May.01
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: int @atoi(char * string);
;  Comment: Converts an ascii number into an integer value. The string
;           consists of optional tabs and spaces followed by a optional sign
;           followed by decimal digits followed by optional non digit characters
;    Input: Eax, pointer to string
;   Output: integer of string. If could not read integer then a value of
;           zero is retunred and errno will equal -1
;****************************************************************************
Include  STDDEF.INC

    Codeseg

Proc    atoi  ,1
        
        Push    Esi
        Mov     Esi,Eax
        cld
@@skip_ch:
        lodsb
        cmp     Al,09           ; look for TAB
        je      @@skip_ch
        cmp     Al,10h          ; look for space
        je      @@skip_ch
        Dec     Esi

        mov     [sign_flag],0
        cmp     [byte ptr Esi],'-'
        jne     @@gotsign
        mov     [sign_flag],1
        Inc     Esi
@@gotsign:

        Xor     Edx,Edx

    ; Decode decimal number -------------------
    ;

        Mov     Al,[Esi]
        Sub     Al,'0'
        Cmp     Al,9
        Ja      @@error
        Jmp     @@LoopStart
@@DEC_loop:
        Sub     Al,'0'
        Cmp     Al,9
        Ja      @@GotNumber
        And     Eax,0FFh
        Imul    Edx,10
        Add     Edx,Eax
@@LoopStart:
        Mov     Al,[Esi]
        Inc     Esi
        Jmp     @@DEC_loop

@@GotNumber:
        cmp    [sign_flag],0
        je     @@j99
        Neg    Edx
@@j99:
        Mov    Eax,Edx
        mov    [errno],0
        Lea    Edx,[Esi-1]
        Pop    Esi
        Ret

@@error:
        mov    [errno],-1
        Clear   Eax
        Pop     Esi
        Ret
sign_flag DB ?
Endp  


End