;
;  A keyboard polling routine written by Jason Nunn
;
; 
;
.386
.model flat
.code

public key_pressed,get_key


;*********************************************************************
;funciton:       key_pressed
;
;Description:   Detects if the BIOS keyboad buffer is empty.
;
;Returns:       Carry = 0 if key is empty
;               Carry = 1 if key is not empty
;*********************************************************************

;*********************************************************************
;funciton:       get_key
;
;Description:    gets the next key from the BIOS keyboad buffer.
;                if not availible then waits for one.
;Returns:       AL = ascii code
;               AH = scan code
;*********************************************************************

key_pressed Proc
  push   esi
  mov    esi,[Zero_Addr]
  test   esi,esi
  jz     @@fixup_Zero_Addr
@@fixed_Zero_Addr:

  add    esi,41ah
  mov    ax,[esi]
  cmp    ax,[word ptr esi+2]
  jne    @@w
  pop    esi
  clc
  ret
@@w:
  movzx  eax,ax
  add    eax,400h
  add    eax,[Zero_Addr]
  mov    ax,[word ptr eax]
  pop    esi
  stc
  ret

@@fixup_Zero_Addr:      ; get zero address
  pushad
  mov ax,0ee02h
  int 31h
  neg ebx
  mov [Zero_Addr],ebx
  popad
  mov    esi,[Zero_Addr]
 jmp @@fixed_Zero_Addr
endp

Align 4
get_key Proc
@@l:
  call   key_pressed
  jnc    @@l
  mov    eax,0
  int    16h
  mov    [last_get_key],al
  ret
endp

Align 4
Zero_Addr             dd 0      ; contains address of linear address 0
last_get_key          db ?

end