; mandel.asm
;
; teeny program displays a portion of the Mandelbrot set.
;
; posted by Frank Hommers in early February 1995
;   posted in the 80XXX echo as a hex dump
;   original author?  94 bytes long
;
; revised by Mikko Hyvarinen in late Febrary 1995
;   optimized for size down to 92 bytes & posted source in March 95
;
; revised by Ed Beroset on 12 March 1995
;   optimized for size down to 87 bytes in original 320x200 mode
;   or 88 bytes for new 640x480 mode
;   added comments, equates & header & posted revised source
;
; revised by Keith Huntington on 14 March 1995
;   Just a minor speed optimization (with no size penalty, of course)
;
; to assemble & link:
;   TASM /m2 mandel         (assemble using two pass mode if required)
;   TLINK /Tdc mandel       (link Target platform is DOS, COM file)
;
; This code is in the public domain.
;

;HIRES = 1             ; undefine this for the regular low res version
                      ; or leave it defined for hi res (88 bytes)

ifndef HIRES          ; the original mode
  VIDSEG     = 0a000h ; the video segment (real mode)
  VIDMODE    = 13h    ; use mode 13h
  PIXWIDTH   = 320    ; ... which is 320x200
  PIXHEIGHT  = 200
  TWIDDLE    = -64    ; any 16 bit signed integer may be used
  THRESHOLD  =   4    ; must be in the range of (0,255)
;  BIOSPIXEL = 1      ; defining this will increase COM size by one
                      ;  and turn the picture "upside down"  (which end
                      ;  is up on a fractal?!)
else
  BIOSPIXEL =  1      ; BIOS routine must be used for this mode
  VIDMODE   = 12h     ; use mode 12h
  PIXWIDTH  = 640     ; ... which is 640x480
  PIXHEIGHT = 480
  TWIDDLE   = 140     ; any 16 bit signed integer may be used
  THRESHOLD =   4     ; must be in the range of (0,255)
endif

TEXTMODE   = 3        ; our exit video mode (80x25 color text mode)

_code segment para public 'code'
  assume cs:_code, ds:_code, ss:_code
  org 100h
main proc near
        mov     bp, sp          ; save stack pointer for later
        mov     ax, VIDMODE     ; change video mode
        int     10h             ; do it now
ifndef BIOSPIXEL
        mov     dx, VIDSEG      ; get video segment
        mov     es, dx          ; into es
        xor     di, di          ; di = 0
endif
        mov     cx, PIXHEIGHT   ; height of screen in pixels
        mov     si, TWIDDLE     ; arbitrary offset
@CalcRow:
        push    cx              ; save the row pointer on the stack
ifdef BIOSPIXEL
        mov     cx, PIXWIDTH-1  ; width of screen in pixels
else
        mov     cx, PIXWIDTH    ; width of screen in pixels
endif
@CalcPixel:
        push    cx              ; save the column counter on stack
        xor     cx, cx          ; clear out color loop counter
        xor     bx, bx          ; zero i coefficient
        xor     dx, dx          ; zero j coefficient
@CycleColors:
        push    dx              ; save j value for later
        mov     ax, bx          ; ax = i
        sub     ax, dx          ; ax = i - j
        add     dx, bx          ; dx = i + j
        imul    dx              ; dx:ax = (i+j)*(i-j) = i*i - j*j

;       mov     al,dl           ; save middle bits (i*i - j*j)/100h
;       xchg    ah,al           ; swap hi & lo middle bits
;       xchg    bx,ax           ; now swap new i with old i
;       pop     dx              ; retrieve our saved value for j

        ; --- kjh ---
        ;
        ; Obviously, this whole code exercise is sacrificing speed
        ; for code size, so I won't belabor the obvious size vs.
        ; speed tradeoffs being nastily made here. But with that in
        ; mind, I'd still change the above four instructions to the
        ; following four: it achieves the same thing, for the same
        ; codesize, but trades a minimum-3-cycle xchg instruction for
        ; a 2-cycle mov instruction. So we do gain speed at no cost
        ; in our precious code size <grin>.
        ;
        ; I also moved the location of the pop dx for (IMO) a bit
        ; more clarity, but that's purely cosmetic...
        ;
        ; --- kjh ---

        mov     al,ah           ; Save hi middle bits
        mov     ah,dl           ; Save middle bits (i*i - j*j)/100h
        xchg    bx,ax           ; now swap new i with old i
        pop     dx              ; retrieve our saved value for j

        sub     bx,[bp-4]       ; subtract vertical line counter
        add     bx,si           ; account for base offset...
        cmp     bh,THRESHOLD    ; Q: is i > THRESHOLD * 256?
        jg      @draw           ; Y: draw this pixel
        imul    dx              ; now dx:ax = old i * j
        mov     dh, dl          ; grab middle bits again
        mov     dl, ah          ; arrange them neatly
        shl     dx, 1           ; save mid bits (i * j)/200h
        sub     dx,[bp-2]       ; subtract out horz line counter
        add     dx,si           ; account for base offset...
        inc     cl              ; increment color
        jnz     @CycleColors    ; keep going until we're done
@draw:                          ;
        mov     ax, cx          ; mov color into al and clear ah
        pop     cx              ; retrieve our column counter
ifndef BIOSPIXEL
        stosb                   ; write the pixel
else
        pop     dx              ; fetch row (column already in cx)
        push    dx              ; must leave a copy on the stack
        xor     bh,bh           ; write to video page zero
        mov     ah,0ch          ; write pixel command
        int     10h             ; video BIOS call
endif
        loop    @CalcPixel      ; this is shorter by one byte
        pop     cx              ;
        loop    @CalcRow        ; again, we saved a byte
ifdef BIOSPIXEL
        mov     ax,TEXTMODE     ; change back to regular video mode
else
        mov     al,TEXTMODE     ; ah is already 0 at this point
endif
        int     10h             ; change video mode back to text mode
        ret                     ;
main endp
_code ends
end  main

