program right_oop;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{ Program to illustrate the use of Virtual Methods in         }
{ object-oriented programming. Compare the behaviour of this  }
{ program with the program WRONGOOP.PAS which does not use    }
{ virtual methods.                                            }
{                                                             }
{ RIGHTOOP.PAS  ->  RIGHTOOP.EXE   R. Shaw  26.4.91   31.5.93 }
{_____________________________________________________________}

uses Crt;

type

staff = object
      Name : string;
      constructor Init(SurName : string );
      procedure script1;  virtual;        {virtual procedures which are   }
      procedure script2;  virtual;        {overridden in the object junior}
      procedure action1;            {static procedures which are inherited}
      procedure action2;            {by the descendant object junior.     }
      end;

junior = object( staff )
           procedure script1;  virtual;     {virtual procedures which     }
           procedure script2;  virtual;     {override inherited procedures}
         end;

var
   LetterName : string;

constructor staff.Init( SurName : string );
begin
     Name := SurName;
end;

procedure staff.script1;
begin
     writeln( Name,
         ': Please send the duplicated letters to all our customers.');
     writeln( '        If you have a problem, please ask me.');
end;

procedure staff.script2;
begin
     LetterName := 'OD';
     writeln(Name,': The letter is headed ',LetterName,'.');
     writeln;
end;

procedure staff.action1;
begin
     script1;
end;

procedure staff.action2;
begin
     script2;
end;


procedure junior.script1;
begin
     writeln;
     writeln( '< later >');
     writeln;
     writeln( Name, ': I do not know the letter to send for an overdraft.');
     writeln;
end;

procedure junior.script2;
begin
     writeln( Name, ': Thank you. ');
     writeln;
     writeln( '< later still >' );
     writeln;
     writeln( Name, ': As you requested, I sent the letter headed ',LetterName,'.');
end;

{Main}

var
   Young      : junior;
   Old        : staff;

begin
     clrscr;

     Young.Init( 'NEWMAN' );
     Old.Init( 'SENIOR' );

     Old.action1;
     Young.action1;
     Old.action2;
     Young.action2;

     gotoXY(10,24);
     write('Press any key to conclude: ');
     repeat until keypressed;
     clrscr;
end.

{ end of listing }
