{
        Object-Oriented Archive-viewer: ARC-part
}

unit OOAVArc;

interface

uses      Dos,OOAV;

Type      AFHeader = Record
                 HeadId  : byte;
                 DataType : byte;   { 0 = no more data }
                 Name     : array[0..12] of char;
                 CompSize : longint;
                 FileDate : word;
                 FileTime : word;
                 Crc      : word;
                 OrigSize : longint;
               end;


type      PArcArchive=^TArcArchive;
          TArcArchive=object(TGeneralArchive)
                        constructor Init;
                        procedure FindFirst(var sr:SearchRec);virtual;
                        procedure FindNext(var sr:SearchRec);virtual;
                      private
                        _FHdr:AFHeader;
                        _SL:longint;
                        procedure GetHeader(var sr:SearchRec);
                      end;

implementation

const     BSize=4096;
var       BUFF:array[1..BSize] of Byte;



constructor TArcArchive.Init;
begin
  FillChar(_FHdr,sizeof(_FHdr),0);
end;


procedure TArcArchive.GetHeader(var sr:SearchRec);
var       bc:word;
          b:byte;
begin
  FillChar(_FHdr,SizeOf(_FHdr),#0);
  FillChar(BUFF,BSize,#0);
  Seek(_FArchive,_SL);
  BlockRead(_FArchive,BUFF,BSIZE,bc);
  Move(BUFF[1],_FHdr,SizeOf(_FHdr));
  with _FHdr do
  begin
    if DataType<>0 then
    begin
      b:=0;sr.Name:='';
      while Name[b]<>#0 do
      begin
        if Name[b]='/' then
          sr.Name:=''
        else
          sr.Name:=sr.Name+Name[b];
        inc(b);
      end;
      sr.Size:=OrigSize;
      if DataType=0 then sr.Size:=0;
      sr.Time:=FileDate*longint(256*256)+FileTime;
      inc(_SL,CompSize);
      inc(_SL,sizeof(_FHDR));
    end;
  end;
end;


Procedure TArcArchive.FindFirst(var sr:SearchRec);
begin
 _SL:=0;
 GetHeader(sr);
end;


procedure TArcArchive.FindNext(var sr:SearchRec);
begin
 GetHeader(sr);
end;


end.