/* Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* srle.c */
/* RunLengthDecode filter */
#include "stdio_.h"		/* includes std.h */
#include "memory_.h"
#include "strimpl.h"
#include "srlx.h"

/* ------ RunLengthDecode ------ */

private_st_RLD_state();

#define ss ((stream_RLD_state *)st)

/* Refill the buffer */
private int
s_RLD_process(stream_state *st, stream_cursor_read *pr,
  stream_cursor_write *pw, bool last)
{	register const byte *p = pr->ptr;
	register byte *q = pw->ptr;
	const byte *rlimit = pr->limit;
	byte *wlimit = pw->limit;
	int status = 0;

	while ( p < rlimit )
	{	int b = *++p;
		if ( b < 128 )
		{	if ( b >= rlimit - p )
			{	p--;
				break;
			}
			else if ( b >= wlimit - q )
			{	p--;
				status = 1;
				break;
			}
			memcpy(q + 1, p + 1, ++b);
			p += b;
			q += b;
		}
		else if ( b == 128 )	/* end of data */
		{	if ( ss->EndOfData )
			  {	status = EOFC;
				break;
			  }
		}
		else if ( p == rlimit )
		{	p--;
			break;
		}
		else if ( (b = 257 - b) > wlimit - q )
		{	p--;
			status = 1;
			break;		/* won't fit */
		}
		else
		{	memset(q + 1, *++p, b);
			q += b;
		}
	}
	pr->ptr = p;
	pw->ptr = q;
	return status;
}

#undef ss

/* Stream template */
const stream_template s_RLD_template =
{	&st_RLD_state, NULL, s_RLD_process, 129, 128
};
