
#include "pmc.h"
#include "dflib.h"

/****************************************************************************
*   df_open
*
*       open a DATAFILE lib
*
*   In:     filename    =   datafile file name
*
*   Out:    file handle if datafile
*           NULL if error
*
****************************************************************************/

WORD __cdecl df_open(STR filename)
{
    DWORD   file,temp;

    if(hiWORD(file=fileopen(filename,RDWR))!=NULL) return(NULL);
    filelseek(loWORD(file),DF_SIGN_OFF,SEEK_END);
    fileread(loWORD(file),&temp,DF_SIGN_SIZE);
    if(temp!=DF_SIGN) {             // check if a real datafile
        fileclose(loWORD(file));
        return(NULL);
    }
    return(loWORD(file));
}

/****************************************************************************
*   df_close
*
*       close a DATAFILE lib
*
*   In:     df_handle   =   datafile file handle
*
****************************************************************************/

void __cdecl df_close(WORD df_handle)
{
    fileclose(df_handle);
}

/****************************************************************************
*   df_getinfos
*
*       get infos of a DATAFILE lib
*
*   In:     df_handle   =   datafile file handle
*
*   Out:    pointer to datafile infos if datafile
*           NULL if error
*
****************************************************************************/

DATAFILE * __cdecl df_getinfos(WORD df_handle)
{
    DWORD   temp;
    WORD    file,nfiles;
    DATAFILE    *datafileinfo,*dftemp1,*dftemp2;
    DWORD   nbuf;

    filelseek(df_handle,DF_SIGN_OFF,SEEK_END);  // is a datafile lib ?
    fileread(df_handle,&temp,DF_SIGN_SIZE);
    if(temp==DF_SIGN) {

        filelseek(df_handle,DF_OFFSET_OFF,SEEK_END); // get header offset
        fileread(df_handle,&temp,DF_OFFSET_SIZE);

        filelseek(df_handle,-temp,SEEK_END);         // get num of files
        fileread(df_handle,&nfiles,DF_NFILES_SIZE);

        if(nfiles) {                             // allocate mem for dfinfo
            if(!(datafileinfo=(DATAFILE *)malloc(sizeof(DATAFILE)))) return(NULL);
        } else {
            return(NULL);
        }

        fileread(df_handle,datafileinfo->name,DF_NAME_S); // get 1st dfinfo
        fileread(df_handle,&nbuf,DF_OFFSET_S); // get 1st dfinfo
        datafileinfo->offset=nbuf;
        fileread(df_handle,&nbuf,DF_LENGTH_S); // get 1st dfinfo
        datafileinfo->length=nbuf;

        datafileinfo->next=NULL;
        nfiles--;
        dftemp1=datafileinfo;

        while(nfiles) {                           // while files
            if(!(dftemp2=(DATAFILE *)malloc(sizeof(DATAFILE)))) {
                df_delinfos(datafileinfo);          // no memory, del all
                return(NULL);
            }

            fileread(df_handle,dftemp2->name,DF_NAME_S); // get 1st dfinfo
            fileread(df_handle,&nbuf,DF_OFFSET_S); // get 1st dfinfo
            dftemp2->offset=nbuf;
            fileread(df_handle,&nbuf,DF_LENGTH_S); // get 1st dfinfo
            dftemp2->length=nbuf;

            dftemp1->next=dftemp2;                  // link prev with this
            dftemp1=dftemp2;
            dftemp1->next=NULL;
            nfiles--;
        }
        return(datafileinfo);
    }
    return(NULL);
}

/****************************************************************************
*   df_delinfos
*
*       delete DATAFILE infos data from mem
*
*   In:     datafileinfo    =   pointer to datafile infos
*
****************************************************************************/

void __cdecl df_delinfos(DATAFILE *datafileinfo)
{
    DATAFILE *dftemp=NULL;

    while(datafileinfo) {
        dftemp=datafileinfo->next;
        free(datafileinfo);
        datafileinfo=dftemp;
    }
}

/****************************************************************************
*   df_read
*
*       read a file of a DATAFILE lib in memory
*
*   In:     df_handle   =   datafile file handle
*           datafileinfo=   pointer to a datafile info struct
*           name        =   name of file in lib
*           buffer      =   pointer of a supplied ram buffer
*                           NULL ,memory allocated by df_read
*
*   Out:    pointer to a mem buffer
*           NULL if error
*
****************************************************************************/

PTR __cdecl df_read(WORD df_handle,DATAFILE *datafileinfo,STR name,PTR buffer)
{
    PTR     tbuffer;

    tbuffer=buffer;

    while(datafileinfo!=NULL) { // search the name in dfinfo
        if(!(strncmp(name,datafileinfo->name,strlen(name)))) {
            if (!tbuffer)   // allocate memory if needed
                if(!(tbuffer=(PTR)malloc(datafileinfo->length))) {
                    return(NULL);
                }
            filelseek(df_handle,-(datafileinfo->offset),SEEK_END); // set pos
            fileread(df_handle,tbuffer,datafileinfo->length); // read in mem
            return(tbuffer);
        }
        datafileinfo=datafileinfo->next;
    }
    return(NULL);
}

