/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*            This module was originally written by Bob Hartman             */
/*                                                                          */
/*            BinkleyTerm "Main" Module: Terminal Emulation and             */
/*                        File Transfer dispatching                         */
/*                                                                          */
/*                                                                          */
/*                       BinkleyTerm Licensing Terms                        */
/*                                                                          */
/*                                                                          */
/*              (C) Copyright 1987-96 Bit Bucket Software Co.               */
/*    ALL RIGHTS RESERVED. COMMERCIAL DISTRIBUTION AND/OR USE PROHIBITED    */
/*          WITHOUT WRITTEN PERMISSION FROM BIT BUCKET SOFTWARE CO.         */
/*                                                                          */
/* Non-Commercial distribution and/or use is permitted under the following  */
/* terms:                                                                   */
/*                                                                          */
/*                                                                          */
/* 1. You may copy and distribute verbatim copies of BinkleyTerm source,    */
/* documentation, and executable code as you receive it, in any medium,     */
/* provided that you conspicuously and appropriately publish on each copy a */
/* valid copyright notice "(C) Copyright 1987-96, Bit Bucket Software Co."; */
/* keep intact the notices on all files that refer to this License          */
/* Agreement and to the absence of any warranty;  PROVIDE UNMODIFIED COPIES */
/* OF THE DOCUMENTATION AS PROVIDED WITH THE PROGRAM; and give any other    */
/* recipients of the BinkleyTerm program a copy of this License Agreement   */
/* along with the program.  You may charge a distribution fee for the       */
/* physical act of transferring a copy, but no more than is necessary to    */
/* recover your actual costs incurred in the transfer. Under no             */
/* circumstances is BinkleyTerm to be distributed in such a way as to be    */
/* construed as "value added" in a sales transaction, such as, but not      */
/* limited to, software bundled with a modem or CD-ROM software             */
/* collections.                                                             */
/*                                                                          */
/* 2. You may modify your copy or copies of BinkleyTerm or any portion of   */
/* it, and copy and distribute such modifications under the terms of        */
/* Paragraph 1 above, provided that you also do the following:              */
/*                                                                          */
/*     a) cause the modified files to carry prominent notices stating       */
/*     that you changed the files and the date of any change;               */
/*                                                                          */
/*     b) cause the executable code of such modified version to clearly     */
/*     identify itself as such in the course of its normal operation;       */
/*                                                                          */
/*     c) if the modified version is not a "port", but operates in the      */
/*     same hardware and/or software environment as the original            */
/*     distribution, make the original version equally available,           */
/*     clearly identifying same as the original, unmodified version;        */
/*                                                                          */
/*     d) cause the whole of any work that you distribute or publish,       */
/*     that in whole or in part contains or is a derivative of              */
/*     BinkleyTerm or any part thereof, to be licensed at no charge to      */
/*     all third parties on terms identical to those contained in this      */
/*     License Agreement (except that you may choose to grant more          */
/*     extensive warranty protection to some or all third parties, at       */
/*     your option); and                                                    */
/*                                                                          */
/*     e) send the complete source code modifications to Bit Bucket         */
/*     Software Co. at one of the addresses listed below,  for the          */
/*     purpose of evaluation for inclusion in future releases of            */
/*     BinkleyTerm.  Should your source code be included in BinkleyTerm,    */
/*     Bit Bucket Software Co. retains all rights for redistribution of     */
/*     the code as part of BinkleyTerm and all derivative works, with       */
/*     appropriate credit given to the author of the modification.          */
/*                                                                          */
/*     f) You may charge a distribution fee for the physical act of         */
/*     transferring a copy, but no more than is necessary to recover        */
/*     your actual costs incurred in the transfer, and you may at your      */
/*     option offer warranty protection in exchange for a fee.              */
/*                                                                          */
/* 3. Mere aggregation of another unrelated program with this program and   */
/* documentation (or derivative works) on a volume of a storage or          */
/* distribution medium does not bring the other program under the scope of  */
/* these terms.                                                             */
/*                                                                          */
/* 4. You may copy and distribute BinkleyTerm and its associated            */
/* documentation (or a portion or derivative of it, under Paragraph 2) in   */
/* object code or executable form under the terms of Paragraphs 1 and 2     */
/* above provided that you also do one of the following:                    */
/*                                                                          */
/*     a) accompany it with the complete corresponding machine-readable     */
/*     source code, which must be distributed under the terms of            */
/*     Paragraphs 1 and 2 above; or,                                        */
/*                                                                          */
/*     b) accompany it with a written offer, valid for at least three       */
/*     years, to give any third party free (except for a nominal            */
/*     shipping charge) a complete machine-readable copy of the             */
/*     corresponding source code, to be distributed under the terms of      */
/*     Paragraphs 1 and 2 above; or,                                        */
/*                                                                          */
/*     c) accompany it with the information you received as to where        */
/*     the corresponding source code may be obtained.  (This                */
/*     alternative is allowed only for noncommercial distribution and       */
/*     only if you received the program in object code or executable        */
/*     form alone.)                                                         */
/*                                                                          */
/* For an executable file, complete source code means all the source code   */
/* for all modules it contains; but, as a special exception, it need not    */
/* include source code for modules which are standard libraries that        */
/* accompany the operating system on which the executable file runs.        */
/*                                                                          */
/* 5. You may not copy, sublicense, distribute or transfer BinkleyTerm and  */
/* its associated documentation  except as expressly provided under this    */
/* License Agreement.  Any attempt otherwise to copy, sublicense,           */
/* distribute or transfer BinkleyTerm is void and your rights to use the    */
/* program under this License agreement shall be automatically terminated.  */
/* However, parties who have received computer software programs from you   */
/* with this License Agreement will not have their licenses terminated so   */
/* long as such parties remain in full compliance, and notify Bit Bucket    */
/* Software Co. of their intention to comply with this Agreement.           */
/*                                                                          */
/* 6. If you wish to incorporate parts of BinkleyTerm into other free       */
/* programs whose distribution conditions are different, please contact     */
/* Bit Bucket Software Co. at one of the addresses listed below.  We have   */
/* not yet worked out a simple rule that can be stated here, but we will    */
/* usually permit this.  We will be guided by the two goals of preserving   */
/* the free status of all derivatives of our free software (as it pertains  */
/* to Non-Commercial use as provided by this Agreement) and of promoting    */
/* the sharing and reuse of software.                                       */
/*                                                                          */
/* 7. For the purposes of this document, "COMMERCIAL USE" is defined as     */
/* operation of the software on four or more computers or data lines owned  */
/* by the same for-profit organization. Any organization may operate this   */
/* software under the terms of this Non-Commercial Agreement if operation   */
/* is limited to three or less computers or data lines.                     */
/*                                                                          */
/*                                                                          */
/*                                NO WARRANTY                               */
/*                                                                          */
/* BECAUSE BINKLEYTERM IS LICENSED FREE OF CHARGE, WE PROVIDE ABSOLUTELY NO */
/* WARRANTY.  EXCEPT WHEN OTHERWISE STATED IN WRITING, BIT BUCKET SOFTWARE  */
/* CO. AND/OR OTHER PARTIES PROVIDE BINKLEYTERM "AS IS" WITHOUT WARRANTY OF */
/* ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,    */
/* THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR   */
/* PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF           */
/* BINKLEYTERM, AND THE ACCURACY OF ITS ASSOCIATED DOCUMENTATION, IS WITH   */
/* YOU.  SHOULD BINKLEYTERM OR ITS ASSOCIATED DOCUMENTATION PROVE           */
/* DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR     */
/* CORRECTION.                                                              */
/*                                                                          */
/* IN NO EVENT WILL BIT BUCKET SOFTWARE CO. BE RESPONSIBLE IN ANY WAY FOR   */
/* THE BEHAVIOR OF MODIFIED VERSIONS OF BINKLEYTERM. IN NO EVENT WILL       */
/* BIT BUCKET SOFTWARE CO. AND/OR ANY OTHER PARTY WHO MAY MODIFY AND        */
/* REDISTRIBUTE BINKLEYTERM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR        */
/* DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR OTHER SPECIAL,      */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY  */
/* TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED */
/* INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A FAILURE OF THE      */
/* PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS) BINKLEYTERM, EVEN IF YOU     */
/* HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, OR FOR ANY CLAIM   */
/* BY ANY OTHER PARTY.                                                      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/* Our thanks to Richard Stallman and the Free Software Foundation, Inc.,   */
/* for most of the wording of this License.                                 */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#ifndef NO_SIGNALS
SIGTYPE handler (SIGARGS);

#endif

MAINTYPE
main (int argc, char *argv[])
{
	int done;
	char *envptr;
	ADDR baddr;
	long init_timer;
	char *poll_addr = NULL;

	(void) load_language ();

#ifndef NO_SIGNALS
	if (signal (SIGINT, handler) == SIG_ERR)
	{
		(void) fprintf (stderr, MSG_TXT (M_NO_SIGINT));
	}
#ifdef SIGBREAK
	(void) signal (SIGBREAK, SIG_IGN);
#endif
#endif

	(void) printf (ANNOUNCE);
	(void) printf ("\n(C) Copyright 1987-96, Bit Bucket Software, Co. ALL RIGHTS RESERVED.\n\n");
	(void) printf (MSG_TXT (M_SYSTEM_INITIALIZING));
	init_timer = timerset (200);
	b_initvars ();

	while (--argc)
	{
		++argv;

		switch (parse (argv[0], DOS_commands))
		{
		case 1:				/* Noforce    */
			noforce = 1;
			break;

		case 2:				/* Mail       */
			++mail_only;
			break;

		case 3:				/* Share      */
			++share;
			break;

		case 4:				/* Dynam      */
			++redo_dynam;
			break;

		case 5:				/* Unattended */
			un_attended = 1;
			command_line_un = 1;
			break;

		case 6:				/* Config     */
			config_name = argv[1];
			--argc;
			++argv;
			break;

		case 7:				/* Poll       */
			poll_addr = argv[1];
			--argc;
			++argv;
			break;

		default:				/* Not there  */
			(void) printf (MSG_TXT (M_UNRECOGNIZED_OPTION), argv[0]);
			exit (1);
		}
	}

	envptr = getenv (PRDCT_PRFX);	/* get path from environment */
	if ((envptr != NULL)		/* If there was one, and     */
		&& (!dexists (config_name)))	/* No BINKLEY.CFG locally,   */
	{
		BINKpath = calloc (1, (strlen (envptr) + 2));	/* make room for new */
		(void) strcpy (BINKpath, envptr);	/* use BINKLEY as our path   */
		(void) add_backslash (BINKpath);
	}
	else
		BINKpath = "";

	(void) memset (&hist, 0x00, sizeof(HISTORY)); 

	read_sched ();
	parse_config (PRDCT_PRFX ".Evt");
	parse_config (config_name);
	b_defaultvars ();

	/* We have everything we need to handle addresses now.
    * Parse the 'poll' address if there was one.
    */

	if (poll_addr != NULL && find_address (poll_addr, &baddr))
	{
		doing_poll = 1;
	}

	(void) LoadScanList (0, 0);	/* Get default scan list */

	/* We expect this to fail right away, but in order to keep the copyright
      notice displayed long enough, we check anyway */

	while (!timeup (init_timer))
		time_release ();

	done = 0;

	if (fullscreen)
		b_sbinit ();

	if (mail_only)
	{
		doing_poll = 1;
		baddr = boss_addr;
	}

	start_hist = hist;

	if (doing_poll)
	{
		if (baddr.Zone == 0)
			baddr.Zone = alias[0].Zone;
		un_attended = 1;
		opening_banner ();
		mailer_banner ();
		if (fullscreen)
		{
			(void) sprintf (junk, "%s", Full_Addr_Str (&baddr));
			junk[28] = '\0';

			sb_fill (holdwin, ' ', colors.hold);
			sb_move (holdwin, 2, 12);
			sb_puts (holdwin, MSG_TXT (M_POLLING_COLON));
			sb_move (holdwin, 4, (short) (16 - strlen (junk) / 2));
			sb_puts (holdwin, junk);
			sb_show ();
		}
		set_prior (4);			/* Always High */
		if (!CARRIER)
			mdm_hangup ();
		(void) do_mail (&baddr, 1);
		set_prior (2);			/* Regular */
		done = 1;
	}
	else if (!un_attended)
	{
		opening_banner ();
	}

	while (!done)
	{
		if (un_attended)
		{
			done = unattended ();
			un_attended = 0;
		}
		else
		{
			done = b_term ();
			un_attended = done ? 0 : 1;
		}
	}

	b_exitproc ();

	exit (1);
}

#ifndef NO_SIGNALS
SIGTYPE
handler (SIGARGS)				/* Function called at system interrupt */
{
#ifdef SIGNAL_ARGUMENT
	happy_compiler = (int) sigarg;	/* For the compiler */
#endif
	(void) signal (SIGINT, SIG_IGN);	/* Disallow CTRL + C during handler    */

	ctrlc_ctr++;

	(void) signal (SIGINT, handler);	/* This is necessary so that the
                                       ** next CTRL+C interrupt will call
                                       ** "handler", since the DOS 3.x
                                       ** operating system resets the
                                       ** interrupt handler to the
                                       ** system default after the
                                       ** user-defined handler is called
                                       */
}

#endif
