/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                This module was adapted by Michael Buenter                */
/*               Based on original source file by Arjen Lentz               */
/*                  Hydra CRC calculations for BinkleyTerm                  */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/


/*============================================================ Rev. 17 Jan 1993
  Routines for table driven CRC-16 & CRC-32, including building tables
  Refer to CRC.DOC for information and documentation.
  This file in portable C is 100% interchangable with the CRC.ASM (80x86 ASM).
  -----------------------------------------------------------------------------

          Information collected and edited by Arjen G. Lentz
        Sourcecode in C and 80x86 ASM written by Arjen G. Lentz
        COPYRIGHT (C) 1992-1993; ALL RIGHTS RESERVED


  CONTACT ADDRESS

  LENTZ SOFTWARE-DEVELOPMENT   Arjen Lentz @
  Langegracht 7B      AINEX-BBS +31-33-633916
  3811 BT  Amersfoort      FidoNet 2:283/512
  The Netherlands      arjen_lentz@f512.n283.z2.fidonet.org


  DISCLAIMER

  This information is provided "as is" and comes with no warranties of any
  kind, either expressed or implied. It's intended to be used by programmers
  and developers. In no event shall the author be liable to you or anyone
  else for any damages, including any lost profits, lost savings or other
  incidental or consequential damages arising out of the use or inability
  to use this information.


  LICENCE

  This package may be freely distributed provided the files remain together,
  in their original unmodified form.
  All files, executables and sourcecode remain the copyrighted property of
  Arjen G. Lentz and LENTZ SOFTWARE-DEVELOPMENT.
  Licence for any use granted, provided this notice & CRC.DOC are included.
  For executable applications, credit should be given in the appropriate
  place in the program and documentation.
  These notices must be retained in any copies of any part of this
  documentation and/or software.

  Any use of, or operation on (including copying/distributing) any of
  the above mentioned files implies full and unconditional acceptance of
  this license and disclaimer.

=============================================================================*/

#include "includes.h"
#include "aglcrc.h"

/* ------------------------------------------------------------------------- */
void 
crc16init (word FAR * crctab, word poly)
{
	register int i, j;
	register word crc;

	for (i = 0; i <= 255; i++)
	{
		crc = i;
		for (j = 8; j > 0; j--)
		{
			if (crc & 1)
				crc = (crc >> 1) ^ poly;
			else
				crc >>= 1;
		}
		crctab[i] = crc;
	}
}								/*crc16init()*/

/* ------------------------------------------------------------------------- */
word 
crc16block (word FAR * crctab, word crc, byte FAR * buf, word len)
{
	while (len--)
		crc = crc16upd (crctab, crc, *buf++);

	return (crc);
}								/*crc16block()*/

/* ------------------------------------------------------------------------- */
void 
crc16rinit (word FAR * crctab, word poly)
{
	register int i, j;
	register word crc;

	for (i = 0; i <= 255; i++)
	{
		crc = i << 8;
		for (j = 8; j > 0; j--)
		{
			if (crc & 0x8000)
				crc = (crc << 1) ^ poly;
			else
				crc <<= 1;
		}
		crctab[i] = crc;
	}
}								/*crc16rinit()*/

/* ------------------------------------------------------------------------- */
word 
crc16rblock (word FAR * crctab, word crc, byte FAR * buf, word len)
{
	while (len--)
		crc = crc16rupd (crctab, crc, *buf++);

	return (crc);
}								/*crc16rblock()*/

/* ------------------------------------------------------------------------- */
void 
crc32init (ULONG FAR * crctab, ULONG poly)
{
	register int i, j;
	register ULONG crc;

	for (i = 0; i <= 255; i++)
	{
		crc = i;
		for (j = 8; j > 0; j--)
		{
			if (crc & 1)
				crc = (crc >> 1) ^ poly;
			else
				crc >>= 1;
		}
		crctab[i] = crc;
	}
}								/*crc32init()*/

/* ------------------------------------------------------------------------- */
ULONG 
crc32block (ULONG FAR * crctab, ULONG crc, byte FAR * buf, word len)
{
	while (len--)
		crc = crc32upd (crctab, crc, *buf++);

	return (crc);
}								/*crc32block()*/

/* end of crc.c ------------------------------------------------------------ */
