; 386POWER COMMAND LINE SCANNER:
; EXECUTE _ArgInit BEFORE ANY FILE I/O
; OR THE DEFAULT DTA (the place where the command line arguments are)
; MAY BE TRASHED

; 386arg follows this simple parameter convention:
; Arguments are string made of non-blank (i.e space o tab) characters.
; Strings with a "-" as the first character are command line switches.
; Strings without "-" are file names.

; so: 
;      -DEBUG  -F -f -FOOBAR -SELFDESCTRUCT  -SD  
; are options.
; while:   
;      foobar.dat    d:\LonG\PaTh\Name.dat $%^&$$#  !wow!
;      rock'n'roll  *)(&#  +cool 
; are different file names.
; I found that this simple syntax fits most of my needs.

extrn _ArgInit:near
        ; reads the command line parameters and convert it to a list
        ; of ASCIIZ (c strings) terminated by a null string
        ; No parsing is made on strings
        ; ALL blank character are skipped

extrn _ArgFile:near
        ; reads from the command line the next "file name"
        ; and returns it into ESI, if all file names have been read
        ; or if no file name are present it returns a NULL ASCIIZ
        ; ( a pointer to character 0).

extrn _ArgOpt:near
        ; reads from the command line the next "option"
        ; and returns a pointer to it into ESi, if all options have been read
        ; or if no options are present it returns a NULL ASCIIZ
        ; ( a pointer to character 0).
        ; N.B. the "-" header of the option string is automatically
        ;      discarded


; if you PROGRAM.EXE makes use of 386arg
; and you execute it with the following command line:
; PROGRAM -FOOBAR foo.dat -D gnat warp.001 
; the comman line args are "-FOOBAR foo.dat -D -FROG gnat warp.001"
; The first call to _ArgFile returns into eax a pointer to "foo.dat"
; The 2nd returns "gnat"
; The 3rd returns "warp.001"
; The 4th returns "" (a pointer to ascii char 0, the string terminator)

; If you call _ArgOpt you get:
; "FOOBAR" first, "D" second, "FROG" third and "" fourth

; And if you type: PROGRAM ^&**((%$
; The first call to _ArgFile returns "^&**((%$"
; So check it before trying to open files with the result of _ArgFile

