From eliz@is.elta.co.ilWed Dec 27 18:42:27 1995
Date: Mon, 25 Dec 1995 11:44:41 +0200 (IST)
From: Eli Zaretskii <eliz@is.elta.co.il>
To: Kevin Gallagher <kgallagh@spdmail.spd.dsccc.com>,
    Marc Fleischeuers <marc@mpi.nl>, Mickey Ferguson <mickeyf@stac.com>,
    Morten Welinder <terra@diku.dk>, Karl Heuer <kwzh@gnu.ai.mit.edu>
Cc: Richard Stallman <rms@gnu.ai.mit.edu>
Subject: Menus patch for DOS Emacs

The following patch makes menu titles always stand out.  In the original
code, if the menu was drawn so that the mouse pointer wass ouside the menu
borders, the title wouldn't stand out.  To see the difference, either
press C-mouse-1/C-mouse-2, or start a mode which defines a long menu bar
(like Dired mode) and pull down one of the menu items close to the right
side of the menu bar. 

Mon Dec 25 10:51:01 1995  Eli Zaretskii  <eliz@is.elta.co.il>

	* msdos.c (XMenuActivate): Make sure the menu title is always
	displayed with `msdos-menu-active-face', no matter where the mouse
	pointer is.

*** src/msdos.c~4	Mon Dec 25 10:35:04 1995
--- src/msdos.c	Mon Dec 25 10:39:16 1995
***************
*** 1706,1711 ****
--- 1706,1712 ----
    int screensize;
    int faces[4], selectface;
    int leave, result, onepane;
+   int title_faces[4];		/* face to display the menu title */
  
    /* Just in case we got here without a mouse present...  */
    if (have_mouse <= 0)
***************
*** 1730,1741 ****
    faces[2] = compute_glyph_face (&the_only_frame, selectface, faces[0]);
    faces[3] = compute_glyph_face (&the_only_frame, selectface, faces[1]);
  
    statecount = 1;
    state[0].menu = menu;
    mouse_off ();
    ScreenRetrieve (state[0].screen_behind = xmalloc (screensize));
  
!   IT_menu_display (menu, y0 - 1, x0 - 1, faces); /* display the menu title */
    if ((onepane = menu->count == 1 && menu->submenu[0]))
      {
        menu->width = menu->submenu[0]->width;
--- 1731,1747 ----
    faces[2] = compute_glyph_face (&the_only_frame, selectface, faces[0]);
    faces[3] = compute_glyph_face (&the_only_frame, selectface, faces[1]);
  
+   /* Make sure the menu title is always displayed with
+      `msdos-menu-active-face', no matter where the mouse pointer is.  */
+   for (i = 0; i < 4; i++)
+     title_faces[i] = faces[3];
+ 
    statecount = 1;
    state[0].menu = menu;
    mouse_off ();
    ScreenRetrieve (state[0].screen_behind = xmalloc (screensize));
  
!   IT_menu_display (menu, y0 - 1, x0 - 1, title_faces); /* display menu title */
    if ((onepane = menu->count == 1 && menu->submenu[0]))
      {
        menu->width = menu->submenu[0]->width;

