From eliz@is.elta.co.ilWed Dec 27 18:42:05 1995
Date: Mon, 25 Dec 1995 11:36:47 +0200 (IST)
From: Eli Zaretskii <eliz@is.elta.co.il>
To: Kevin Gallagher <kgallagh@spdmail.spd.dsccc.com>,
    Marc Fleischeuers <marc@mpi.nl>, Mickey Ferguson <mickeyf@stac.com>,
    Morten Welinder <terra@diku.dk>, Karl Heuer <kwzh@gnu.ai.mit.edu>
Cc: Richard Stallman <rms@gnu.ai.mit.edu>
Subject: DOS-specific code on dired.c

The following patch removes DOS-specific code on dired.c which isn't
required anymore, so `dired' will run faster.  Note that `file-attributes'
remains a bottleneck even after this patch (it takes 30 seconds to run on
the lisp/ directory on my machine!), because library `stat' from DJGPP
v1.x opens and reads every file to search for a magic 2-byte signature
which identifies it as an executable file.  This should be much faster in
DJGPP v2.0, as `stat' is faster there. 

Mon Dec 24 13:51:32 1995  Eli Zaretskii  <eliz@is.elta.co.il>

	* dired.c (Ffile_attributes) [MSDOS]: Remove special detection of
	MS-DOS executable files by filename extension (library `stat' does
	this itself now).  This speeds up `dired' by 10-15%.

*** src/dired.c~0	Sat Sep  2 01:19:12 1995
--- src/dired.c	Sun Dec 24 13:03:46 1995
***************
*** 621,642 ****
    if (lstat (XSTRING (filename)->data, &s) < 0)
      return Qnil;
  
- #ifdef MSDOS
-   {
-     char *tmpnam = XSTRING (Ffile_name_nondirectory (filename))->data;
-     int l = strlen (tmpnam);
- 
-     if (l >= 5 
- 	&& S_ISREG (s.st_mode)
- 	&& (stricmp (&tmpnam[l - 4], ".com") == 0
- 	    || stricmp (&tmpnam[l - 4], ".exe") == 0
- 	    || stricmp (&tmpnam[l - 4], ".bat") == 0))
-       {
- 	s.st_mode |= S_IEXEC;
-       }
-   }
- #endif /* MSDOS */
- 
    switch (s.st_mode & S_IFMT)
      {
      default:
--- 621,626 ----
