;======================================================================
TITLE "Rosemail upload/download, with attached files (from roseatt.rs).
;----------------------------------------------------------------------
PARAMETER 1 "Hang up after getting qwk packet (Y/N)"
ENDPARAMS

    ; Verify that the 3 necessary parameters were entered.
    IF EMPTY "%ID%" GOTO PARAM_ERROR
    IF EMPTY "%QWKDIR%" GOTO PARAM_ERROR
    IF EMPTY "%REPDIR%" GOTO PARAM_ERROR

    ; Default to twenty minutes to scan for mail.
    ; Edit this if desired.
    TIMEOUT 1200

    ; Get to mail door
    VENUE MAIL

:SENDREP
    IF NOT EXIST "%REPDIR%%ID%.REP" GOTO NOREP
    SEND "U|"
;   WAITFOR "%BBS42%" FAILURE GOTO I_AM_LOST
    WAITFOR "<UPLOAD>" FAILURE GOTO I_AM_LOST
                                                          
    MESSAGE "Uploading %REPDIR%%ID%.REP"
    UPLOAD "%REPDIR%%ID%.REP" USING "%BBS21%"
    WAITFOR "<MESSAGES INSERTED>" FAILURE GOTO SLOW_BBS
    ; Will keep up to 2 old rep packets.  Edit if desired.
    RENUMBER "%REPDIR%%ID%.REP" 2
GOTO GETREP

:NOREP
    MESSAGE "No %REPDIR%%ID%.REP to send"

:GETREP
    ; Request the packet
    MESSAGE "Requesting download"
    SEND "D|"
:CHKREP
    MESSAGE "Waiting for file download, or end of message scan"
    WHEN "<FILEDOWN>" GOTO FILEDOWN
    WHEN "%BBS43%" SEND "Y|"
    WHEN "%BBS44%" GOTO ENDRUN
    WHEN "<DOWNLOAD>" GOTO RENUM
    WAITFOR "<WILL NEVER GET THIS>" FAILURE GOTO SLOW_BBS
    GOTO CHKREP

:FILEDOWN
    DOWNLOAD
    MESSAGE "File download completed, returning to chkrep"
    GOTO CHKREP

:RENUM
    ; Keep 2 old QWK packets by default.
    ; Edit this if desired.
    IF EXIST "%QWKDIR%%ID%.QWK" RENUMBER "%QWKDIR%%ID%.QWK" 2

    ; Download the QWK packet.
    MESSAGE "Downloading %QWKDIR%%ID%.QWK"
    DOWNLOAD "%QWKDIR%%ID%.QWK" USING "%BBS22%"

GOTO ENDRUN

:ENDRUN
    RUN "RCUNZIP.BAT %QWKDIR%%ID%.QWK NEWFILES.DAT"
    IMPORT "NEWFILES.DAT"
    IF YES "%P1%" GOTO DROP_CARRIER
    GOSUB GET_TO_COMMAND
    CLOSE
EXIT 0

:DROP_CARRIER
    MESSAGE "Dropping carrier per request"
    HANGUP
;    CLOSE
EXIT 0

:GET_TO_COMMAND
    SEND "|"
    CLEAR
    WHEN "%BBS32%" SEND "|"
    WHEN "%BBS24%" SEND "|"
    WAITFOR "%BBS40%" FAILURE GOTO I_AM_LOST
RETURN

:SLOW_BBS
    MESSAGE "^UERROR:^U Timeout during mail run."
    HANGUP
    CLOSE
EXIT 1

:I_AM_LOST
    MESSAGE "^UERROR:^U Sorry - I am lost."
    HANGUP
    CLOSE
EXIT 1

:PARAM_ERROR
    MESSAGE "^UERROR:^U Parameters 1 isrequired!"
    CLOSE
EXIT 1
